/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import mondrian.olap.Util;
import mondrian.spi.VirtualFileHandler;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.http.HttpFileObject;

public class ApacheVfsVirtualFileHandler
implements VirtualFileHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readVirtualFile(String url) throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        if (fsManager == null) {
            throw Util.newError("Cannot get virtual file system manager");
        }
        if (url.startsWith("file://localhost")) {
            url = url.substring("file://localhost".length());
        }
        if (url.startsWith("file:")) {
            url = url.substring("file:".length());
        }
        if (url.startsWith("http")) {
            try {
                return new URL(url).openStream();
            }
            catch (IOException e) {
                throw Util.newError("Could not read URL: " + url);
            }
        }
        File userDir = new File("").getAbsoluteFile();
        FileObject file = fsManager.resolveFile(userDir, url);
        FileContent fileContent = null;
        try {
            file.refresh();
            if (file instanceof HttpFileObject && !file.getName().getURI().equals(url)) {
                fsManager.getFilesCache().removeFile(file.getFileSystem(), file.getName());
                file = fsManager.resolveFile(userDir, url);
            }
            if (!file.isReadable()) {
                throw Util.newError("Virtual file is not readable: " + url);
            }
            fileContent = file.getContent();
        }
        finally {
            file.close();
        }
        if (fileContent == null) {
            throw Util.newError("Cannot get virtual file content: " + url);
        }
        return fileContent.getInputStream();
    }
}

