/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.io.File;
import java.io.InputStream;
import mondrian.olap.Util;
import mondrian.spi.VirtualFileHandler;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class ApacheVfs2VirtualFileHandler
implements VirtualFileHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readVirtualFile(String url) throws FileSystemException {
        FileSystemManager fsManager = VFS.getManager();
        if (fsManager == null) {
            throw Util.newError("Cannot get virtual file system manager");
        }
        File userDir = new File("").getAbsoluteFile();
        FileObject file = fsManager.resolveFile(userDir, url);
        FileContent fileContent = null;
        try {
            if (!file.isReadable()) {
                throw Util.newError("Virtual file is not readable: " + url);
            }
            fileContent = file.getContent();
        }
        finally {
            file.close();
        }
        if (fileContent == null) {
            throw Util.newError("Cannot get virtual file content: " + url);
        }
        return fileContent.getInputStream();
    }
}

