/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import mondrian.calc.ExpCompiler;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluationUnsupportedException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDependencyTestingEvaluator;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProfilingEvaluator;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.SqlStatement;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import mondrian.util.ClassResolver;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.StringProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapUtil {
    public static final Logger MDX_LOGGER = Logger.getLogger((String)"mondrian.mdx");
    public static final Logger SQL_LOGGER = Logger.getLogger((String)"mondrian.sql");
    public static final Logger MONITOR_LOGGER = Logger.getLogger((String)"mondrian.server.monitor");
    public static final Logger PROFILE_LOGGER = Logger.getLogger((String)"mondrian.profile");
    static final Logger LOGGER = Logger.getLogger(RolapUtil.class);
    public static final Object valueNotReadyException = 0.0;
    private static ExecuteQueryHook queryHook = null;
    public static final Comparable<?> sqlNullValue = RolapUtilComparable.INSTANCE;
    public static final String NULL_NAME = "#null";
    public static final Comparator ROLAP_COMPARATOR = new RolapUtilComparator();
    private static String mdxNullLiteral = null;
    public static final String SQL_FALSE_LITERAL = "FALSE";
    private static final Set<String> loadedDrivers = new HashSet<String>();

    public static SchemaReader locusSchemaReader(RolapConnection connection, final SchemaReader schemaReader) {
        mondrian.server.Statement statement = connection.getInternalStatement();
        Execution execution = new Execution(statement, 0L);
        final Locus locus = new Locus(execution, "Schema reader", null);
        return (SchemaReader)Proxy.newProxyInstance(SchemaReader.class.getClassLoader(), new Class[]{SchemaReader.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Locus.push(locus);
                try {
                    Object object = method.invoke((Object)schemaReader, args);
                    return object;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
                finally {
                    Locus.pop(locus);
                }
            }
        });
    }

    public static synchronized ExecuteQueryHook getHook() {
        return queryHook;
    }

    public static synchronized void setHook(ExecuteQueryHook hook) {
        queryHook = hook;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String mdxNullLiteral() {
        if (mdxNullLiteral == null) {
            RolapUtil.reloadNullLiteral();
        }
        return mdxNullLiteral;
    }

    public static void reloadNullLiteral() {
        mdxNullLiteral = MondrianProperties.instance().NullMemberRepresentation.get();
    }

    static RolapMember[] toArray(List<RolapMember> v) {
        return v.isEmpty() ? new RolapMember[]{} : v.toArray(new RolapMember[v.size()]);
    }

    static RolapMember lookupMember(MemberReader reader, List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        RolapMember rootMember;
        RolapMember member = RolapUtil.lookupMemberInternal(uniqueNameParts, null, reader, failIfNotFound);
        if (member != null) {
            return member;
        }
        List<RolapMember> rootMembers = reader.getRootMembers();
        if (rootMembers.size() == 1 && (rootMember = rootMembers.get(0)).isAll()) {
            member = RolapUtil.lookupMemberInternal(uniqueNameParts, rootMember, reader, failIfNotFound);
        }
        return member;
    }

    private static RolapMember lookupMemberInternal(List<Id.Segment> segments, RolapMember member, MemberReader reader, boolean failIfNotFound) {
        for (Id.Segment segment : segments) {
            List<RolapMember> children;
            if (!(segment instanceof Id.NameSegment)) break;
            Id.NameSegment nameSegment = (Id.NameSegment)segment;
            if (member == null) {
                children = reader.getRootMembers();
            } else {
                children = new ArrayList<RolapMember>();
                reader.getMemberChildren(member, children);
                member = null;
            }
            for (RolapMember child : children) {
                if (!child.getName().equals(nameSegment.name)) continue;
                member = child;
                break;
            }
            if (member != null) continue;
            break;
        }
        if (member == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCantFindMember.ex(Util.implode(segments));
        }
        return member;
    }

    public static SqlStatement executeQuery(DataSource dataSource, String sql, Locus locus) {
        return RolapUtil.executeQuery(dataSource, sql, null, 0, 0, locus, -1, -1, null);
    }

    public static SqlStatement executeQuery(DataSource dataSource, String sql, List<SqlStatement.Type> types, int maxRowCount, int firstRowOrdinal, Locus locus, int resultSetType, int resultSetConcurrency, Util.Function1<Statement, Void> callback) {
        SqlStatement stmt = new SqlStatement(dataSource, sql, types, maxRowCount, firstRowOrdinal, locus, resultSetType, resultSetConcurrency, callback);
        stmt.execute();
        return stmt;
    }

    public static void alertNonNative(String functionName, String reason) throws NativeEvaluationUnsupportedException {
        String alertMsg = "Unable to use native SQL evaluation for '" + functionName + "'; reason:  " + reason;
        StringProperty alertProperty = MondrianProperties.instance().AlertNativeEvaluationUnsupported;
        String alertValue = alertProperty.get();
        if (alertValue.equalsIgnoreCase(Level.WARN.toString())) {
            LOGGER.warn((Object)alertMsg);
        } else if (alertValue.equalsIgnoreCase(Level.ERROR.toString())) {
            LOGGER.error((Object)alertMsg);
            throw MondrianResource.instance().NativeEvaluationUnsupported.ex(functionName);
        }
    }

    public static synchronized void loadDrivers(String jdbcDrivers) {
        StringTokenizer tok = new StringTokenizer(jdbcDrivers, ",");
        while (tok.hasMoreTokens()) {
            String jdbcDriver = tok.nextToken();
            if (!loadedDrivers.add(jdbcDriver)) continue;
            try {
                ClassResolver.INSTANCE.forName(jdbcDriver, true);
                LOGGER.info((Object)("Mondrian: JDBC driver " + jdbcDriver + " loaded successfully"));
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn((Object)("Mondrian: Warning: JDBC driver " + jdbcDriver + " not found"));
            }
        }
    }

    public static ExpCompiler createDependencyTestingCompiler(ExpCompiler compiler) {
        return new RolapDependencyTestingEvaluator.DteCompiler(compiler);
    }

    public static RolapMember findBestMemberMatch(List<RolapMember> members, RolapMember parent, RolapCubeLevel level, Id.Segment searchName, MatchType matchType) {
        if (!(searchName instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)searchName;
        switch (matchType) {
            case FIRST: {
                return members.get(0);
            }
            case LAST: {
                return members.get(members.size() - 1);
            }
        }
        RolapMember searchMember = null;
        RolapMember bestMatch = null;
        for (RolapMember member : members) {
            int rc;
            if (nameSegment.quoting == Id.Quoting.KEY && member instanceof RolapMember && member.getKey().toString().equals(nameSegment.name)) {
                return member;
            }
            if (matchType.isExact()) {
                rc = Util.compareName(member.getName(), nameSegment.name);
            } else {
                if (searchMember == null) {
                    searchMember = level.getHierarchy().createMember(parent, level, nameSegment.name, null);
                }
                rc = FunUtil.compareSiblingMembersByName(member, searchMember);
            }
            if (rc == 0) {
                return member;
            }
            if (matchType == MatchType.BEFORE) {
                if (rc >= 0 || bestMatch != null && FunUtil.compareSiblingMembersByName(member, bestMatch) <= 0) continue;
                bestMatch = member;
                continue;
            }
            if (matchType != MatchType.AFTER || rc <= 0 || bestMatch != null && FunUtil.compareSiblingMembersByName(member, bestMatch) >= 0) continue;
            bestMatch = member;
        }
        if (matchType.isExact()) {
            return null;
        }
        return bestMatch;
    }

    public static ExpCompiler createProfilingCompiler(ExpCompiler compiler) {
        return new RolapProfilingEvaluator.ProfilingEvaluatorCompiler(compiler);
    }

    public static RolapSchema.PhysView convertInlineTableToRelation(RolapSchema.PhysInlineTable inlineTable, Dialect dialect) {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        for (RolapSchema.PhysColumn col : inlineTable.columnsByName.values()) {
            columnNames.add(col.name);
            columnTypes.add(col.datatype.name());
        }
        String sql = dialect.generateInline(columnNames, columnTypes, inlineTable.rowList);
        return new RolapSchema.PhysView(inlineTable.physSchema, inlineTable.alias, sql);
    }

    public static Evaluator createEvaluator(mondrian.server.Statement statement) {
        Execution dummyExecution = new Execution(statement, 0L);
        RolapResult result = new RolapResult(dummyExecution, false);
        return result.getRootEvaluator();
    }

    public static interface ExecuteQueryHook {
        public void onExecuteQuery(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RolapUtilComparator<T extends Comparable<T>>
    implements Comparator<T> {
        private RolapUtilComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            try {
                return o1.compareTo(o2);
            }
            catch (ClassCastException cce) {
                if (o2 == RolapUtilComparable.INSTANCE) {
                    return 1;
                }
                throw new MondrianException(cce);
            }
        }
    }

    private static final class RolapUtilComparable
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -2595758291465179116L;
        public static final RolapUtilComparable INSTANCE = new RolapUtilComparable();

        private RolapUtilComparable() {
        }

        public String toString() {
            return RolapUtil.NULL_NAME;
        }

        public int compareTo(Object o) {
            return o == this ? 0 : -1;
        }
    }
}

