/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.Access;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.TupleReader;
import mondrian.rolap.cache.HardSmartCache;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.Dialect;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.log4j.Logger;

public abstract class RolapNativeSet
extends RolapNative {
    protected static final Logger LOGGER = Logger.getLogger(RolapNativeSet.class);
    private SmartCache<Object, TupleList> cache = new SoftSmartCache<Object, TupleList>();

    protected abstract boolean restrictMemberTypes();

    protected CrossJoinArgFactory crossJoinArgFactory() {
        return new CrossJoinArgFactory(this.restrictMemberTypes());
    }

    protected boolean isPreferInterpreter(CrossJoinArg[] args, boolean joinArg) {
        for (CrossJoinArg arg : args) {
            if (arg.isPreferInterpreter(joinArg)) continue;
            return false;
        }
        return true;
    }

    void useHardCache(boolean hard) {
        this.cache = hard ? new HardSmartCache<Object, TupleList>() : new SoftSmartCache<Object, TupleList>();
    }

    protected void overrideContext(RolapEvaluator evaluator, CrossJoinArg[] cargs, RolapStoredMeasure storedMeasure) {
        SchemaReader schemaReader = evaluator.getSchemaReader();
        for (CrossJoinArg carg : cargs) {
            RolapCubeLevel level = carg.getLevel();
            if (level == null) continue;
            RolapHierarchy hierarchy = ((RolapLevel)level).getHierarchy();
            Member defaultMember = schemaReader.getHierarchyDefaultMember(hierarchy);
            evaluator.setContext(defaultMember);
        }
        if (storedMeasure != null) {
            evaluator.setContext(storedMeasure);
        }
    }

    private static class SchemaReaderWithMemberReaderCache
    extends DelegatingSchemaReader
    implements SchemaReaderWithMemberReaderAvailable {
        private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();

        SchemaReaderWithMemberReaderCache(SchemaReader schemaReader) {
            super(schemaReader);
        }

        public synchronized MemberReader getMemberReader(RolapCubeHierarchy hierarchy) {
            MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
            if (memberReader == null) {
                memberReader = RolapSchemaLoader.createMemberReader(hierarchy, this.schemaReader.getRole());
                this.hierarchyReaders.put(hierarchy, memberReader);
            }
            return memberReader;
        }
    }

    public static interface SchemaReaderWithMemberReaderAvailable
    extends SchemaReader {
        public MemberReader getMemberReader(RolapCubeHierarchy var1);
    }

    protected class SetEvaluator
    implements NativeEvaluator {
        private final CrossJoinArg[] args;
        private final SchemaReaderWithMemberReaderAvailable schemaReader;
        private final TupleConstraint constraint;
        private int maxRows = 0;

        public SetEvaluator(CrossJoinArg[] args, SchemaReader schemaReader, TupleConstraint constraint) {
            this.args = args;
            this.schemaReader = schemaReader instanceof SchemaReaderWithMemberReaderAvailable ? (SchemaReaderWithMemberReaderAvailable)schemaReader : new SchemaReaderWithMemberReaderCache(schemaReader);
            this.constraint = constraint;
        }

        public Object execute(ResultStyle desiredResultStyle) {
            switch (desiredResultStyle) {
                case ITERABLE: 
                case MUTABLE_LIST: 
                case LIST: {
                    DataServicesProvider provider = DataServicesLocator.getDataServicesProvider(this.schemaReader.getSchema().getDataServiceProviderName());
                    return this.executeList(provider.getTupleReader(this.constraint));
                }
            }
            throw ResultStyleException.generate(ResultStyle.ITERABLE_MUTABLELIST_LIST, Collections.singletonList(desiredResultStyle));
        }

        protected TupleList executeList(TupleReader tr) {
            RolapNative.TupleEvent e;
            boolean hasEnumTargets;
            tr.setMaxRows(this.maxRows);
            for (CrossJoinArg arg : this.args) {
                this.addLevel(tr, arg);
            }
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(tr.getCacheKey());
            key.addAll(Arrays.asList(this.args));
            TupleList result = (TupleList)RolapNativeSet.this.cache.get(key);
            boolean bl = hasEnumTargets = tr.getEnumTargetCount() > 0;
            if (result != null && !hasEnumTargets) {
                if (RolapNativeSet.this.listener != null) {
                    e = new RolapNative.TupleEvent(this, tr);
                    RolapNativeSet.this.listener.foundInCache(e);
                }
                return new DelegatingTupleList(this.args.length, Util.cast(result));
            }
            if (result == null && RolapNativeSet.this.listener != null) {
                e = new RolapNative.TupleEvent(this, tr);
                RolapNativeSet.this.listener.executingSql(e);
            }
            TupleList partialResult = result;
            ArrayList<List<RolapMember>> newPartialResult = null;
            if (hasEnumTargets && partialResult == null) {
                newPartialResult = new ArrayList<List<RolapMember>>();
            }
            DataSource dataSource = this.schemaReader.getDataSource();
            Dialect dialect = this.schemaReader.getSchema().getDialect();
            result = this.args.length == 1 ? tr.readMembers(dialect, dataSource, partialResult, newPartialResult) : tr.readTuples(dialect, dataSource, partialResult, newPartialResult);
            if (!MondrianProperties.instance().DisableCaching.get()) {
                if (hasEnumTargets) {
                    if (newPartialResult != null) {
                        RolapNativeSet.this.cache.put(key, new DelegatingTupleList(this.args.length, Util.cast(newPartialResult)));
                    }
                } else {
                    RolapNativeSet.this.cache.put(key, result);
                }
            }
            return this.filterInaccessibleTuples(result);
        }

        private TupleList filterInaccessibleTuples(TupleList tupleList) {
            if (this.needsFiltering(tupleList)) {
                Predicate memberInaccessible = this.memberInaccessiblePredicate();
                CollectionUtils.filter((Collection)tupleList, (Predicate)this.tupleAccessiblePredicate(memberInaccessible));
            }
            return tupleList;
        }

        private boolean needsFiltering(TupleList tupleList) {
            return tupleList.size() > 0 && CollectionUtils.exists((Collection)((Collection)tupleList.get(0)), (Predicate)this.needsFilterPredicate());
        }

        private Predicate needsFilterPredicate() {
            return new Predicate(){

                public boolean evaluate(Object o) {
                    Member member = (Member)o;
                    return SetEvaluator.this.isRaggedLevel(member.getLevel()) || SetEvaluator.this.isCustomAccess(member.getHierarchy());
                }
            };
        }

        private boolean isRaggedLevel(Level level) {
            if (level instanceof RolapLevel) {
                return ((RolapLevel)level).getHideMemberCondition() != RolapLevel.HideMemberCondition.Never;
            }
            return true;
        }

        private boolean isCustomAccess(Hierarchy hierarchy) {
            if (this.constraint.getEvaluator() == null) {
                return false;
            }
            Access access = this.constraint.getEvaluator().getSchemaReader().getRole().getAccess(hierarchy);
            return access == Access.CUSTOM;
        }

        private Predicate memberInaccessiblePredicate() {
            if (this.constraint.getEvaluator() != null) {
                return new Predicate(){

                    public boolean evaluate(Object o) {
                        Role role = SetEvaluator.this.constraint.getEvaluator().getSchemaReader().getRole();
                        Member member = (Member)o;
                        return member.isHidden() || !role.canAccess(member);
                    }
                };
            }
            return new Predicate(){

                public boolean evaluate(Object o) {
                    return ((Member)o).isHidden();
                }
            };
        }

        private Predicate tupleAccessiblePredicate(final Predicate memberInaccessible) {
            return new Predicate(){

                public boolean evaluate(Object o) {
                    return !CollectionUtils.exists((Collection)((List)o), (Predicate)memberInaccessible);
                }
            };
        }

        private void addLevel(TupleReader tr, CrossJoinArg arg) {
            RolapCubeLevel level = arg.getLevel();
            if (level == null) {
                tr.incrementEmptySets();
                return;
            }
            RolapCubeHierarchy hierarchy = level.getHierarchy();
            MemberReader mr = this.schemaReader.getMemberReader(hierarchy);
            TupleReader.MemberBuilder mb = mr.getMemberBuilder();
            Util.assertTrue(mb != null, "MemberBuilder not found");
            if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) {
                tr.addLevelMembers(level, mb, arg.getMembers());
            } else {
                tr.addLevelMembers(level, mb, null);
            }
        }

        void setMaxRows(int maxRows) {
            this.maxRows = maxRows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class SetConstraint
    extends SqlContextConstraint {
        CrossJoinArg[] args;

        SetConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, List<RolapMeasureGroup> measureGroupList, boolean strict) {
            super(evaluator, measureGroupList, strict);
            this.args = args;
        }

        @Override
        public boolean isJoinRequired() {
            return this.args.length > 1 || super.isJoinRequired();
        }

        @Override
        public void addConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet) {
            super.addConstraint(queryBuilder, starSet);
            for (CrossJoinArg arg : this.args) {
                RolapCubeLevel level;
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers() || (level = arg.getLevel()) != null && !this.levelIsOnBaseCube(starSet.getMeasureGroup(), level)) continue;
                arg.addConstraint(queryBuilder, starSet);
            }
        }

        private boolean levelIsOnBaseCube(RolapMeasureGroup measureGroup, RolapLevel level) {
            if (measureGroup == null) {
                return false;
            }
            return measureGroup.getPath(level.getHierarchy().getDimension()) != null;
        }

        @Override
        public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
            return null;
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            for (CrossJoinArg arg : this.args) {
                if (arg instanceof MemberListCrossJoinArg && ((MemberListCrossJoinArg)arg).hasCalcMembers()) continue;
                key.add(arg);
            }
            return key;
        }
    }
}

