/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.util.Pair;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapMeasureGroup {
    private final RolapCube cube;
    private final String name;
    public final boolean ignoreUnrelatedDimensions;
    private final RolapStar star;
    final boolean aggregate;
    final NamedList<RolapStoredMeasure> measureList = new NamedListImpl();
    final List<RolapMeasureRef> measureRefList;
    private final Map<RolapDimension, RolapSchema.PhysPath> dimensionMap = new HashMap<RolapDimension, RolapSchema.PhysPath>();
    public final Map<RolapDimension, RolapSchema.PhysPath> dimensionMap2 = new HashMap<RolapDimension, RolapSchema.PhysPath>();
    public final Map<RolapCubeDimension, RolapSchema.PhysPath> dimensionMap3 = new HashMap<RolapCubeDimension, RolapSchema.PhysPath>();
    RolapBaseCubeMeasure factCountMeasure;
    final Map<Pair<RolapCubeDimension, RolapSchema.PhysColumn>, RolapStar.Column> starColumnMap = new HashMap<Pair<RolapCubeDimension, RolapSchema.PhysColumn>, RolapStar.Column>();
    final List<Pair<RolapStar.Column, RolapSchema.PhysColumn>> copyColumnList = new ArrayList<Pair<RolapStar.Column, RolapSchema.PhysColumn>>();

    public RolapMeasureGroup(RolapCube cube, String name, boolean ignoreUnrelatedDimensions, RolapStar star, boolean aggregate) {
        this.name = name;
        this.cube = cube;
        this.ignoreUnrelatedDimensions = ignoreUnrelatedDimensions;
        this.star = star;
        this.aggregate = aggregate;
        this.measureRefList = aggregate ? new ArrayList<RolapMeasureRef>() : Collections.emptyList();
        assert (cube != null);
        assert (name != null);
        assert (star != null);
    }

    public Iterable<RolapCubeDimension> nonJoiningDimensions(List<Member> tuple) {
        HashSet<RolapCubeDimension> otherDims = new HashSet<RolapCubeDimension>();
        for (Member member : tuple) {
            if (member.isCalculated()) continue;
            otherDims.add((RolapCubeDimension)member.getDimension());
        }
        return this.nonJoiningDimensions(otherDims);
    }

    public Iterable<RolapCubeDimension> nonJoiningDimensions(final Iterable<? extends RolapCubeDimension> otherDims) {
        return new Iterable<RolapCubeDimension>(){

            @Override
            public Iterator<RolapCubeDimension> iterator() {
                return new FilterIterator(otherDims.iterator(), (Predicate)new Util.Predicate1<RolapCubeDimension>(){

                    @Override
                    public boolean test(RolapCubeDimension dimension) {
                        return !RolapMeasureGroup.this.dimensionMap3.containsKey(dimension) && !dimension.isMeasures();
                    }
                });
            }
        };
    }

    boolean existsLink(RolapCubeDimension dimension) {
        return this.dimensionMap3.containsKey(dimension);
    }

    void addLink(RolapDimension dimension, RolapSchema.PhysPath path) {
        this.dimensionMap.put(dimension, path);
        if (dimension instanceof RolapCubeDimension) {
            RolapCubeDimension cubeDimension = (RolapCubeDimension)dimension;
            this.dimensionMap3.put(cubeDimension, path);
            dimension = cubeDimension.rolapDimension;
        }
        this.dimensionMap2.put(dimension, path);
    }

    public String getName() {
        return this.name;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public RolapCube getCube() {
        return this.cube;
    }

    public RolapMeasure getFactCountMeasure() {
        return this.factCountMeasure;
    }

    RolapMeasure getAtomicCellCountMeasure() {
        return this.factCountMeasure;
    }

    public RolapSchema.PhysRelation getFactRelation() {
        return this.star.getFactTable().getRelation();
    }

    public RolapSchema.PhysPath getPath(RolapDimension dimension) {
        return this.dimensionMap.get(dimension);
    }

    public RolapStar.Column getRolapStarColumn(RolapCubeDimension cubeDimension, RolapSchema.PhysColumn column) {
        return this.starColumnMap.get(Pair.of(cubeDimension, column));
    }

    public RolapStar.Column getRolapStarColumn(RolapCubeDimension cubeDimension, RolapSchema.PhysColumn column, boolean fail) {
        RolapStar.Column starColumn = this.getRolapStarColumn(cubeDimension, column);
        assert (!fail || starColumn != null);
        return starColumn;
    }

    public RolapSchema.PhysPath getPath(RolapCubeDimension cubeDimension, RolapSchema.PhysColumn column) {
        RolapSchema.PhysPathBuilder pathBuilder = new RolapSchema.PhysPathBuilder(this.getPath(cubeDimension));
        try {
            column.relation.getSchema().getGraph().findPath(pathBuilder, column.relation);
        }
        catch (RolapSchema.PhysSchemaException e) {
            throw new RuntimeException("Could not find path", e);
        }
        return pathBuilder.done();
    }

    static class RolapMeasureRef {
        final RolapBaseCubeMeasure measure;
        final RolapSchema.PhysColumn aggColumn;

        public RolapMeasureRef(RolapBaseCubeMeasure measure, RolapSchema.PhysColumn aggColumn) {
            this.measure = measure;
            this.aggColumn = aggColumn;
        }
    }
}

