/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryTiming;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.server.Statement;
import mondrian.spi.Dialect;
import mondrian.util.Format;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapEvaluator
implements Evaluator {
    private static final Logger LOGGER = Logger.getLogger(RolapEvaluator.class);
    private static final Object nullResult = new Object();
    private final RolapMember[] currentMembers;
    private final RolapEvaluator parent;
    protected CellReader cellReader;
    private final int ancestorCommandCount;
    private Member expandingMember;
    private boolean firstExpanding;
    private boolean nonEmpty;
    protected final RolapEvaluatorRoot root;
    private int iterationLength = 1;
    private boolean evalAxes;
    private final RolapCalculation[] calculations;
    private int calculationCount;
    protected final List<List<List<Member>>> aggregationLists;
    private final List<RolapMember> slicerMembers;
    private boolean nativeEnabled;
    private RolapMember[] nonAllMembers;
    private int commandCount;
    private Object[] commands;

    public Set<Exp> getActiveNativeExpansions() {
        return this.root.activeNativeExpansions;
    }

    protected RolapEvaluator(RolapEvaluatorRoot root, RolapEvaluator parent, List<List<Member>> aggregationList) {
        this.root = root;
        assert (parent != null);
        this.parent = parent;
        this.ancestorCommandCount = parent.ancestorCommandCount + parent.commandCount;
        this.nonEmpty = parent.nonEmpty;
        this.nativeEnabled = parent.nativeEnabled;
        this.evalAxes = parent.evalAxes;
        this.cellReader = parent.cellReader;
        this.currentMembers = (RolapMember[])parent.currentMembers.clone();
        this.calculations = (RolapCalculation[])parent.calculations.clone();
        this.calculationCount = parent.calculationCount;
        this.slicerMembers = new ArrayList<RolapMember>(parent.slicerMembers);
        this.commands = new Object[10];
        this.commands[0] = Command.SAVEPOINT;
        this.commandCount = 1;
        ArrayList<List<List<Member>>> aggregationLists = null;
        if (parent.aggregationLists != null) {
            aggregationLists = new ArrayList<List<List<Member>>>(parent.aggregationLists);
        }
        if (aggregationList != null) {
            if (aggregationLists == null) {
                aggregationLists = new ArrayList();
            }
            aggregationLists.add(aggregationList);
            List<Member> tuple = aggregationList.get(0);
            for (Member member : tuple) {
                this.setContext(member.getHierarchy().getAllMember());
            }
        }
        this.aggregationLists = aggregationLists;
        this.expandingMember = parent.expandingMember;
    }

    public RolapEvaluator(RolapEvaluatorRoot root) {
        this.root = root;
        this.parent = null;
        this.ancestorCommandCount = 0;
        this.nonEmpty = false;
        this.nativeEnabled = MondrianProperties.instance().EnableNativeNonEmpty.get() || MondrianProperties.instance().EnableNativeCrossJoin.get();
        this.evalAxes = false;
        this.cellReader = null;
        this.currentMembers = (RolapMember[])root.defaultMembers.clone();
        this.calculations = new RolapCalculation[this.currentMembers.length];
        this.calculationCount = 0;
        this.slicerMembers = new ArrayList<RolapMember>();
        this.aggregationLists = null;
        this.commands = new Object[10];
        this.commands[0] = Command.SAVEPOINT;
        this.commandCount = 1;
        for (RolapMember member : this.currentMembers) {
            if (!member.isEvaluated()) continue;
            this.addCalculation(member, true);
        }
    }

    public static Evaluator create(Statement statement) {
        RolapEvaluatorRoot root = new RolapEvaluatorRoot(statement);
        return new RolapEvaluator(root);
    }

    @Override
    public RolapMeasureGroup getMeasureGroup() {
        RolapMember measure = this.currentMembers[0];
        if (measure instanceof RolapStoredMeasure) {
            return ((RolapStoredMeasure)((Object)measure)).getMeasureGroup();
        }
        return null;
    }

    @Override
    public boolean mightReturnNullForUnrelatedDimension() {
        if (!MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get()) {
            return false;
        }
        List<RolapMeasureGroup> measureGroups = this.getCube().getMeasureGroups();
        return measureGroups != null && measureGroups.size() > 1;
    }

    @Override
    public boolean needToReturnNullForUnrelatedDimension(Member[] members) {
        assert (this.mightReturnNullForUnrelatedDimension()) : "Should not even call this method if nulls are impossible";
        RolapMeasureGroup measureGroup = this.getMeasureGroup();
        if (measureGroup == null) {
            return false;
        }
        if (measureGroup.ignoreUnrelatedDimensions) {
            return false;
        }
        return measureGroup.nonJoiningDimensions(Arrays.asList(members)).iterator().hasNext();
    }

    @Override
    public boolean nativeEnabled() {
        return this.nativeEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean currentIsEmpty() {
        Object o = this.evaluateCurrent();
        if (o == Util.nullValue || o == null) {
            return true;
        }
        RolapMeasureGroup measureCube = this.getMeasureGroup();
        if (measureCube == null) {
            return false;
        }
        int savepoint = this.savepoint();
        try {
            this.setContext(measureCube.getFactCountMeasure());
            o = this.evaluateCurrent();
        }
        finally {
            this.restore(savepoint);
        }
        return o == null || o instanceof Number && ((Number)o).intValue() == 0;
    }

    @Override
    public Member getPreviousContext(Hierarchy hierarchy) {
        RolapEvaluator e = this;
        while (e != null) {
            Command command;
            for (int i = this.commandCount - 1; i > 0; i -= command.width) {
                command = (Command)((Object)this.commands[i]);
                if (command != Command.SET_CONTEXT) continue;
                return (Member)this.commands[i - 2];
            }
            e = e.parent;
        }
        return null;
    }

    @Override
    public final QueryTiming getTiming() {
        return this.root.execution.getQueryTiming();
    }

    @Override
    public final int savepoint() {
        int commandCount1 = this.commandCount;
        if (this.commands[this.commandCount - 1] == Command.SAVEPOINT) {
            return commandCount1;
        }
        this.ensureCommandCapacity(this.commandCount + 3);
        this.commands[this.commandCount++] = Command.SAVEPOINT;
        return commandCount1;
    }

    @Override
    public final void setNativeEnabled(boolean nativeEnabled) {
        if (nativeEnabled != this.nativeEnabled) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.nativeEnabled;
            this.commands[this.commandCount++] = Command.SET_NATIVE_ENABLED;
            this.nativeEnabled = nativeEnabled;
        }
    }

    protected final Logger getLogger() {
        return LOGGER;
    }

    public final RolapMember[] getMembers() {
        return this.currentMembers;
    }

    public final RolapMember[] getNonAllMembers() {
        if (this.nonAllMembers == null) {
            this.nonAllMembers = new RolapMember[this.root.nonAllPositionCount];
            for (int i = 0; i < this.root.nonAllPositionCount; ++i) {
                int nonAllPosition = this.root.nonAllPositions[i];
                this.nonAllMembers[i] = this.currentMembers[nonAllPosition];
            }
        }
        return this.nonAllMembers;
    }

    public final List<List<List<Member>>> getAggregationLists() {
        return this.aggregationLists;
    }

    final void setCellReader(CellReader cellReader) {
        if (cellReader != this.cellReader) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.cellReader;
            this.commands[this.commandCount++] = Command.SET_CELL_READER;
            this.cellReader = cellReader;
        }
    }

    @Override
    public final RolapCube getCube() {
        return this.root.cube;
    }

    @Override
    public final Query getQuery() {
        return this.root.query;
    }

    @Override
    public final int getDepth() {
        return 0;
    }

    @Override
    public final RolapEvaluator getParent() {
        return this.parent;
    }

    @Override
    public final SchemaReader getSchemaReader() {
        return this.root.schemaReader;
    }

    @Override
    public Date getQueryStartTime() {
        return this.root.getQueryStartTime();
    }

    public Dialect getDialect() {
        return this.root.dialect;
    }

    @Override
    public final RolapEvaluator push(Member[] members) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setContext(members);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push(Member member) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setContext(member);
        return evaluator;
    }

    @Override
    public final Evaluator push(boolean nonEmpty) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setNonEmpty(nonEmpty);
        return evaluator;
    }

    @Override
    public final Evaluator push(boolean nonEmpty, boolean nativeEnabled) {
        RolapEvaluator evaluator = this._push(null);
        evaluator.setNonEmpty(nonEmpty);
        evaluator.setNativeEnabled(nativeEnabled);
        return evaluator;
    }

    @Override
    public final RolapEvaluator push() {
        return this._push(null);
    }

    private void ensureCommandCapacity(int minCapacity) {
        if (minCapacity > this.commands.length) {
            int newCapacity = this.commands.length * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.commands = Util.copyOf(this.commands, newCapacity);
        }
    }

    private boolean addChecksumStateCommand() {
        this.commands[this.commandCount++] = this.checksumState();
        this.commands[this.commandCount++] = Command.CHECKSUM;
        return true;
    }

    protected RolapEvaluator _push(List<List<Member>> aggregationList) {
        this.root.execution.checkCancelOrTimeout();
        return new RolapEvaluator(this.root, this, aggregationList);
    }

    @Override
    public final void restore(int savepoint) {
        while (this.commandCount > savepoint) {
            ((Command)((Object)this.commands[--this.commandCount])).execute(this);
        }
    }

    @Override
    public final Evaluator pushAggregation(List<List<Member>> list) {
        return this._push(list);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof RolapEvaluator)) {
            return false;
        }
        RolapEvaluator that = (RolapEvaluator)obj;
        return Arrays.equals(this.currentMembers, that.currentMembers);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.currentMembers);
    }

    public final void setSlicerContext(Member member) {
        this.setContext(member);
        this.slicerMembers.add((RolapMember)member);
    }

    public final List<RolapMember> getSlicerMembers() {
        return this.slicerMembers;
    }

    @Override
    public final Member setContext(Member member) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getHierarchy().getOrdinalInCube();
        RolapMember previous = this.currentMembers[ordinal];
        if (RolapEvaluator.same(m, previous)) {
            return previous;
        }
        if (!this.exists(ordinal)) {
            this.ensureCommandCapacity(this.commandCount + 3);
            this.commands[this.commandCount++] = previous;
            this.commands[this.commandCount++] = ordinal;
            this.commands[this.commandCount++] = Command.SET_CONTEXT;
        }
        if (previous.isEvaluated()) {
            this.removeCalculation(previous, false);
        }
        this.currentMembers[ordinal] = m;
        if (previous.isAll() && !m.isAll() && this.isNewPosition(ordinal)) {
            this.root.nonAllPositions[this.root.nonAllPositionCount] = ordinal;
            ++this.root.nonAllPositionCount;
        }
        if (m.isEvaluated()) {
            this.addCalculation(m, false);
        }
        this.nonAllMembers = null;
        return previous;
    }

    @Override
    public final void setContext(Member member, boolean safe) {
        RolapMember m = (RolapMember)member;
        int ordinal = m.getHierarchy().getOrdinalInCube();
        RolapMember previous = this.currentMembers[ordinal];
        if (m == previous) {
            return;
        }
        if (safe && !this.exists(ordinal)) {
            this.ensureCommandCapacity(this.commandCount + 3);
            this.commands[this.commandCount++] = previous;
            this.commands[this.commandCount++] = ordinal;
            this.commands[this.commandCount++] = Command.SET_CONTEXT;
        }
        if (previous.isEvaluated()) {
            this.removeCalculation(previous, false);
        }
        this.currentMembers[ordinal] = m;
        if (previous.isAll() && !m.isAll() && this.isNewPosition(ordinal)) {
            this.root.nonAllPositions[this.root.nonAllPositionCount] = ordinal;
            ++this.root.nonAllPositionCount;
        }
        if (m.isEvaluated()) {
            this.addCalculation(m, false);
        }
        this.nonAllMembers = null;
    }

    private static boolean same(RolapMember m0, RolapMember m1) {
        if (m0 == m1) {
            return true;
        }
        if (m0.getClass() != m1.getClass()) {
            return false;
        }
        return m0.equals(m1);
    }

    private boolean exists(int ordinal) {
        int i = this.commandCount - 1;
        while (true) {
            Command command = (Command)((Object)this.commands[i]);
            switch (command) {
                case SAVEPOINT: {
                    return false;
                }
                case SET_CONTEXT: {
                    Integer memberOrdinal = (Integer)this.commands[i - 1];
                    if (ordinal != memberOrdinal) break;
                    return true;
                }
            }
            i -= command.width;
        }
    }

    private boolean isNewPosition(int ordinal) {
        for (int nonAllPosition : this.root.nonAllPositions) {
            if (ordinal != nonAllPosition) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setContext(List<Member> memberList) {
        int n = memberList.size();
        for (int i = 0; i < n; ++i) {
            Member member = memberList.get(i);
            assert (member != null) : "null member in " + memberList;
            this.setContext(member);
        }
    }

    @Override
    public final void setContext(List<Member> memberList, boolean safe) {
        int n = memberList.size();
        for (int i = 0; i < n; ++i) {
            Member member = memberList.get(i);
            assert (member != null) : "null member in " + memberList;
            this.setContext(member, safe);
        }
    }

    @Override
    public final void setContext(Member[] members) {
        int length = members.length;
        for (int i = 0; i < length; ++i) {
            Member member = members[i];
            assert (member != null) : "null member in " + Arrays.toString(members);
            this.setContext(member);
        }
    }

    @Override
    public final void setContext(Member[] members, boolean safe) {
        int length = members.length;
        for (int i = 0; i < length; ++i) {
            Member member = members[i];
            assert (member != null) : Arrays.asList(members);
            this.setContext(member, safe);
        }
    }

    @Override
    public final RolapMember getContext(Hierarchy _hierarchy) {
        RolapCubeHierarchy hierarchy = (RolapCubeHierarchy)_hierarchy;
        return this.currentMembers[hierarchy.getOrdinalInCube()];
    }

    public final RolapMember getContext(RolapCubeHierarchy hierarchy) {
        return this.currentMembers[hierarchy.getOrdinalInCube()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object evaluateCurrent() {
        Object o;
        RolapCalculation maxSolveMember;
        block1 : switch (this.calculationCount) {
            case 0: {
                Object o2 = this.cellReader.get(this);
                if (o2 == Util.nullValue) {
                    return null;
                }
                return o2;
            }
            case 1: {
                maxSolveMember = this.calculations[0];
                break;
            }
            default: {
                switch (this.root.solveOrderMode) {
                    case ABSOLUTE: {
                        maxSolveMember = this.getAbsoluteMaxSolveOrder();
                        break block1;
                    }
                    case SCOPED: {
                        maxSolveMember = this.getScopedMaxSolveOrder();
                        break block1;
                    }
                }
                throw Util.unexpected(this.root.solveOrderMode);
            }
        }
        int savepoint = this.savepoint();
        maxSolveMember.setContextIn(this);
        Calc calc = maxSolveMember.getCompiledExpression(this.root);
        try {
            o = calc.evaluate(this);
        }
        finally {
            this.restore(savepoint);
        }
        if (o == Util.nullValue) {
            return null;
        }
        return o;
    }

    void setExpanding(Member member) {
        assert (member != null);
        this.ensureCommandCapacity(this.commandCount + 3);
        this.commands[this.commandCount++] = this.expandingMember;
        this.commands[this.commandCount++] = this.firstExpanding;
        this.commands[this.commandCount++] = Command.SET_EXPANDING;
        this.expandingMember = member;
        this.firstExpanding = true;
        int totalCommandCount = this.commandCount + this.ancestorCommandCount;
        if (totalCommandCount > this.root.recursionCheckCommandCount) {
            RolapEvaluator.checkRecursion(this, this.commandCount - 4);
            this.root.recursionCheckCommandCount = totalCommandCount + (this.root.defaultMembers.length << 4);
        }
    }

    Member getExpanding() {
        return this.expandingMember;
    }

    private static void checkRecursion(RolapEvaluator eval, int c) {
        Object[] members = (RolapMember[])eval.currentMembers.clone();
        Member expanding = eval.expandingMember;
        while (true) {
            if (c < 0) {
                eval = eval.parent;
                if (eval == null) {
                    return;
                }
                c = eval.commandCount - 1;
                continue;
            }
            Command command = (Command)((Object)eval.commands[c]);
            switch (command) {
                case SET_CONTEXT: {
                    int memberOrdinal = (Integer)eval.commands[c - 1];
                    RolapMember member = (RolapMember)eval.commands[c - 2];
                    members[memberOrdinal] = member;
                    break;
                }
                case SET_EXPANDING: {
                    expanding = (RolapMember)eval.commands[c - 2];
                    if (!Arrays.equals(members, eval.currentMembers) || expanding != eval.expandingMember) break;
                    throw FunUtil.newEvalException(null, "Infinite loop while evaluating calculated member '" + eval.expandingMember + "'; context stack is " + eval.getContextString());
                }
            }
            c -= command.width;
        }
    }

    private String getContextString() {
        RolapMember[] members = (RolapMember[])this.currentMembers.clone();
        boolean skipDefaultMembers = true;
        StringBuilder buf = new StringBuilder("{");
        int frameCount = 0;
        boolean changedSinceLastSavepoint = false;
        RolapEvaluator eval = this;
        while (eval != null) {
            if (eval.expandingMember != null) {
                Command command;
                block5: for (int c = eval.commandCount - 1; c > 0; c -= command.width) {
                    command = (Command)((Object)eval.commands[c]);
                    switch (command) {
                        case SAVEPOINT: {
                            if (changedSinceLastSavepoint) {
                                if (frameCount++ > 0) {
                                    buf.append(", ");
                                }
                                buf.append("(");
                                int memberCount = 0;
                                for (RolapMember m : members) {
                                    if (m == m.getHierarchy().getDefaultMember()) continue;
                                    if (memberCount++ > 0) {
                                        buf.append(", ");
                                    }
                                    buf.append(m.getUniqueName());
                                }
                                buf.append(")");
                            }
                            changedSinceLastSavepoint = false;
                            continue block5;
                        }
                        case SET_CONTEXT: {
                            RolapMember member;
                            changedSinceLastSavepoint = true;
                            int memberOrdinal = (Integer)eval.commands[c - 1];
                            members[memberOrdinal] = member = (RolapMember)eval.commands[c - 2];
                        }
                    }
                }
            }
            eval = eval.parent;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public final Object getProperty(Property property, Object defaultValue) {
        Object o = defaultValue;
        int maxSolve = Integer.MIN_VALUE;
        int i = -1;
        for (RolapMember member : this.getNonAllMembers()) {
            Object p;
            ++i;
            if (member == null) {
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)("RolapEvaluator.getProperty: member == null  , count=" + i));
                continue;
            }
            int solve = member.getSolveOrder();
            if (solve <= maxSolve || (p = member.getPropertyValue(property)) == null) continue;
            o = p;
            maxSolve = solve;
        }
        return o;
    }

    @Override
    public final String getFormatString() {
        Exp formatExp = (Exp)this.getProperty(Property.FORMAT_EXP_PARSED, null);
        if (formatExp == null) {
            return "Standard";
        }
        Calc formatCalc = this.root.getCompiled(formatExp, true, null);
        Object o = formatCalc.evaluate(this);
        if (o == null) {
            return "Standard";
        }
        return o.toString();
    }

    private Format getFormat() {
        String formatString = this.getFormatString();
        return this.getFormat(formatString);
    }

    private Format getFormat(String formatString) {
        return Format.get(formatString, this.root.connection.getLocale());
    }

    @Override
    public final Locale getConnectionLocale() {
        return this.root.connection.getLocale();
    }

    @Override
    public final String format(Object o) {
        if (o == Util.nullValue) {
            o = null;
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        Format format = this.getFormat();
        return format.format(o);
    }

    @Override
    public final String format(Object o, String formatString) {
        if (o == Util.nullValue) {
            o = null;
        }
        if (o instanceof Throwable) {
            return "#ERR: " + o.toString();
        }
        Format format = this.getFormat(formatString);
        return format.format(o);
    }

    private Object getExpResultCacheKey(ExpCacheDescriptor descriptor) {
        ArrayList<Object> key;
        if (this.nonEmpty) {
            key = new ArrayList<Object>(this.currentMembers.length + 1);
            key.add(descriptor.getExp());
            for (RolapMember currentMember : this.currentMembers) {
                key.add(currentMember);
            }
        } else {
            int[] hierarchyOrdinals = descriptor.getDependentHierarchyOrdinals();
            key = new ArrayList(hierarchyOrdinals.length + 1);
            key.add(descriptor.getExp());
            for (int hierarchyOrdinal : hierarchyOrdinals) {
                RolapMember member = this.currentMembers[hierarchyOrdinal];
                assert (member != null);
                key.add(member);
            }
        }
        return key;
    }

    @Override
    public final Object getCachedResult(ExpCacheDescriptor cacheDescriptor) {
        Object key = this.getExpResultCacheKey(cacheDescriptor);
        Object result = this.root.getCacheResult(key);
        if (result == null) {
            boolean aggCacheDirty = this.cellReader.isDirty();
            int aggregateCacheMissCountBefore = this.cellReader.getMissCount();
            result = cacheDescriptor.evaluate(this);
            int aggregateCacheMissCountAfter = this.cellReader.getMissCount();
            boolean isValidResult = !aggCacheDirty && aggregateCacheMissCountBefore == aggregateCacheMissCountAfter;
            this.root.putCacheResult(key, result == null ? nullResult : result, isValidResult);
        } else if (result == nullResult) {
            result = null;
        }
        return result;
    }

    public final void clearExpResultCache(boolean clearValidResult) {
        this.root.clearResultCache(clearValidResult);
    }

    @Override
    public final boolean isNonEmpty() {
        return this.nonEmpty;
    }

    @Override
    public final void setNonEmpty(boolean nonEmpty) {
        if (nonEmpty != this.nonEmpty) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.nonEmpty;
            this.commands[this.commandCount++] = Command.SET_NON_EMPTY;
            this.nonEmpty = nonEmpty;
        }
    }

    @Override
    public final RuntimeException newEvalException(Object context, String s) {
        return FunUtil.newEvalException((FunDef)context, s);
    }

    @Override
    public final Evaluator.NamedSetEvaluator getNamedSetEvaluator(NamedSet namedSet, boolean create) {
        return this.root.evaluateNamedSet(namedSet, create);
    }

    @Override
    public final int getMissCount() {
        return this.cellReader.getMissCount();
    }

    @Override
    public final Object getParameterValue(ParameterSlot slot) {
        return this.root.getParameterValue(slot);
    }

    final void addCalculation(RolapCalculation calculation, boolean reversible) {
        assert (calculation != null);
        this.calculations[this.calculationCount++] = calculation;
        if (reversible && !(calculation instanceof RolapMember)) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = calculation;
            this.commands[this.commandCount++] = Command.REMOVE_CALCULATION;
        }
    }

    private RolapCalculation getAbsoluteMaxSolveOrder() {
        RolapCalculation maxSolveMember = this.calculations[0];
        for (int i = 1; i < this.calculationCount; ++i) {
            RolapCalculation member = this.calculations[i];
            if (!this.expandsBefore(member, maxSolveMember)) continue;
            maxSolveMember = member;
        }
        return maxSolveMember;
    }

    private RolapCalculation getScopedMaxSolveOrder() {
        RolapCalculation maxSolveMember = null;
        ScopedMaxSolveOrderFinderState state = ScopedMaxSolveOrderFinderState.START;
        block6: for (int i = 0; i < this.calculationCount; ++i) {
            RolapCalculation calculation = this.calculations[i];
            switch (state) {
                case START: {
                    maxSolveMember = calculation;
                    if (maxSolveMember.containsAggregateFunction()) {
                        state = ScopedMaxSolveOrderFinderState.AGG_SCOPE;
                        continue block6;
                    }
                    if (maxSolveMember.isCalculatedInQuery()) {
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case AGG_SCOPE: {
                    if (calculation.containsAggregateFunction()) {
                        if (!this.expandsBefore(calculation, maxSolveMember)) continue block6;
                        maxSolveMember = calculation;
                        continue block6;
                    }
                    if (calculation.isCalculatedInQuery()) {
                        maxSolveMember = calculation;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    maxSolveMember = calculation;
                    state = ScopedMaxSolveOrderFinderState.CUBE_SCOPE;
                    continue block6;
                }
                case CUBE_SCOPE: {
                    if (calculation.containsAggregateFunction()) continue block6;
                    if (calculation.isCalculatedInQuery()) {
                        maxSolveMember = calculation;
                        state = ScopedMaxSolveOrderFinderState.QUERY_SCOPE;
                        continue block6;
                    }
                    if (!this.expandsBefore(calculation, maxSolveMember)) continue block6;
                    maxSolveMember = calculation;
                    continue block6;
                }
                case QUERY_SCOPE: {
                    if (calculation.containsAggregateFunction() || !calculation.isCalculatedInQuery() || !this.expandsBefore(calculation, maxSolveMember)) continue block6;
                    maxSolveMember = calculation;
                }
            }
        }
        return maxSolveMember;
    }

    private boolean expandsBefore(RolapCalculation calc1, RolapCalculation calc2) {
        int solveOrder2;
        int solveOrder1 = calc1.getSolveOrder();
        if (solveOrder1 > (solveOrder2 = calc2.getSolveOrder())) {
            return true;
        }
        return solveOrder1 == solveOrder2 && calc1.getHierarchyOrdinal() < calc2.getHierarchyOrdinal();
    }

    final void removeCalculation(RolapCalculation calculation, boolean reversible) {
        for (int i = 0; i < this.calculationCount; ++i) {
            if (this.calculations[i] != calculation) continue;
            --this.calculationCount;
            this.calculations[i] = this.calculations[this.calculationCount];
            assert (this.calculations[i] != null);
            this.calculations[this.calculationCount] = null;
            if (reversible && !(calculation instanceof RolapMember)) {
                this.ensureCommandCapacity(this.commandCount + 2);
                this.commands[this.commandCount++] = calculation;
                this.commands[this.commandCount++] = Command.ADD_CALCULATION;
            }
            return;
        }
        throw new AssertionError((Object)("calculation " + calculation + " not on stack"));
    }

    @Override
    public final int getIterationLength() {
        return this.iterationLength;
    }

    @Override
    public final void setIterationLength(int iterationLength) {
        this.ensureCommandCapacity(this.commandCount + 2);
        this.commands[this.commandCount++] = this.iterationLength;
        this.commands[this.commandCount++] = Command.SET_ITERATION_LENGTH;
        this.iterationLength = iterationLength;
    }

    @Override
    public final boolean isEvalAxes() {
        return this.evalAxes;
    }

    @Override
    public final void setEvalAxes(boolean evalAxes) {
        if (evalAxes != this.evalAxes) {
            this.ensureCommandCapacity(this.commandCount + 2);
            this.commands[this.commandCount++] = this.evalAxes;
            this.commands[this.commandCount++] = Command.SET_EVAL_AXES;
            this.evalAxes = evalAxes;
        }
    }

    private int checksumState() {
        int h = 0;
        h = h * 31 + Arrays.asList(this.currentMembers).hashCode();
        h = h * 31 + new HashSet<RolapCalculation>(Arrays.asList(this.calculations).subList(0, this.calculationCount)).hashCode();
        h = h * 31 + this.slicerMembers.hashCode();
        h = h * 31 + (this.expandingMember == null ? 0 : this.expandingMember.hashCode());
        h = h * 31 + (this.aggregationLists == null ? 0 : this.aggregationLists.hashCode());
        h = h * 31 + (this.nonEmpty ? 1 : 2) + (this.nativeEnabled ? 4 : 8) + (this.firstExpanding ? 16 : 32) + (this.evalAxes ? 64 : 128);
        return h;
    }

    @Override
    public boolean shouldIgnoreUnrelatedDimensions() {
        return this.getMeasureGroup().ignoreUnrelatedDimensions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Command {
        SET_CONTEXT(2){

            void execute(RolapEvaluator evaluator) {
                int memberOrdinal = (Integer)evaluator.commands[--evaluator.commandCount];
                RolapMember member = (RolapMember)evaluator.commands[--evaluator.commandCount];
                evaluator.setContext(member, false);
            }
        }
        ,
        SET_NATIVE_ENABLED(1){

            void execute(RolapEvaluator evaluator) {
                evaluator.nativeEnabled = (Boolean)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        SET_NON_EMPTY(1){

            void execute(RolapEvaluator evaluator) {
                evaluator.nonEmpty = (Boolean)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        SET_EVAL_AXES(1){

            void execute(RolapEvaluator evaluator) {
                evaluator.evalAxes = (Boolean)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        SET_EXPANDING(2){

            void execute(RolapEvaluator evaluator) {
                evaluator.firstExpanding = (Boolean)evaluator.commands[--evaluator.commandCount];
                evaluator.expandingMember = (Member)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        SET_ITERATION_LENGTH(1){

            void execute(RolapEvaluator evaluator) {
                evaluator.iterationLength = (Integer)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        SET_CELL_READER(1){

            void execute(RolapEvaluator evaluator) {
                evaluator.cellReader = (CellReader)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        CHECKSUM(1){

            void execute(RolapEvaluator evaluator) {
                int value = (Integer)evaluator.commands[--evaluator.commandCount];
                int currentState = evaluator.checksumState();
                assert (value == currentState) : "Current checksum " + currentState + " != previous checksum " + value;
            }
        }
        ,
        ADD_CALCULATION(1){

            void execute(RolapEvaluator evaluator) {
                RolapCalculation calculation;
                ((RolapEvaluator)evaluator).calculations[((RolapEvaluator)evaluator).calculationCount++] = calculation = (RolapCalculation)evaluator.commands[--evaluator.commandCount];
            }
        }
        ,
        REMOVE_CALCULATION(1){

            void execute(RolapEvaluator evaluator) {
                RolapCalculation calculation = (RolapCalculation)evaluator.commands[--evaluator.commandCount];
                evaluator.removeCalculation(calculation, false);
            }
        }
        ,
        SAVEPOINT(0){

            void execute(RolapEvaluator evaluator) {
            }
        };

        public final int width;

        private Command(int argCount) {
            this.width = argCount + 1;
        }

        abstract void execute(RolapEvaluator var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScopedMaxSolveOrderFinderState {
        START,
        AGG_SCOPE,
        CUBE_SCOPE,
        QUERY_SCOPE;

    }
}

