/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartMemberListCache;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberCacheHelper
implements MemberCache {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    final SmartMemberListCache<RolapMember, List<RolapMember>> mapMemberToChildren;
    SmartCache<Pair<RolapCubeLevel, Object>, RolapMember> mapKeyToMember;
    RolapCubeHierarchy rolapHierarchy;
    final SmartMemberListCache<RolapLevel, List<RolapMember>> mapLevelToMembers;

    public MemberCacheHelper(RolapCubeHierarchy rolapHierarchy) {
        this.rolapHierarchy = rolapHierarchy;
        this.mapLevelToMembers = new SmartMemberListCache();
        this.mapKeyToMember = new SoftSmartCache<Pair<RolapCubeLevel, Object>, RolapMember>();
        this.mapMemberToChildren = new SmartMemberListCache();
    }

    @Override
    public RolapMember getMember(RolapCubeLevel level, Object key) {
        return this.mapKeyToMember.get(Pair.of(level, key));
    }

    @Override
    public Object putMember(RolapCubeLevel level, Object key, RolapMember value) {
        return this.mapKeyToMember.put(Pair.of(level, key), value);
    }

    @Deprecated
    public void putLevelMembersInCache(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.putChildren((RolapCubeLevel)level, constraint, members);
    }

    @Override
    public void putChildren(RolapCubeLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.mapLevelToMembers.put(level, constraint, members);
    }

    @Override
    public List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        return this.mapMemberToChildren.get(member, constraint);
    }

    @Override
    public void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        this.mapMemberToChildren.put(member, constraint, children);
    }

    @Override
    public List<RolapMember> getLevelMembersFromCache(RolapCubeLevel level, TupleConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        }
        return this.mapLevelToMembers.get(level, constraint);
    }

    public synchronized void flushCache() {
        this.mapMemberToChildren.clear();
        this.mapKeyToMember.clear();
        this.mapLevelToMembers.clear();
        for (RolapCubeLevel rolapCubeLevel : this.rolapHierarchy.getLevelList()) {
            rolapCubeLevel.setApproxRowCount(Integer.MIN_VALUE);
        }
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public RolapMember removeMember(RolapCubeLevel level, Object key) {
        if (level == null) {
            level = this.rolapHierarchy.getLevelList().get(0);
        }
        final RolapCubeLevel levelRef = level;
        this.mapLevelToMembers.getCache().execute(new SmartCache.SmartCacheTask<Pair<RolapLevel, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>>> iterator) {
                while (iterator.hasNext()) {
                    Map.Entry<Pair<RolapLevel, Object>, List<RolapMember>> entry = iterator.next();
                    RolapLevel cacheLevel = (RolapLevel)entry.getKey().left;
                    if (!cacheLevel.equals(levelRef) && (!cacheLevel.getHierarchy().equals(levelRef.getHierarchy()) || cacheLevel.getDepth() < levelRef.getDepth())) continue;
                    iterator.remove();
                }
            }
        });
        final RolapMember member = this.getMember(level, key);
        if (member == null) {
            return null;
        }
        final RolapMember parent = member.getParentMember();
        this.mapMemberToChildren.cache.execute(new SmartCache.SmartCacheTask<Pair<RolapMember, Object>, List<RolapMember>>(){

            @Override
            public void execute(Iterator<Map.Entry<Pair<RolapMember, Object>, List<RolapMember>>> iter) {
                while (iter.hasNext()) {
                    Map.Entry<Pair<RolapMember, Object>, List<RolapMember>> entry = iter.next();
                    RolapMember member1 = (RolapMember)entry.getKey().left;
                    Object constraint = entry.getKey().right;
                    if (Util.equals(member1, parent)) {
                        if (constraint == DefaultMemberChildrenConstraint.instance()) {
                            List<RolapMember> siblings = entry.getValue();
                            siblings.remove(member);
                        } else {
                            iter.remove();
                        }
                    }
                    if (!Util.equals(member1, member)) continue;
                    iter.remove();
                }
            }
        });
        return this.mapKeyToMember.put(Pair.of(level, key), null);
    }
}

