/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Level;

class XtdFunDef
extends FunDefBase {
    private final Level.Type levelType;
    static final ResolverImpl MtdResolver = new ResolverImpl("Mtd", "Mtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Month.", new String[]{"fx", "fxm"}, Level.Type.TIME_MONTHS);
    static final ResolverImpl QtdResolver = new ResolverImpl("Qtd", "Qtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Quarter.", new String[]{"fx", "fxm"}, Level.Type.TIME_QUARTERS);
    static final ResolverImpl WtdResolver = new ResolverImpl("Wtd", "Wtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Week.", new String[]{"fx", "fxm"}, Level.Type.TIME_WEEKS);
    static final ResolverImpl YtdResolver = new ResolverImpl("Ytd", "Ytd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Year.", new String[]{"fx", "fxm"}, Level.Type.TIME_YEARS);

    public XtdFunDef(FunDef dummyFunDef, Level.Type levelType) {
        super(dummyFunDef);
        assert (levelType.isTime());
        this.levelType = levelType;
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            RolapHierarchy defaultTimeHierarchy = ((RolapCube)validator.getQuery().getCube()).getTimeHierarchy(this.getName());
            return new SetType(MemberType.forHierarchy(defaultTimeHierarchy));
        }
        Type type = args[0].getType();
        if (type.getDimension().getDimensionType() != Dimension.Type.TIME) {
            throw MondrianResource.instance().TimeArgNeeded.ex(this.getName());
        }
        return super.getResultType(validator, args);
    }

    private Level getLevel(Evaluator evaluator) {
        return evaluator.getCube().getTimeLevel(this.levelType);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final Level level = this.getLevel(compiler.getEvaluator());
        switch (call.getArgCount()) {
            case 0: {
                return new AbstractListCalc(call, new Calc[0]){

                    public TupleList evaluateList(Evaluator evaluator) {
                        return new UnaryTupleList(FunUtil.periodsToDate(evaluator, level, null));
                    }

                    public boolean dependsOn(Hierarchy hierarchy) {
                        return hierarchy.getDimension().getDimensionType() == Dimension.Type.TIME;
                    }
                };
            }
        }
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{memberCalc}){

            public TupleList evaluateList(Evaluator evaluator) {
                return new UnaryTupleList(FunUtil.periodsToDate(evaluator, level, memberCalc.evaluateMember(evaluator)));
            }
        };
    }

    private static class ResolverImpl
    extends MultiResolver {
        private final Level.Type levelType;

        public ResolverImpl(String name, String signature, String description, String[] signatures, Level.Type levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new XtdFunDef(dummyFunDef, this.levelType);
        }
    }
}

