/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.ScalarType;

class DrilldownLevelTopBottomFunDef
extends FunDefBase {
    final boolean top;
    static final MultiResolver DrilldownLevelTopResolver = new MultiResolver("DrilldownLevelTop", "DrilldownLevelTop(Set_Expression, Count [, [Level_Expression][, Numeric_Expression]])", "Drills down the topmost members of a set, at a specified level, to one level below.", new String[]{"fxxn", "fxxnl", "fxxnln", "fxxnen"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new DrilldownLevelTopBottomFunDef(dummyFunDef, true);
        }
    };
    static final MultiResolver DrilldownLevelBottomResolver = new MultiResolver("DrilldownLevelBottom", "DrilldownLevelBottom(Set_Expression, Count [, [Level_Expression][, Numeric_Expression]])", "Drills down the bottommost members of a set, at a specified level, to one level below.", new String[]{"fxxn", "fxxnl", "fxxnln", "fxxnen"}){

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new DrilldownLevelTopBottomFunDef(dummyFunDef, false);
        }
    };

    public DrilldownLevelTopBottomFunDef(FunDef dummyFunDef, boolean top) {
        super(dummyFunDef);
        this.top = top;
    }

    public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0), true);
        final IntegerCalc integerCalc = compiler.compileInteger(call.getArg(1));
        final LevelCalc levelCalc = call.getArgCount() > 2 && call.getArg(2).getCategory() != 17 ? compiler.compileLevel(call.getArg(2)) : null;
        final Calc orderCalc = call.getArgCount() > 3 ? compiler.compileScalar(call.getArg(3), true) : new ValueCalc(new DummyExp(new ScalarType()));
        return new AbstractListCalc(call, new Calc[]{listCalc, integerCalc, orderCalc}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TupleList evaluateList(Evaluator evaluator) {
                SchemaReader schemaReader = evaluator.getSchemaReader();
                NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
                if (nativeEvaluator != null) {
                    return (TupleList)nativeEvaluator.execute(ResultStyle.LIST);
                }
                TupleList list = listCalc.evaluateList(evaluator);
                int n = integerCalc.evaluateInteger(evaluator);
                if (n == -2147483647 || n <= 0) {
                    return list;
                }
                Level level = levelCalc == null ? null : levelCalc.evaluateLevel(evaluator);
                ArrayList<Member> result = new ArrayList<Member>();
                assert (list.getArity() == 1);
                for (Member member : list.slice(0)) {
                    List<Member> sortedChildren;
                    result.add(member);
                    if (level != null && member.getLevel() != level) {
                        if (level.getDimension() == member.getDimension()) continue;
                        throw FunUtil.newEvalException(DrilldownLevelTopBottomFunDef.this, "Level '" + level.getUniqueName() + "' not compatible with member '" + member.getUniqueName() + "'");
                    }
                    List<Member> children = schemaReader.getMemberChildren(member);
                    int savepoint = evaluator.savepoint();
                    try {
                        evaluator.setNonEmpty(false);
                        sortedChildren = FunUtil.sortMembers(evaluator, children, children, orderCalc, DrilldownLevelTopBottomFunDef.this.top, true);
                    }
                    finally {
                        evaluator.restore(savepoint);
                    }
                    int x = Math.min(n, sortedChildren.size());
                    for (int i = 0; i < x; ++i) {
                        result.add(sortedChildren.get(i));
                    }
                }
                return new UnaryTupleList(result);
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 3.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

