/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.io.PrintWriter;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DateTimeCalc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.IterCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.ResultStyle;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Parameter;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingExpCompiler
implements ExpCompiler {
    private final ExpCompiler parent;

    protected DelegatingExpCompiler(ExpCompiler parent) {
        this.parent = parent;
    }

    protected Calc afterCompile(Exp exp, Calc calc, boolean mutable) {
        return calc;
    }

    @Override
    public Evaluator getEvaluator() {
        return this.parent.getEvaluator();
    }

    @Override
    public Validator getValidator() {
        return this.parent.getValidator();
    }

    @Override
    public Calc compile(Exp exp) {
        Calc calc = this.parent.compile(this.wrap(exp));
        return this.afterCompile(exp, calc, false);
    }

    @Override
    public Calc compileAs(Exp exp, Type resultType, List<ResultStyle> preferredResultTypes) {
        return this.parent.compileAs(this.wrap(exp), resultType, preferredResultTypes);
    }

    @Override
    public MemberCalc compileMember(Exp exp) {
        MemberCalc calc = this.parent.compileMember(this.wrap(exp));
        return (MemberCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public LevelCalc compileLevel(Exp exp) {
        LevelCalc calc = this.parent.compileLevel(this.wrap(exp));
        return (LevelCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public DimensionCalc compileDimension(Exp exp) {
        DimensionCalc calc = this.parent.compileDimension(this.wrap(exp));
        return (DimensionCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public HierarchyCalc compileHierarchy(Exp exp) {
        HierarchyCalc calc = this.parent.compileHierarchy(this.wrap(exp));
        return (HierarchyCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public IntegerCalc compileInteger(Exp exp) {
        IntegerCalc calc = this.parent.compileInteger(this.wrap(exp));
        return (IntegerCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public StringCalc compileString(Exp exp) {
        StringCalc calc = this.parent.compileString(this.wrap(exp));
        return (StringCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public DateTimeCalc compileDateTime(Exp exp) {
        DateTimeCalc calc = this.parent.compileDateTime(this.wrap(exp));
        return (DateTimeCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public final ListCalc compileList(Exp exp) {
        return this.compileList(exp, false);
    }

    @Override
    public ListCalc compileList(Exp exp, boolean mutable) {
        ListCalc calc = this.parent.compileList(this.wrap(exp), mutable);
        return (ListCalc)this.afterCompile(exp, calc, mutable);
    }

    @Override
    public IterCalc compileIter(Exp exp) {
        IterCalc calc = this.parent.compileIter(this.wrap(exp));
        return (IterCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public BooleanCalc compileBoolean(Exp exp) {
        BooleanCalc calc = this.parent.compileBoolean(this.wrap(exp));
        return (BooleanCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public DoubleCalc compileDouble(Exp exp) {
        DoubleCalc calc = this.parent.compileDouble(this.wrap(exp));
        return (DoubleCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public TupleCalc compileTuple(Exp exp) {
        TupleCalc calc = this.parent.compileTuple(this.wrap(exp));
        return (TupleCalc)this.afterCompile(exp, calc, false);
    }

    @Override
    public Calc compileScalar(Exp exp, boolean scalar) {
        Calc calc = this.parent.compileScalar(this.wrap(exp), scalar);
        return this.afterCompile(exp, calc, false);
    }

    @Override
    public ParameterSlot registerParameter(Parameter parameter) {
        return this.parent.registerParameter(parameter);
    }

    @Override
    public List<ResultStyle> getAcceptableResultStyles() {
        return this.parent.getAcceptableResultStyles();
    }

    private Exp wrap(Exp e) {
        return new WrapExp(e, this);
    }

    private static class WrapExp
    implements Exp {
        private final Exp e;
        private final ExpCompiler wrappingCompiler;

        WrapExp(Exp e, ExpCompiler wrappingCompiler) {
            assert (e != null);
            this.e = e;
            this.wrappingCompiler = wrappingCompiler;
        }

        public Exp clone() {
            throw new UnsupportedOperationException();
        }

        public int getCategory() {
            return this.e.getCategory();
        }

        public Type getType() {
            return this.e.getType();
        }

        public void unparse(PrintWriter pw) {
            this.e.unparse(pw);
        }

        public Exp accept(Validator validator) {
            return this.e.accept(validator);
        }

        public Calc accept(ExpCompiler compiler) {
            return this.e.accept(this.wrappingCompiler);
        }

        public Object accept(MdxVisitor visitor) {
            return this.e.accept(visitor);
        }
    }
}

