/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class SearchFunction
implements Function {
    private static final long serialVersionUID = -6581390286475368968L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 2 || parameterCount > 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type searchType = parameters.getType(0);
        Object searchValue = parameters.getValue(0);
        Type textType = parameters.getType(1);
        Object textValue = parameters.getValue(1);
        Type indexType = null;
        Object indexValue = null;
        if (parameterCount == 3) {
            indexType = parameters.getType(2);
            indexValue = parameters.getValue(2);
            if (indexType == null || indexValue == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_MISSING_ARGUMENT_VALUE);
            }
        }
        String search = typeRegistry.convertToText(searchType, searchValue);
        String text = typeRegistry.convertToText(textType, textValue);
        if (search == null || text == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int indexFrom = 0;
        if (indexType != null) {
            Number n = typeRegistry.convertToNumber(indexType, indexValue);
            if (n.intValue() >= 1) {
                indexFrom = n.intValue() - 1;
            } else {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        }
        StringBuffer b = new StringBuffer();
        char[] chars = search.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == '?') {
                b.append(".{1}+");
                continue;
            }
            if (aChar == '*') {
                b.append(".*?");
                continue;
            }
            if (aChar == '.' || aChar == '{' || aChar == '}' || aChar == '(' || aChar == ')' || aChar == '+' || aChar == '*' || aChar == '\\' || aChar == '?') {
                b.append('\\');
                b.append(aChar);
                continue;
            }
            b.append(aChar);
        }
        Pattern patter = Pattern.compile(b.toString(), 2);
        Matcher matcher = patter.matcher(text);
        boolean found = matcher.find(indexFrom);
        if (!found) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NOT_FOUND_VALUE);
        }
        int i = matcher.start();
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(i + 1));
    }

    @Override
    public String getCanonicalName() {
        return "SEARCH";
    }
}

