/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContextFactory;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;

public class DefaultFormulaContextFactory
implements FormulaContextFactory {
    public static final DefaultFormulaContextFactory INSTANCE = new DefaultFormulaContextFactory();
    private HashMap<Key, DefaultFormulaContext> contexts = new HashMap();

    @Override
    public synchronized FormulaContext create(Locale locale, TimeZone timeZone) {
        Key k = new Key(locale, timeZone);
        DefaultFormulaContext cached = this.contexts.get(k);
        if (cached != null) {
            return cached;
        }
        DefaultFormulaContext created = new DefaultFormulaContext(LibFormulaBoot.getInstance().getGlobalConfig(), locale, timeZone);
        this.contexts.put(k, created);
        return created;
    }

    public synchronized void clear() {
        this.contexts.clear();
    }

    private static class Key {
        private Locale locale;
        private TimeZone timeZone;

        public Key(Locale locale, TimeZone timeZone) {
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.locale != null ? !this.locale.equals(key.locale) : key.locale != null) {
                return false;
            }
            return !(this.timeZone != null ? !this.timeZone.equals(key.timeZone) : key.timeZone != null);
        }

        public int hashCode() {
            int result = this.locale != null ? this.locale.hashCode() : 0;
            result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
            return result;
        }
    }
}

