/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.SlaveSequence;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SocketPortAllocation;

public class TransformationMap {
    private final Map<CarteObjectEntry, TransData> transMap = new ConcurrentHashMap<CarteObjectEntry, TransData>();
    private final Map<String, List<SocketPortAllocation>> hostServerSocketPortsMap = new ConcurrentHashMap<String, List<SocketPortAllocation>>();
    private SlaveServerConfig slaveServerConfig;

    public void addTransformation(String transformationName, String containerObjectId, Trans trans, TransConfiguration transConfiguration) {
        CarteObjectEntry entry = new CarteObjectEntry(transformationName, containerObjectId);
        this.transMap.put(entry, new TransData(trans, transConfiguration));
    }

    public void registerTransformation(Trans trans, TransConfiguration transConfiguration) {
        trans.setContainerObjectId(UUID.randomUUID().toString());
        CarteObjectEntry entry = new CarteObjectEntry(trans.getTransMeta().getName(), trans.getContainerObjectId());
        this.transMap.put(entry, new TransData(trans, transConfiguration));
    }

    public Trans getTransformation(String transformationName) {
        for (CarteObjectEntry entry : this.transMap.keySet()) {
            if (!entry.getName().equals(transformationName)) continue;
            return this.transMap.get(entry).getTrans();
        }
        return null;
    }

    public Trans getTransformation(CarteObjectEntry entry) {
        return this.transMap.get(entry).getTrans();
    }

    public TransConfiguration getConfiguration(String transformationName) {
        for (CarteObjectEntry entry : this.transMap.keySet()) {
            if (!entry.getName().equals(transformationName)) continue;
            return this.transMap.get(entry).getConfiguration();
        }
        return null;
    }

    public TransConfiguration getConfiguration(CarteObjectEntry entry) {
        return this.transMap.get(entry).getConfiguration();
    }

    public void removeTransformation(CarteObjectEntry entry) {
        this.transMap.remove(entry);
    }

    public List<CarteObjectEntry> getTransformationObjects() {
        return new ArrayList<CarteObjectEntry>(this.transMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketPortAllocation allocateServerSocketPort(int portRangeStart, String hostname, String clusteredRunId, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) {
        if (Utils.isEmpty((CharSequence)clusteredRunId)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a cluster run ID but it was empty");
        }
        if (portRangeStart <= 0) {
            throw new RuntimeException("A server socket allocation always has to accompanied by port range start > 0 but it was " + portRangeStart);
        }
        if (Utils.isEmpty((CharSequence)hostname)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a hostname but it was empty");
        }
        if (Utils.isEmpty((CharSequence)transformationName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a transformation name but it was empty");
        }
        if (Utils.isEmpty((CharSequence)sourceSlaveName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source slave server name but it was empty");
        }
        if (Utils.isEmpty((CharSequence)targetSlaveName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target slave server name but it was empty");
        }
        if (Utils.isEmpty((CharSequence)sourceStepName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source step name but it was empty");
        }
        if (Utils.isEmpty((CharSequence)targetStepName)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target step name but it was empty");
        }
        if (Utils.isEmpty((CharSequence)sourceStepCopy)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a source step copy but it was empty");
        }
        if (Utils.isEmpty((CharSequence)targetStepCopy)) {
            throw new RuntimeException("A server socket allocation always has to accompanied by a target step copy but it was empty");
        }
        List<SocketPortAllocation> serverSocketPorts = this.hostServerSocketPortsMap.computeIfAbsent(hostname, k -> new CopyOnWriteArrayList());
        serverSocketPorts = serverSocketPorts != null ? serverSocketPorts : this.hostServerSocketPortsMap.get(hostname);
        SocketPortAllocation socketPortAllocation = null;
        int maxPort = portRangeStart - 1;
        for (int index = 0; index < serverSocketPorts.size(); ++index) {
            SocketPortAllocation spa = serverSocketPorts.get(index);
            if (spa.getPort() > maxPort) {
                maxPort = spa.getPort();
            }
            SocketPortAllocation socketPortAllocation2 = spa;
            synchronized (socketPortAllocation2) {
                if (spa.getClusterRunId().equalsIgnoreCase(clusteredRunId) && spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) && spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName) && spa.getTransformationName().equalsIgnoreCase(transformationName) && spa.getSourceStepName().equalsIgnoreCase(sourceStepName) && spa.getSourceStepCopy().equalsIgnoreCase(sourceStepCopy) && spa.getTargetStepName().equalsIgnoreCase(targetStepName) && spa.getTargetStepCopy().equalsIgnoreCase(targetStepCopy)) {
                    spa.setAllocated(true);
                    socketPortAllocation = spa;
                    break;
                }
                if (!spa.isAllocated() && spa.getSourceSlaveName().equalsIgnoreCase(sourceSlaveName) && spa.getTargetSlaveName().equalsIgnoreCase(targetSlaveName)) {
                    socketPortAllocation = new SocketPortAllocation(spa.getPort(), new Date(), clusteredRunId, transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
                    serverSocketPorts.set(index, socketPortAllocation);
                    break;
                }
                continue;
            }
        }
        if (socketPortAllocation == null) {
            socketPortAllocation = new SocketPortAllocation(maxPort + 1, new Date(), clusteredRunId, transformationName, sourceSlaveName, sourceStepName, sourceStepCopy, targetSlaveName, targetStepName, targetStepCopy);
            serverSocketPorts.add(socketPortAllocation);
        }
        return socketPortAllocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocateServerSocketPorts(String transName, String carteObjectId) {
        for (String hostname : this.hostServerSocketPortsMap.keySet()) {
            List<SocketPortAllocation> spas = this.hostServerSocketPortsMap.get(hostname);
            Iterator<SocketPortAllocation> iterator = spas.iterator();
            while (iterator.hasNext()) {
                SocketPortAllocation spa;
                SocketPortAllocation socketPortAllocation = spa = iterator.next();
                synchronized (socketPortAllocation) {
                    if (spa.getTransformationName().equalsIgnoreCase(transName) && (Utils.isEmpty((CharSequence)carteObjectId) || spa.getClusterRunId().equals(carteObjectId))) {
                        spa.setAllocated(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocateServerSocketPorts(CarteObjectEntry entry) {
        for (String hostname : this.hostServerSocketPortsMap.keySet()) {
            List<SocketPortAllocation> serverSocketPorts = this.hostServerSocketPortsMap.get(hostname);
            Iterator<SocketPortAllocation> iterator = this.hostServerSocketPortsMap.get(hostname).iterator();
            while (iterator.hasNext()) {
                SocketPortAllocation spa;
                SocketPortAllocation socketPortAllocation = spa = iterator.next();
                synchronized (socketPortAllocation) {
                    if (spa.getTransformationName().equalsIgnoreCase(entry.getName())) {
                        spa.setAllocated(false);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocateServerSocketPort(int port, String hostname) {
        List<SocketPortAllocation> serverSocketPorts = this.hostServerSocketPortsMap.get(hostname);
        if (serverSocketPorts == null) {
            return;
        }
        Iterator<SocketPortAllocation> iterator = serverSocketPorts.iterator();
        while (iterator.hasNext()) {
            SocketPortAllocation spa;
            SocketPortAllocation socketPortAllocation = spa = iterator.next();
            synchronized (socketPortAllocation) {
                if (spa.getPort() == port) {
                    spa.setAllocated(false);
                    return;
                }
            }
        }
    }

    public CarteObjectEntry getFirstCarteObjectEntry(String transName) {
        for (CarteObjectEntry key : this.transMap.keySet()) {
            if (!key.getName().equals(transName)) continue;
            return key;
        }
        return null;
    }

    public SlaveServerConfig getSlaveServerConfig() {
        return this.slaveServerConfig;
    }

    public void setSlaveServerConfig(SlaveServerConfig slaveServerConfig) {
        this.slaveServerConfig = slaveServerConfig;
    }

    public List<SocketPortAllocation> getHostServerSocketPorts(String hostname) {
        List<SocketPortAllocation> ports = this.hostServerSocketPortsMap.get(hostname);
        return ports == null ? Collections.emptyList() : Collections.unmodifiableList(ports);
    }

    public SlaveSequence getSlaveSequence(String name) {
        return SlaveSequence.findSlaveSequence(name, this.slaveServerConfig.getSlaveSequences());
    }

    public boolean isAutomaticSlaveSequenceCreationAllowed() {
        return this.slaveServerConfig.isAutomaticCreationAllowed();
    }

    public SlaveSequence createSlaveSequence(String name) throws KettleException {
        SlaveSequence auto = this.slaveServerConfig.getAutoSequence();
        if (auto == null) {
            throw new KettleException("No auto-sequence information found in the slave server config.  Slave sequence could not be created automatically.");
        }
        SlaveSequence slaveSequence = new SlaveSequence(name, auto.getStartValue(), auto.getDatabaseMeta(), auto.getSchemaName(), auto.getTableName(), auto.getSequenceNameField(), auto.getValueField());
        this.slaveServerConfig.getSlaveSequences().add(slaveSequence);
        return slaveSequence;
    }

    private static class TransData {
        private Trans trans;
        private TransConfiguration configuration;

        TransData(Trans trans, TransConfiguration configuration) {
            this.trans = trans;
            this.configuration = configuration;
        }

        public Trans getTrans() {
            return this.trans;
        }

        public void setTrans(Trans trans) {
            this.trans = trans;
        }

        public TransConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(TransConfiguration configuration) {
            this.configuration = configuration;
        }
    }
}

