/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.Date;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Node;

public class SlaveServerDetection {
    public static final String XML_TAG = "SlaveServerDetection";
    private SlaveServer slaveServer;
    private boolean active;
    private Date lastActiveDate;
    private Date lastInactiveDate;

    public static final SlaveRelationShip getSlaveRelationShip(String code) {
        for (SlaveRelationShip slaveRelationShip : SlaveRelationShip.values()) {
            if (!slaveRelationShip.getCode().equalsIgnoreCase(code)) continue;
            return slaveRelationShip;
        }
        return null;
    }

    public SlaveServerDetection(SlaveServer slaveServer) {
        this.slaveServer = slaveServer;
        this.active = true;
        this.lastActiveDate = new Date();
        this.lastInactiveDate = null;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append(this.slaveServer.getXML());
        xml.append(XMLHandler.addTagValue((String)"active", (boolean)this.active));
        xml.append(XMLHandler.addTagValue((String)"last_active_date", (Date)this.lastActiveDate));
        xml.append(XMLHandler.addTagValue((String)"last_inactive_date", (Date)this.lastInactiveDate));
        xml.append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public SlaveServerDetection(Node node) {
        this.slaveServer = new SlaveServer(XMLHandler.getSubNode((Node)node, (String)"slaveserver"));
        this.active = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"active"));
        this.lastActiveDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)node, (String)"last_active_date"));
        this.lastInactiveDate = XMLHandler.stringToDate((String)XMLHandler.getTagValue((Node)node, (String)"last_inactive_date"));
    }

    public boolean equals(Object ssd) {
        return this.slaveServer.equals(((SlaveServerDetection)ssd).getSlaveServer());
    }

    public int hashCode() {
        return this.slaveServer.hashCode();
    }

    public SlaveServer getSlaveServer() {
        return this.slaveServer;
    }

    public void setSlaveServer(SlaveServer slaveServer) {
        this.slaveServer = slaveServer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Date getLastActiveDate() {
        return this.lastActiveDate;
    }

    public void setLastActiveDate(Date lastActiveDate) {
        this.lastActiveDate = lastActiveDate;
    }

    public Date getLastInactiveDate() {
        return this.lastInactiveDate;
    }

    public void setLastInactiveDate(Date lastInactiveDate) {
        this.lastInactiveDate = lastInactiveDate;
    }

    public static enum SlaveRelationShip {
        SLAVE_SEVER("SLAVE_SERVER", "Slave server"),
        FAILOVER_MASTER("FAILOVER_MASTER", "Fail-over master server");

        private String code;
        private String description;

        private SlaveRelationShip(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

