/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.IdNotFoundException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.WebResult;

public class RunJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = 1192413943669836775L;
    private static Class<?> PKG = RunJobServlet.class;
    public static final String CONTEXT_PATH = "/kettle/runJob";
    private static final String UNAUTHORIZED_ACCESS_TO_REPOSITORY = "The server sent HTTP status code 401";
    private static final String UNABLE_TO_LOAD_JOB = "Unable to load job";

    public RunJobServlet() {
    }

    public RunJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"RunJobServlet.Log.RunJobRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"job", "level"};
        String transOption = request.getParameter("job");
        String levelOption = request.getParameter("level");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        SlaveServerConfig serverConfig = this.transformationMap.getSlaveServerConfig();
        try {
            Repository slaveServerRepository = serverConfig.getRepository();
            if (slaveServerRepository == null || !slaveServerRepository.isConnected()) {
                response.setStatus(401);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnableToConnectToRepository", (String[])new String[]{serverConfig.getRepositoryId()})));
                return;
            }
            if (transOption == null) {
                response.setStatus(400);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.MissingMandatoryParameterJob", (String[])new String[0])));
                return;
            }
            JobMeta jobMeta = this.loadJob(slaveServerRepository, transOption);
            String[] parameters = jobMeta.listParameters();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameter = (String)parameterNames.nextElement();
                String[] values = request.getParameterValues(parameter);
                if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
                if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                    jobMeta.setVariable(parameter, values[0]);
                    continue;
                }
                jobMeta.setParameterValue(parameter, values[0]);
            }
            JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
            if (levelOption != null && !this.isValidLogLevel(levelOption)) {
                response.setStatus(400);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.InvalidLogLevel", (String[])new String[0])));
                return;
            }
            LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
            jobExecutionConfiguration.setLogLevel(logLevel);
            final Repository repository = jobExecutionConfiguration.connectRepository(serverConfig.getRepositoryId(), serverConfig.getRepositoryUsername(), serverConfig.getRepositoryPassword());
            JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
            String carteObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
            servletLoggingObject.setContainerObjectId(carteObjectId);
            servletLoggingObject.setLogLevel(logLevel);
            Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
            job.initializeVariablesFrom(null);
            job.getJobMeta().setInternalKettleVariables(job);
            job.injectVariables(jobConfiguration.getJobExecutionConfiguration().getVariables());
            job.copyParametersFrom(jobMeta);
            job.clearParameters();
            jobMeta.activateParameters();
            job.setSocketRepository(this.getSocketRepository());
            JobMap jobMap = this.getJobMap();
            jobMap.addJob(job.getJobname(), carteObjectId, job, jobConfiguration);
            job.addJobListener(new JobAdapter(){

                @Override
                public void jobFinished(Job job) {
                    repository.disconnect();
                }
            });
            String message = "Job '" + job.getJobname() + "' was added to the list with id " + carteObjectId;
            this.logBasic(message);
            try {
                this.runJob(job);
                WebResult webResult = new WebResult("OK", "Job started", carteObjectId);
                out.println(webResult.getXML());
                out.flush();
            }
            catch (Exception executionException) {
                response.setStatus(500);
                String logging = KettleLogStore.getAppender().getBuffer(job.getLogChannelId(), false).toString();
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.ErrorExecutingJob", (String[])new String[]{serverConfig.getRepositoryId(), logging})));
            }
        }
        catch (IdNotFoundException idEx) {
            response.setStatus(401);
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnableToRunJob", (String[])new String[]{serverConfig.getRepositoryId()})));
        }
        catch (Exception ex) {
            if (ex.getMessage().contains(UNAUTHORIZED_ACCESS_TO_REPOSITORY)) {
                response.setStatus(401);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnableToConnectToRepository", (String[])new String[]{serverConfig.getRepositoryId()})));
                return;
            }
            if (ex.getMessage().contains(UNABLE_TO_LOAD_JOB)) {
                response.setStatus(404);
                out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnableToFindJob", (String[])new String[]{serverConfig.getRepositoryId()})));
                return;
            }
            response.setStatus(500);
            out.println(new WebResult("ERROR", BaseMessages.getString(PKG, (String)"RunJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ex)})));
        }
    }

    protected void runJob(Job job) {
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobMeta loadJob(Repository repository, String job) throws KettleException {
        if (repository == null) {
            throw new KettleException("Repository required.");
        }
        Repository repository2 = repository;
        synchronized (repository2) {
            String name;
            String directoryPath;
            int lastSlash = job.lastIndexOf("/");
            if (lastSlash < 0) {
                directoryPath = "/";
                name = job;
            } else {
                directoryPath = job.substring(0, lastSlash);
                name = job.substring(lastSlash + 1);
            }
            RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
            ObjectId jobID = repository.getJobId(name, directory);
            JobMeta transJob = repository.loadJob(jobID, null);
            return transJob;
        }
    }

    private boolean isValidLogLevel(String levelOption) {
        for (LogLevel level : LogLevel.values()) {
            if (!level.getCode().equals(levelOption)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Run Job";
    }

    @Override
    public String getService() {
        return "/kettle/runJob (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

