/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webservices.wsdl;

import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.xml.WSDLLocator;
import org.xml.sax.InputSource;

public final class ControlWsdlLocator
implements WSDLLocator {
    private final String _wsdlName;
    private final BeanContext _beanContext;
    private List<InputStream> _openStreams = new ArrayList<InputStream>();

    public ControlWsdlLocator(String wsdlName, BeanContext beanContext) {
        if (wsdlName == null) {
            throw new IllegalArgumentException("ERROR: WSDL path is null!");
        }
        this._wsdlName = wsdlName;
        this._beanContext = beanContext;
    }

    public void cleanup() {
        for (InputStream inputStream : this._openStreams) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputSource getBaseInputSource() {
        InputStream wsdlStream = null;
        try {
            URL url = new URL(this._wsdlName);
            wsdlStream = url.openStream();
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load WSDL file: " + this._wsdlName, e);
        }
        if (wsdlStream == null) {
            wsdlStream = this._beanContext.getBeanContext().getResourceAsStream(this._wsdlName, this._beanContext);
        }
        if (wsdlStream == null) {
            wsdlStream = this.getClass().getClassLoader().getResourceAsStream(this._wsdlName);
        }
        if (wsdlStream == null) {
            throw new RuntimeException("Cannot find WSDL file: " + this._wsdlName, null);
        }
        this._openStreams.add(wsdlStream);
        return new InputSource(wsdlStream);
    }

    public String getBaseURI() {
        try {
            URI uri = new URI(this._wsdlName);
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public InputSource getImportInputSource(String string, String string1) {
        return null;
    }

    public String getLatestImportURI() {
        return null;
    }

    public void close() {
        this.cleanup();
    }
}

