/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.pentaho.di.trans.steps.update.UpdateMeta;

public class Update
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = UpdateMeta.class;
    private UpdateMeta meta;
    private UpdateData data;

    public Update(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] add;
        Object[] outputRow = row;
        if (!Utils.isEmpty((CharSequence)this.meta.getIgnoreFlagField())) {
            outputRow = new Object[this.data.outputRowMeta.size()];
            for (int i = 0; i < rowMeta.size(); ++i) {
                outputRow[i] = row[i];
            }
        }
        Object[] lookupRow = new Object[this.data.lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < this.data.keynrs.length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                ++lookupIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        if (!this.meta.isSkipLookup()) {
            this.data.db.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.prepStatementLookup);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.ValuesSetForLookup", (String[])new String[]{this.data.lookupParameterRowMeta.getString(lookupRow), rowMeta.getString(row)}));
            }
            add = this.data.db.getLookup(this.data.prepStatementLookup);
            returnRowMeta = this.data.db.getReturnRowMeta();
        } else {
            add = null;
        }
        this.incrementLinesInput();
        if (add == null && !this.meta.isSkipLookup()) {
            if (!this.meta.isErrorIgnored()) {
                if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Update.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
                outputRow = null;
                if (this.data.stringErrorKeyNotFound == null) {
                    this.data.stringErrorKeyNotFound = BaseMessages.getString(PKG, (String)"Update.Exception.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow);
                    this.data.stringFieldnames = "";
                    for (int i = 0; i < this.data.lookupParameterRowMeta.size(); ++i) {
                        if (i > 0) {
                            this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                        }
                        this.data.stringFieldnames = this.data.stringFieldnames + this.data.lookupParameterRowMeta.getValueMeta(i).getName();
                    }
                }
                this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
                return outputRow;
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.KeyCouldNotFound", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                if (Utils.isEmpty((CharSequence)this.meta.getIgnoreFlagField())) return outputRow;
                outputRow[rowMeta.size()] = Boolean.FALSE;
            }
            return outputRow;
        } else {
            if (!this.meta.isSkipLookup() && this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"Update.Log.FoundRow", (String[])new String[0]) + this.data.lookupReturnRowMeta.getString(add));
            }
            boolean update = false;
            if (this.meta.isSkipLookup()) {
                update = true;
            } else {
                for (int i = 0; i < this.data.valuenrs.length; ++i) {
                    Object retvalue;
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.valuenrs[i]);
                    Object rowvalue = row[this.data.valuenrs[i]];
                    ValueMetaInterface returnValueMeta = returnRowMeta.getValueMeta(i);
                    if (returnValueMeta.compare(retvalue = add[i], valueMeta, rowvalue) == 0) continue;
                    update = true;
                }
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[this.data.updateParameterRowMeta.size()];
                for (i = 0; i < this.data.valuenrs.length; ++i) {
                    updateRow[i] = row[this.data.valuenrs[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[this.data.valuenrs.length + i] = lookupRow[i];
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"Update.Log.UpdateRow", (String[])new String[0]) + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                this.data.db.setValues(this.data.updateParameterRowMeta, updateRow, this.data.prepStatementUpdate);
                this.data.db.insertRow(this.data.prepStatementUpdate, this.meta.useBatchUpdate(), true);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
            if (Utils.isEmpty((CharSequence)this.meta.getIgnoreFlagField())) return outputRow;
            outputRow[rowMeta.size()] = Boolean.TRUE;
        }
        return outputRow;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block19: {
            this.meta = (UpdateMeta)smi;
            this.data = (UpdateData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.CheckingRow", (String[])new String[0]) + this.getInputRowMeta().getString(r));
                }
                ArrayList<Integer> keynrs = new ArrayList<Integer>(this.meta.getKeyStream().length);
                ArrayList<Integer> keynrs2 = new ArrayList<Integer>(this.meta.getKeyStream().length);
                for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                    int keynr2;
                    int keynr = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                    if (keynr < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Update.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream()[i]}));
                    }
                    keynrs.add(keynr);
                    if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        keynrs.add(keynr);
                        keynrs2.add(-1);
                    }
                    if ((keynr2 = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream2()[i])) < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Update.Exception.FieldRequired", (String[])new String[]{this.meta.getKeyStream2()[i]}));
                    }
                    keynrs2.add(keynr2);
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getKeyStream()[i]}) + "" + keynrs.get(keynrs.size() - 1));
                }
                this.data.keynrs = ArrayUtils.toPrimitive((Integer[])keynrs.toArray(new Integer[0]));
                this.data.keynrs2 = ArrayUtils.toPrimitive((Integer[])keynrs2.toArray(new Integer[0]));
                this.data.valuenrs = new int[this.meta.getUpdateLookup().length];
                for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                    this.data.valuenrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                    if (this.data.valuenrs[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"Update.Exception.FieldRequired", (String[])new String[]{this.meta.getUpdateStream()[i]}));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(BaseMessages.getString(PKG, (String)"Update.Log.FieldHasDataNumbers", (String[])new String[]{this.meta.getUpdateStream()[i]}) + "" + this.data.valuenrs[i]);
                }
                if (this.meta.isSkipLookup()) {
                    this.data.lookupParameterRowMeta = new RowMeta();
                    for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                        if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]));
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream2()[i]));
                            continue;
                        }
                        if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]));
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]).clone());
                            continue;
                        }
                        if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) continue;
                        this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]));
                    }
                } else {
                    this.setLookup(this.getInputRowMeta());
                }
                this.prepareUpdate(this.getInputRowMeta());
            }
            try {
                Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
                if (outputRow != null) {
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"Update.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Update.Log.ErrorInStep", (String[])new String[0]), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block19;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "UPD001");
            }
        }
        return true;
    }

    public void setLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting preparedStatement to [" + sql + "]");
            }
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.schemaTable + Const.CR;
        sql = sql + "SET ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ",   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + "WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + " ( ( ";
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
            } else if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
            } else if ("= ~NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " IS NULL AND ";
                sql = databaseMeta.requiresCastToVariousForIsNull() ? sql + "CAST(? AS VARCHAR(256)) IS NULL" : sql + "? IS NULL";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                sql = sql + " ) OR ( " + databaseMeta.quoteField(this.meta.getKeyLookup()[i]) + " = ?";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]).clone());
            } else {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
            }
            sql = sql + " ) ) ";
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Setting update preparedStatement to [" + sql + "]");
            }
            this.data.prepStatementUpdate = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Update.Log.ConnectedToDB", (String[])new String[0]));
                }
                this.data.db.setCommit(this.meta.getCommitSize(this));
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.ErrorOccurred", (String[])new String[0]) + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        if (this.data.db != null) {
            try {
                if (!this.data.db.isAutoCommit()) {
                    if (this.getErrors() == 0L) {
                        this.data.db.emptyAndCommit(this.data.prepStatementUpdate, this.meta.useBatchUpdate());
                    } else {
                        this.data.db.rollback();
                    }
                }
                this.data.db.closePreparedStatement(this.data.prepStatementUpdate);
                this.data.db.closePreparedStatement(this.data.prepStatementLookup);
            }
            catch (KettleDatabaseException e) {
                this.logError(BaseMessages.getString(PKG, (String)"Update.Log.UnableToCommitUpdateConnection", (String[])new String[0]) + this.data.db + "] :" + e.toString());
                this.setErrors(1L);
            }
            finally {
                this.data.db.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }
}

