/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssoutput;

import com.sun.syndication.feed.module.georss.SimpleModuleImpl;
import com.sun.syndication.feed.module.georss.W3CGeoModuleImpl;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndImage;
import com.sun.syndication.feed.synd.SyndImageImpl;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssoutput.RssOutputData;
import org.pentaho.di.trans.steps.rssoutput.RssOutputMeta;

public class RssOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RssOutput.class;
    private RssOutputMeta meta;
    private RssOutputData data;

    public RssOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (RssOutputMeta)smi;
        this.data = (RssOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            if (!this.first) {
                if (!this.meta.isCustomRss()) {
                    this.WriteToFile(this.data.channeltitlevalue, this.data.channellinkvalue, this.data.channeldescriptionvalue, this.data.channelpubdatevalue, this.data.channelcopyrightvalue, this.data.channelimagelinkvalue, this.data.channelimagedescriptionvalue, this.data.channelimagelinkvalue, this.data.channelimageurlvalue, this.data.channellanguagevalue, this.data.channelauthorvalue);
                } else {
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    if (Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                        format.setEncoding("iso-8859-1");
                    } else {
                        format.setEncoding(this.meta.getEncoding());
                    }
                    try {
                        XMLWriter writer = new XMLWriter((Writer)new FileWriter(new File(this.data.filename)), format);
                        writer.write(this.data.document);
                        writer.close();
                    }
                    catch (Exception writer) {
                    }
                    finally {
                        this.data.document = null;
                    }
                }
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.isFilenameInField()) {
                if (Utils.isEmpty((CharSequence)this.meta.getFileNameField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.FilenameFieldMissing", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.indexOfFieldfilename = this.data.inputRowMeta.indexOfValue(this.meta.getFileNameField());
                if (this.data.indexOfFieldfilename < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getFileNameField()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getFileNameField()}));
                }
            } else {
                this.data.filename = this.buildFilename();
            }
            if (Utils.isEmpty((CharSequence)this.data.filename)) {
                this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.FilenameEmpty", (String[])new String[0]));
                throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.FilenameEmpty", (String[])new String[0]));
            }
            if (this.meta.isCreateParentFolder()) {
                FileObject parentfolder = null;
                try {
                    parentfolder = KettleVFS.getFileObject((String)this.data.filename, (VariableSpace)this.getTransMeta()).getParent();
                    if (!parentfolder.exists()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"RssOutput.Log.ParentFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
                        }
                        parentfolder.createFolder();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"RssOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
                        }
                    }
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.CanNotCreateParentFolder", (String[])new String[]{parentfolder.getName().toString()}));
                }
                finally {
                    if (parentfolder != null) {
                        try {
                            parentfolder.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (!this.meta.isCustomRss()) {
                if (Utils.isEmpty((CharSequence)this.meta.getChannelTitle())) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ChannelTitleMissing", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (Utils.isEmpty((CharSequence)this.meta.getChannelDescription())) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ChannelDescription", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (Utils.isEmpty((CharSequence)this.meta.getChannelLink())) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ChannelLink", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.indexOfFieldchanneltitle = this.data.inputRowMeta.indexOfValue(this.meta.getChannelTitle());
                if (this.data.indexOfFieldchanneltitle < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelTitle()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelTitle()}));
                }
                this.data.channeltitlevalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchanneltitle);
                this.data.indexOfFieldchanneldescription = this.data.inputRowMeta.indexOfValue(this.meta.getChannelDescription());
                if (this.data.indexOfFieldchanneldescription < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelDescription()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelDescription()}));
                }
                this.data.channeldescriptionvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchanneldescription);
                this.data.indexOfFieldchannellink = this.data.inputRowMeta.indexOfValue(this.meta.getChannelLink());
                if (this.data.indexOfFieldchannellink < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelLink()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelLink()}));
                }
                this.data.channellinkvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannellink);
                if (!Utils.isEmpty((CharSequence)this.meta.getItemTitle())) {
                    this.data.indexOfFielditemtitle = this.data.inputRowMeta.indexOfValue(this.meta.getItemTitle());
                    if (this.data.indexOfFielditemtitle < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemTitle()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemTitle()}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getItemDescription())) {
                    this.data.indexOfFielditemdescription = this.data.inputRowMeta.indexOfValue(this.meta.getItemDescription());
                    if (this.data.indexOfFielditemdescription < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemDescription()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemDescription()}));
                    }
                }
                if (this.meta.AddGeoRSS()) {
                    if (Utils.isEmpty((CharSequence)this.meta.getGeoPointLong())) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.GeoPointLatEmpty", (String[])new String[0]));
                    }
                    if (Utils.isEmpty((CharSequence)this.meta.getGeoPointLong())) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.GeoPointLongEmpty", (String[])new String[0]));
                    }
                    this.data.indexOfFielditempointx = this.data.inputRowMeta.indexOfValue(this.meta.getGeoPointLat());
                    if (this.data.indexOfFielditempointx < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getGeoPointLat()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getGeoPointLat()}));
                    }
                    this.data.indexOfFielditempointy = this.data.inputRowMeta.indexOfValue(this.meta.getGeoPointLong());
                    if (this.data.indexOfFielditempointy < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getGeoPointLong()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getGeoPointLong()}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getChannelPubDate())) {
                    this.data.indexOfFieldchannelpubdate = this.data.inputRowMeta.indexOfValue(this.meta.getChannelPubDate());
                    if (this.data.indexOfFieldchannelpubdate < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelPubDate()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelPubDate()}));
                    }
                    this.data.channelpubdatevalue = this.data.inputRowMeta.getDate(r, this.data.indexOfFieldchannelpubdate);
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getChannelLanguage())) {
                    this.data.indexOfFieldchannellanguage = this.data.inputRowMeta.indexOfValue(this.meta.getChannelLanguage());
                    if (this.data.indexOfFieldchannellanguage < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelLanguage()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelLanguage()}));
                    }
                    this.data.channellanguagevalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannellanguage);
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getChannelCopyright())) {
                    this.data.indexOfFieldchannelcopyright = this.data.inputRowMeta.indexOfValue(this.meta.getChannelCopyright());
                    if (this.data.indexOfFieldchannelcopyright < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelCopyright()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelCopyright()}));
                    }
                    this.data.channelcopyrightvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelcopyright);
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getChannelAuthor())) {
                    this.data.indexOfFieldchannelauthor = this.data.inputRowMeta.indexOfValue(this.meta.getChannelAuthor());
                    if (this.data.indexOfFieldchannelauthor < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelAuthor()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelAuthor()}));
                    }
                    this.data.channelauthorvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelauthor);
                }
                if (this.meta.AddImage()) {
                    if (!Utils.isEmpty((CharSequence)this.meta.getChannelImageTitle())) {
                        this.data.indexOfFieldchannelimagetitle = this.data.inputRowMeta.indexOfValue(this.meta.getChannelImageTitle());
                        if (this.data.indexOfFieldchannelimagetitle < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageTitle()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageTitle()}));
                        }
                        this.data.channelimagetitlevalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelimagetitle);
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getChannelImageLink())) {
                        this.data.indexOfFieldchannelimagelink = this.data.inputRowMeta.indexOfValue(this.meta.getChannelImageLink());
                        if (this.data.indexOfFieldchannelimagelink < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageLink()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageLink()}));
                        }
                        this.data.channelimagelinkvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelimagelink);
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getChannelImageUrl())) {
                        this.data.indexOfFieldchannelimageurl = this.data.inputRowMeta.indexOfValue(this.meta.getChannelImageUrl());
                        if (this.data.indexOfFieldchannelimageurl < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageUrl()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageUrl()}));
                        }
                        this.data.channelimageurlvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelimageurl);
                    }
                    if (!Utils.isEmpty((CharSequence)this.meta.getChannelImageDescription())) {
                        this.data.indexOfFieldchannelimagedescription = this.data.inputRowMeta.indexOfValue(this.meta.getChannelImageDescription());
                        if (this.data.indexOfFieldchannelimagedescription < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageDescription()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getChannelImageDescription()}));
                        }
                        this.data.channelimagedescriptionvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFieldchannelimagedescription);
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getItemLink())) {
                    this.data.indexOfFielditemlink = this.data.inputRowMeta.indexOfValue(this.meta.getItemLink());
                    if (this.data.indexOfFielditemlink < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemLink()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemLink()}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getItemPubDate())) {
                    this.data.indexOfFielditempubdate = this.data.inputRowMeta.indexOfValue(this.meta.getItemPubDate());
                    if (this.data.indexOfFielditempubdate < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemPubDate()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemPubDate()}));
                    }
                }
                if (!Utils.isEmpty((CharSequence)this.meta.getItemAuthor())) {
                    this.data.indexOfFielditemauthor = this.data.inputRowMeta.indexOfValue(this.meta.getItemAuthor());
                    if (this.data.indexOfFielditemauthor < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemAuthor()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorFindingField", (String[])new String[]{this.meta.getItemAuthor()}));
                    }
                }
            } else {
                int i;
                this.data.customchannels = new int[this.meta.getChannelCustomFields().length];
                for (i = 0; i < this.meta.getChannelCustomFields().length; ++i) {
                    this.data.customchannels[i] = this.data.inputRowMeta.indexOfValue(this.meta.getChannelCustomFields()[i]);
                    if (this.data.customchannels[i] >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"RssOutput.Exception.FieldRequired", (String[])new String[]{this.meta.getChannelCustomFields()[i]}));
                }
                this.data.customitems = new int[this.meta.getItemCustomFields().length];
                for (i = 0; i < this.meta.getItemCustomFields().length; ++i) {
                    this.data.customitems[i] = this.data.inputRowMeta.indexOfValue(this.meta.getItemCustomFields()[i]);
                    if (this.data.customitems[i] >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"RssOutput.Exception.FieldRequired", (String[])new String[]{this.meta.getItemCustomFields()[i]}));
                }
                this.data.document = DocumentHelper.createDocument();
                this.data.rssElement = this.data.document.addElement("rss");
                this.data.rssElement.addAttribute("version", "2.0");
                for (i = 0; i < this.meta.getNameSpaces().length; ++i) {
                    this.data.rssElement.addNamespace(this.environmentSubstitute(this.meta.getNameSpacesTitle()[i]), this.environmentSubstitute(this.meta.getNameSpaces()[i]));
                }
                this.data.channel = this.data.rssElement.addElement("channel");
                for (i = 0; i < this.data.customchannels.length; ++i) {
                    String channelname = this.environmentSubstitute(this.meta.getChannelCustomTags()[i]);
                    String channelvalue = this.data.inputRowMeta.getString(r, this.data.customchannels[i]);
                    if (this.log.isDetailed()) {
                        this.logDetailed("outputting channel value <" + channelname + ">" + channelvalue + "<" + channelname + "/>");
                    }
                    Element channeltag = this.data.channel.addElement(channelname);
                    channeltag.setText(channelvalue);
                }
            }
        }
        if (!this.meta.isCustomRss()) {
            String itemtitlevalue = null;
            String itemauthorvalue = null;
            String itemlinkvalue = null;
            Date itemdatevalue = null;
            String itemdescvalue = null;
            String itemgeopointx = null;
            String itemgeopointy = null;
            if (this.data.indexOfFielditemtitle > -1) {
                itemtitlevalue = this.data.inputRowMeta.getString(r, this.data.indexOfFielditemtitle);
            }
            if (this.data.indexOfFielditemauthor > -1) {
                itemauthorvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFielditemauthor);
            }
            if (this.data.indexOfFielditemlink > -1) {
                itemlinkvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFielditemlink);
            }
            if (this.data.indexOfFielditempubdate > -1) {
                itemdatevalue = this.data.inputRowMeta.getDate(r, this.data.indexOfFielditempubdate);
            }
            if (this.data.indexOfFielditemdescription > -1) {
                itemdescvalue = this.data.inputRowMeta.getString(r, this.data.indexOfFielditemdescription);
            }
            if (this.data.indexOfFielditempointx > -1) {
                itemgeopointx = this.data.inputRowMeta.getString(r, this.data.indexOfFielditempointx);
            }
            if (this.data.indexOfFielditempointy > -1) {
                itemgeopointy = this.data.inputRowMeta.getString(r, this.data.indexOfFielditempointy);
            }
            if (!this.createEntry(itemauthorvalue, itemtitlevalue, itemlinkvalue, itemdatevalue, itemdescvalue, itemgeopointx, itemgeopointy)) {
                throw new KettleException("Error adding item to feed");
            }
        } else {
            if (this.meta.isDisplayItem()) {
                this.data.itemtag = this.data.channel.addElement("item");
            }
            for (int i = 0; i < this.data.customitems.length; ++i) {
                String itemname = this.environmentSubstitute(this.meta.getItemCustomTags()[i]);
                String itemvalue = this.data.inputRowMeta.getString(r, this.data.customitems[i]);
                if (this.log.isDetailed()) {
                    this.logDetailed("outputting item value <" + itemname + ">" + itemvalue + "<" + itemname + "/>");
                }
                if (this.meta.isDisplayItem()) {
                    Element itemtagsub = this.data.itemtag.addElement(itemname);
                    itemtagsub.setText(itemvalue);
                    continue;
                }
                Element temp = this.data.channel.addElement(itemname);
                temp.setText(itemvalue);
            }
        }
        try {
            this.putRow(this.data.outputRowMeta, r);
            this.incrementLinesOutput();
            if (this.checkFeedback(this.getLinesOutput()) && this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"RssOutput.Log.Linenr", (String[])new String[]{"" + this.getLinesOutput()}));
            }
        }
        catch (KettleStepException e) {
            this.logError(BaseMessages.getString(PKG, (String)"RssOutputMeta.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public String buildFilename() throws KettleStepException {
        return this.meta.buildFilename(this, this.getCopy());
    }

    public boolean createEntry(String author, String title, String link, Date date, String desc, String geopointLat, String geopointLong) {
        boolean retval = false;
        try {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry = new SyndEntryImpl();
            if (title != null) {
                entry.setTitle(title);
            }
            if (link != null) {
                entry.setLink(link);
            }
            if (date != null) {
                entry.setPublishedDate(date);
            }
            if (author != null) {
                entry.setAuthor(author);
            }
            if (desc != null) {
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(desc);
                entry.setDescription((SyndContent)description);
            }
            if (this.meta.AddGeoRSS() && geopointLat != null && geopointLong != null) {
                SimpleModuleImpl geoRSSModule = new SimpleModuleImpl();
                if (this.meta.useGeoRSSGML()) {
                    geoRSSModule = new W3CGeoModuleImpl();
                }
                geoRSSModule.setPosition(new Position(Const.toDouble((String)geopointLat.replace(',', '.'), (double)0.0), Const.toDouble((String)geopointLong.replace(',', '.'), (double)0.0)));
                entry.getModules().add(geoRSSModule);
            }
            this.data.entries.add((SyndEntry)entry);
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorAddingEntry", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    private boolean WriteToFile(String title, String link, String description, Date Pubdate, String copyright, String imageTitle, String imageDescription, String imageLink, String imageUrl, String language, String author) {
        boolean retval = false;
        try {
            String fileName = this.data.filename;
            this.data.feed = new SyndFeedImpl();
            if (Utils.isEmpty((CharSequence)this.meta.getVersion())) {
                this.data.feed.setFeedType("rss_2.0");
            } else {
                this.data.feed.setFeedType(this.meta.getVersion());
            }
            if (Utils.isEmpty((CharSequence)this.meta.getEncoding())) {
                this.data.feed.setEncoding("iso-8859-1");
            } else {
                this.data.feed.setEncoding(this.meta.getEncoding());
            }
            if (title != null) {
                this.data.feed.setTitle(title);
            }
            if (link != null) {
                this.data.feed.setLink(link);
            }
            if (description != null) {
                this.data.feed.setDescription(description);
            }
            if (Pubdate != null) {
                this.data.feed.setPublishedDate(Pubdate);
            }
            if (this.meta.AddImage()) {
                SyndImageImpl image = new SyndImageImpl();
                if (imageTitle != null) {
                    image.setTitle(title);
                }
                if (imageLink != null) {
                    image.setLink(link);
                }
                if (imageUrl != null) {
                    image.setUrl(imageUrl);
                }
                if (imageDescription != null) {
                    image.setDescription(imageDescription);
                }
                this.data.feed.setImage((SyndImage)image);
            }
            if (language != null) {
                this.data.feed.setLanguage(language);
            }
            if (copyright != null) {
                this.data.feed.setCopyright(copyright);
            }
            if (author != null) {
                this.data.feed.setAuthor(author);
            }
            this.data.feed.setEntries(this.data.entries);
            FileWriter writer = new FileWriter(fileName);
            SyndFeedOutput output = new SyndFeedOutput();
            output.output(this.data.feed, (Writer)writer);
            ((Writer)writer).close();
            if (this.meta.AddToResult()) {
                ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileName, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment("This file was created with a RSS Output step");
                this.addResultFile(resultFile);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RssOutput.Log.CreatingFileOK", (String[])new String[]{fileName}));
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"RssOutput.Log.ErrorCreatingFile", (String[])new String[]{e.toString()}));
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssOutputMeta)smi;
        this.data = (RssOutputData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssOutputMeta)smi;
        this.data = (RssOutputData)sdi;
        if (this.data.document != null) {
            this.data.document = null;
        }
        if (this.data.rssElement != null) {
            this.data.rssElement = null;
        }
        if (this.data.channel != null) {
            this.data.channel = null;
        }
        this.setOutputDone();
        super.dispose(smi, sdi);
    }
}

