/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.named.cluster;

import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.NamedClusterOsgi;
import org.pentaho.di.core.osgi.api.NamedClusterServiceOsgi;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterEmbedManager {
    public static final String NAMESPACE = "NamedClusters";
    private static final String URL_PATTERN = "(^[^:/?#]+):?//([^/?#]*)?([^?#]*)";
    private static final String VARIABLE_START = "${";
    private static final int PARSE_URL_SCHEME = 1;
    private static final int PARSE_URL_AUTHORITY = 2;
    private static final int PARSE_URL_PATH = 3;
    protected static MetaStoreFactory testMetaStoreFactory;
    private MetaStoreFactory<NamedClusterOsgi> embeddedMetaStoreFactory;
    private AbstractMeta meta;
    private LogChannelInterface log;
    private boolean addedAllClusters;
    private boolean addedAnyClusters;
    private HashMap<String, NamedClusterOsgi> namedClusterPool = new HashMap();

    public NamedClusterEmbedManager(AbstractMeta meta, LogChannelInterface log) {
        this.meta = meta;
        this.log = log;
        NamedClusterServiceOsgi ncso = meta.getNamedClusterServiceOsgi();
        if (ncso == null) {
            this.embeddedMetaStoreFactory = null;
            return;
        }
        this.embeddedMetaStoreFactory = testMetaStoreFactory == null ? new MetaStoreFactory(ncso.getClusterTemplate().getClass(), (IMetaStore)meta.getEmbeddedMetaStore(), NAMESPACE) : testMetaStoreFactory;
    }

    public void registerUrl(String urlString) {
        Pattern r;
        Matcher m;
        if (urlString == null || this.addedAllClusters) {
            return;
        }
        if (urlString.startsWith(VARIABLE_START)) {
            this.addAllClusters();
        }
        if ((m = (r = Pattern.compile(URL_PATTERN)).matcher(urlString)).find()) {
            String protocol = m.group(1);
            String clusterName = m.group(2);
            if ("hc".equals(protocol)) {
                if (clusterName.startsWith(VARIABLE_START)) {
                    this.addAllClusters();
                }
                this.addClusterToMeta(clusterName);
            }
        }
    }

    public void clear() {
        NamedClusterServiceOsgi ncso = this.meta.getNamedClusterServiceOsgi();
        if (ncso != null) {
            this.addedAllClusters = false;
            this.addedAnyClusters = false;
            if (this.embeddedMetaStoreFactory != null) {
                try {
                    List list = this.embeddedMetaStoreFactory.getElements();
                    for (NamedClusterOsgi nc : list) {
                        this.namedClusterPool.put(nc.getName(), nc);
                        this.embeddedMetaStoreFactory.deleteElement(nc.getName());
                    }
                }
                catch (MetaStoreException e) {
                    this.logMetaStoreException(e);
                }
            }
        }
    }

    public boolean isAddedAnyClusters() {
        return this.addedAnyClusters;
    }

    public void addClusterToMeta(String clusterName) {
        NamedClusterServiceOsgi ncso = this.meta.getNamedClusterServiceOsgi();
        if (ncso != null) {
            NamedClusterOsgi nc = ncso.getNamedClusterByName(clusterName, this.meta.getMetaStore());
            if (nc == null) {
                nc = this.namedClusterPool.get(clusterName);
            }
            if (nc != null) {
                this.addClusterToMeta(nc);
            }
        }
    }

    private void addClusterToMeta(NamedClusterOsgi nc) {
        try {
            if (this.embeddedMetaStoreFactory.loadElement(nc.getName()) == null) {
                this.embeddedMetaStoreFactory.saveElement((Object)nc);
                this.addedAnyClusters = true;
            }
        }
        catch (MetaStoreException e) {
            this.logMetaStoreException(e);
        }
    }

    private void addAllClusters() {
        NamedClusterServiceOsgi ncso = this.meta.getNamedClusterServiceOsgi();
        if (ncso != null && this.meta.getMetaStore() != null) {
            try {
                List list = ncso.listNames(this.meta.getMetaStore());
                for (String name : list) {
                    this.addClusterToMeta(name);
                }
                for (NamedClusterOsgi nc : this.namedClusterPool.values()) {
                    if (list.contains(nc.getName())) continue;
                    this.addClusterToMeta(nc);
                }
                this.addedAllClusters = true;
            }
            catch (MetaStoreException e) {
                this.logMetaStoreException(e);
            }
        }
    }

    private void logMetaStoreException(MetaStoreException e) {
        if (this.log.isError()) {
            this.log.logError("Could not embed NamedCluster Information in ktr/kjb", (Throwable)e);
        }
    }

    public void passEmbeddedMetastoreKey(VariableSpace nameSpace, String embeddedMetastoreProviderKey) {
        if (nameSpace != null && embeddedMetastoreProviderKey != null) {
            nameSpace.setVariable("vfs.hc.embeddedMetastoreKey", embeddedMetastoreProviderKey);
        }
    }
}

