/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput.text;

import java.util.Date;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.playlist.FilePlayListAll;
import org.pentaho.di.core.playlist.FilePlayListReplay;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.file.BaseFileInputStep;
import org.pentaho.di.trans.steps.file.IBaseFileInputReader;
import org.pentaho.di.trans.steps.fileinput.text.TextFileFilterProcessor;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputData;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputMeta;
import org.pentaho.di.trans.steps.fileinput.text.TextFileInputReader;

public class TextFileInput
extends BaseFileInputStep<TextFileInputMeta, TextFileInputData>
implements StepInterface {
    private static Class<?> PKG = TextFileInputMeta.class;

    public TextFileInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    protected IBaseFileInputReader createReader(TextFileInputMeta meta, TextFileInputData data, FileObject file) throws Exception {
        return new TextFileInputReader(this, meta, data, file, this.log);
    }

    @Override
    public boolean init() {
        Date replayDate = this.getTrans().getReplayDate();
        ((TextFileInputData)this.data).filePlayList = replayDate == null ? FilePlayListAll.INSTANCE : new FilePlayListReplay(replayDate, ((TextFileInputMeta)this.meta).errorHandling.lineNumberFilesDestinationDirectory, ((TextFileInputMeta)this.meta).errorHandling.lineNumberFilesExtension, ((TextFileInputMeta)this.meta).errorHandling.errorFilesDestinationDirectory, ((TextFileInputMeta)this.meta).errorHandling.errorFilesExtension, ((TextFileInputMeta)this.meta).content.encoding);
        ((TextFileInputData)this.data).filterProcessor = new TextFileFilterProcessor(((TextFileInputMeta)this.meta).getFilter(), this);
        ((TextFileInputData)this.data).fileFormatType = ((TextFileInputMeta)this.meta).getFileFormatTypeNr();
        ((TextFileInputData)this.data).fileType = ((TextFileInputMeta)this.meta).getFileTypeNr();
        ((TextFileInputData)this.data).separator = this.environmentSubstitute(((TextFileInputMeta)this.meta).content.separator);
        ((TextFileInputData)this.data).enclosure = this.environmentSubstitute(((TextFileInputMeta)this.meta).content.enclosure);
        ((TextFileInputData)this.data).escapeCharacter = this.environmentSubstitute(((TextFileInputMeta)this.meta).content.escapeCharacter);
        if (((TextFileInputMeta)this.meta).content.fileType.equalsIgnoreCase("CSV") && (((TextFileInputMeta)this.meta).content.separator == null || ((TextFileInputMeta)this.meta).content.separator.isEmpty())) {
            this.logError(BaseMessages.getString(PKG, (String)"TextFileInput.Exception.NoSeparator", (String[])new String[0]));
            return false;
        }
        return true;
    }

    public boolean isWaitingForData() {
        return true;
    }
}

