/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.ods;

import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.pentaho.di.core.spreadsheet.KCell;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.trans.steps.excelinput.ods.OdfCell;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdfSheet
implements KSheet {
    private OdfTable table;
    private int nrOfRows;
    private int roughNrOfCols;

    public OdfSheet(OdfTable table) {
        this.table = table;
        this.nrOfRows = this.findNrRows();
        this.roughNrOfCols = table.getColumnCount();
    }

    protected int findNrRows() {
        int rowCount = this.table.getRowCount();
        NodeList nodes = this.table.getOdfElement().getChildNodes();
        int nodesLen = nodes.getLength();
        for (int i = nodesLen - 1; i >= 0; --i) {
            Node node = nodes.item(i);
            if (!(node instanceof TableTableRowElement)) continue;
            TableTableRowElement rowElement = (TableTableRowElement)node;
            if (!this.isRowEmpty(rowElement)) break;
            rowCount -= rowElement.getTableNumberRowsRepeatedAttribute().intValue();
        }
        return rowCount;
    }

    protected boolean isRowEmpty(TableTableRowElement rowElem) {
        NodeList cells = rowElem.getChildNodes();
        int cellsLen = cells.getLength();
        for (int j = 0; j < cellsLen; ++j) {
            Node cell = cells.item(j);
            if (!(cell instanceof TableTableCellElement) || !cell.hasChildNodes()) continue;
            return false;
        }
        return true;
    }

    protected int findNrColumns(OdfTableRow row) {
        NodeList cells;
        int result = this.roughNrOfCols;
        if (row != null && (cells = row.getOdfElement().getChildNodes()) != null && cells.getLength() > 0) {
            int cellLen = cells.getLength();
            for (int i = cellLen - 1; i >= 0; --i) {
                Node cell = cells.item(i);
                if (!(cell instanceof TableTableCellElement)) continue;
                if (cell.hasChildNodes()) break;
                result -= ((TableTableCellElement)cell).getTableNumberColumnsRepeatedAttribute().intValue();
            }
        }
        return result;
    }

    public String getName() {
        return this.table.getTableName();
    }

    public KCell[] getRow(int rownr) {
        if (rownr >= this.nrOfRows) {
            throw new ArrayIndexOutOfBoundsException("Read beyond last row: " + rownr);
        }
        OdfTableRow row = this.table.getRowByIndex(rownr);
        int cols = this.findNrColumns(row);
        KCell[] xlsCells = new OdfCell[cols];
        for (int i = 0; i < cols; ++i) {
            OdfTableCell cell = row.getCellByIndex(i);
            if (cell == null) continue;
            xlsCells[i] = new OdfCell(cell);
        }
        return xlsCells;
    }

    public int getRows() {
        return this.nrOfRows;
    }

    public KCell getCell(int colnr, int rownr) {
        OdfTableCell cell = this.table.getCellByPosition(colnr, rownr);
        if (cell == null) {
            return null;
        }
        return new OdfCell(cell);
    }
}

