/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.syslog;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.TimeZone;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.syslog.JobEntrySyslog;
import org.pentaho.di.job.entries.syslog.SyslogException;
import org.productivity.java.syslog4j.SyslogIF;

public class SyslogDefs {
    private static Class<?> PKG = JobEntrySyslog.class;
    public static final String DEFAULT_PROTOCOL_UDP = "udp";
    public static final int DEFAULT_PORT = 514;
    public static final String DEFAULT_DATE_FORMAT = "MMM dd HH:mm:ss";
    private static Hashtable<String, Integer> facHash;
    private static Hashtable<String, Integer> priHash;
    public static final String[] FACILITYS;
    public static final String[] PRIORITYS;

    public static int computeCode(int facility, int priority) {
        return facility << 3 | priority;
    }

    public static int getPriority(String priority) throws SyslogException {
        Integer result = priHash.get(priority);
        if (result == null) {
            throw new SyslogException(BaseMessages.getString(PKG, (String)"JobEntrySyslog.UnknownPriotity", (String[])new String[]{priority}));
        }
        return result;
    }

    public static int getFacility(String facility) throws SyslogException {
        Integer result = facHash.get(facility);
        if (result == null) {
            throw new SyslogException(BaseMessages.getString(PKG, (String)"JobEntrySyslog.UnknownFacility", (String[])new String[]{facility}));
        }
        return result;
    }

    public static void sendMessage(SyslogIF syslog, int priority, String message, boolean addTimestamp, String pattern, boolean addHostName) {
        String messageString = message;
        if (addHostName) {
            messageString = Const.getHostname() + " " + messageString;
        }
        if (addTimestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            dateFormat.setTimeZone(TimeZone.getDefault());
            messageString = dateFormat.format(Calendar.getInstance().getTime()) + " : " + messageString;
        }
        switch (priority) {
            case 0: {
                syslog.emergency(messageString);
                break;
            }
            case 1: {
                syslog.alert(messageString);
                break;
            }
            case 2: {
                syslog.critical(messageString);
                break;
            }
            case 3: {
                syslog.error(messageString);
                break;
            }
            case 4: {
                syslog.warn(messageString);
                break;
            }
            case 5: {
                syslog.notice(messageString);
                break;
            }
            case 6: {
                syslog.info(messageString);
                break;
            }
            case 7: {
                syslog.debug(messageString);
                break;
            }
        }
    }

    static {
        FACILITYS = new String[]{"KERNEL", "USER", "MAIL", "DAEMON", "AUTH", "SYSLOG", "LPR", "NEWS", "UUCP", "CRON", "LOCAL0", "LOCAL1", "LOCAL2", "LOCAL3", "LOCAL4", "LOCAL5", "LOCAL6", "LOCAL7"};
        PRIORITYS = new String[]{"EMERGENCY", "ALERT", "CRITICAL", "ERROR", "WARNING", "NOTICE", "INFO", "DEBUG"};
        facHash = new Hashtable(18);
        facHash.put("KERNEL", 0);
        facHash.put("USER", 8);
        facHash.put("MAIL", 16);
        facHash.put("DAEMON", 24);
        facHash.put("AUTH", 32);
        facHash.put("SYSLOG", 40);
        facHash.put("LPR", 48);
        facHash.put("NEWS", 56);
        facHash.put("UUCP", 64);
        facHash.put("CRON", 72);
        facHash.put("LOCAL0", 128);
        facHash.put("LOCAL1", 136);
        facHash.put("LOCAL2", 144);
        facHash.put("LOCAL3", 152);
        facHash.put("LOCAL4", 160);
        facHash.put("LOCAL5", 168);
        facHash.put("LOCAL6", 176);
        facHash.put("LOCAL7", 184);
        priHash = new Hashtable(8);
        priHash.put("EMERGENCY", 0);
        priHash.put("ALERT", 1);
        priHash.put("CRITICAL", 2);
        priHash.put("ERROR", 3);
        priHash.put("WARNING", 4);
        priHash.put("NOTICE", 5);
        priHash.put("INFO", 6);
        priHash.put("DEBUG", 7);
    }
}

