/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util.serialization;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.di.core.util.serialization.StepMetaProps;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetaXmlSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String serialize(StepMetaProps stepMetaProps) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Marshaller marshalObj = JAXBContext.newInstance((Class[])new Class[]{StepMetaProps.class}).createMarshaller();
            marshalObj.setProperty("jaxb.formatted.output", (Object)true);
            marshalObj.setProperty("jaxb.fragment", (Object)true);
            marshalObj.marshal((Object)stepMetaProps, (OutputStream)baos);
            String string = baos.toString(Charset.defaultCharset().name());
            return string;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StepMetaProps deserialize(String ser) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(ser.getBytes(Charset.defaultCharset()));){
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{StepMetaProps.class}).createUnmarshaller();
            StepMetaProps stepMetaProps = (StepMetaProps)unmarshaller.unmarshal((InputStream)bais);
            return stepMetaProps;
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static StepMetaProps deserialize(Node node) {
        return MetaXmlSerializer.deserialize(MetaXmlSerializer.nodeToString(XMLHandler.getSubNode((Node)node, (String)"step-props")));
    }

    private static String nodeToString(Node node) {
        Preconditions.checkArgument((boolean)(node instanceof Element));
        StringWriter sw = new StringWriter();
        try {
            ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        return sw.toString();
    }
}

