/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.converter;

import java.util.ArrayList;
import org.jfor.jfor.converter.BuilderContext;
import org.jfor.jfor.converter.FoUnitsConverter;
import org.jfor.jfor.converter.ValueConversionException;
import org.jfor.jfor.interfaces.ITableColumnsInfo;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;

class TableContext
implements ITableColumnsInfo {
    private final BuilderContext m_context;
    private final ArrayList m_colWidths = new ArrayList();
    private int m_colIndex;
    private final ArrayList m_colRowSpanningNumber = new ArrayList();
    private final ArrayList m_colRowSpanningAttrs = new ArrayList();

    TableContext(BuilderContext builderContext) {
        this.m_context = builderContext;
    }

    void setNextColumnWidth(String string) throws ValueConversionException {
        this.m_colWidths.add(new Float(FoUnitsConverter.getInstance().convertToTwips(string)));
    }

    RtfAttributes getColumnRowSpanningAttrs() {
        return (RtfAttributes)this.m_colRowSpanningAttrs.get(this.m_colIndex);
    }

    Integer getColumnRowSpanningNumber() {
        return (Integer)this.m_colRowSpanningNumber.get(this.m_colIndex);
    }

    void setCurrentColumnRowSpanning(Integer n, RtfAttributes rtfAttributes) throws ValueConversionException {
        if (this.m_colIndex < this.m_colRowSpanningNumber.size()) {
            this.m_colRowSpanningNumber.set(this.m_colIndex, n);
            this.m_colRowSpanningAttrs.set(this.m_colIndex, rtfAttributes);
        } else {
            this.m_colRowSpanningNumber.add(n);
            this.m_colRowSpanningAttrs.add(this.m_colIndex, rtfAttributes);
        }
    }

    public void setNextColumnRowSpanning(Integer n, RtfAttributes rtfAttributes) {
        this.m_colRowSpanningNumber.add(n);
        this.m_colRowSpanningAttrs.add(this.m_colIndex, rtfAttributes);
    }

    public void decreaseRowSpannings() {
        int n = 0;
        while (n < this.m_colRowSpanningNumber.size()) {
            Integer n2 = (Integer)this.m_colRowSpanningNumber.get(n);
            if (n2 > 0) {
                n2 = new Integer(n2 - 1);
            }
            this.m_colRowSpanningNumber.set(n, n2);
            if (n2 == 0) {
                this.m_colRowSpanningAttrs.set(n, null);
            }
            ++n;
        }
    }

    public void selectFirstColumn() {
        this.m_colIndex = 0;
    }

    public void selectNextColumn() {
        ++this.m_colIndex;
    }

    public float getColumnWidth() {
        try {
            return ((Float)this.m_colWidths.get(this.m_colIndex)).floatValue();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.m_context.log.logWarning("fo:table-column width not defined,using 200.0");
            return 200.0f;
        }
    }

    public int getColumnIndex() {
        return this.m_colIndex;
    }

    public int getNumberOfColumns() {
        return this.m_colWidths.size();
    }
}

