/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.BatikUserAgent;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;

public abstract class SvgFontProcessor {
    public static final String SVG_ELEMENT_svg = "svg";
    public static final String SVG_ELEMENT_g = "g";
    public static final String SVG_ELEMENT_text = "text";
    public static final String SVG_ATTRIBUTE_style = "style";
    public static final String SVG_ATTRIBUTE_fontFamily = "font-family";
    private final SVGDocumentFactory documentFactory;
    private final Locale locale;

    protected SvgFontProcessor(JasperReportsContext jasperReportsContext, Locale locale) {
        BatikUserAgent userAgent = new BatikUserAgent(jasperReportsContext);
        this.documentFactory = new SAXSVGDocumentFactory(userAgent.getXMLParserClassName(), true);
        this.documentFactory.setValidating(userAgent.isXMLParserValidating());
        this.locale = locale;
    }

    public byte[] process(byte[] svgData) {
        try {
            SVGDocument document = this.documentFactory.createSVGDocument(null, (InputStream)new ByteArrayInputStream(svgData));
            this.process((Node)document);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource((Node)document);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            transformer.transform(source, result);
            return baos.toByteArray();
        }
        catch (IOException | TransformerException e) {
            throw new JRRuntimeException(e);
        }
    }

    private void process(Node element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType()) continue;
            if (SVG_ELEMENT_svg.equals(child.getNodeName()) || SVG_ELEMENT_g.equals(child.getNodeName()) || SVG_ELEMENT_text.equals(child.getNodeName())) {
                this.processFontAttributes((Element)child);
            }
            this.process(child);
        }
    }

    private void processFontAttributes(Element styleElement) {
        String styleFontFamily;
        Node styleAttrNode;
        String fontFamilyAttrValue = null;
        NamedNodeMap attributes = styleElement.getAttributes();
        Node fontFamilyAttrNode = attributes.getNamedItem(SVG_ATTRIBUTE_fontFamily);
        if (fontFamilyAttrNode != null) {
            fontFamilyAttrValue = fontFamilyAttrNode.getNodeValue();
        }
        if ((styleAttrNode = attributes.getNamedItem(SVG_ATTRIBUTE_style)) != null && (styleFontFamily = this.getFontFamily(styleAttrNode.getNodeValue())) != null) {
            fontFamilyAttrValue = styleFontFamily;
        }
        if (fontFamilyAttrValue != null) {
            String[] fontFamilyTokens;
            StringBuilder newFamilyNameAttrValue = new StringBuilder();
            boolean firstToken = true;
            for (String fontFamilyToken : fontFamilyTokens = fontFamilyAttrValue.split(",")) {
                int localeSeparatorPos;
                String fontFamily;
                if (!firstToken) {
                    newFamilyNameAttrValue.append(",");
                }
                if ((fontFamily = fontFamilyToken.trim()).startsWith("'") && fontFamily.endsWith("'")) {
                    fontFamily = fontFamily.substring(1, fontFamily.length() - 1);
                }
                if ((localeSeparatorPos = fontFamily.lastIndexOf("_-")) > 0) {
                    fontFamily = fontFamily.substring(0, localeSeparatorPos);
                }
                fontFamily = this.getFontFamily(fontFamily, this.locale);
                newFamilyNameAttrValue.append(" " + fontFamily);
                firstToken = false;
            }
            if (styleAttrNode == null) {
                styleElement.setAttribute(SVG_ATTRIBUTE_fontFamily, newFamilyNameAttrValue.toString());
            } else {
                String newStyleAttr = this.replaceOrAddFontFamilyInStyle(styleAttrNode.getNodeValue(), newFamilyNameAttrValue.toString());
                styleElement.setAttribute(SVG_ATTRIBUTE_style, newStyleAttr);
            }
        }
    }

    private String getFontFamily(String style) {
        String fontFamily = null;
        int fontFamilyStart = style.indexOf("font-family:");
        if (fontFamilyStart >= 0) {
            int fontFamilyEnd = style.indexOf(";", fontFamilyStart = fontFamilyStart + SVG_ATTRIBUTE_fontFamily.length() + 1);
            fontFamily = fontFamilyEnd >= 0 ? style.substring(fontFamilyStart, fontFamilyEnd).trim() : style.substring(fontFamilyStart).trim();
        }
        return fontFamily;
    }

    private String replaceOrAddFontFamilyInStyle(String style, String fontFamily) {
        StringBuilder sb = new StringBuilder();
        int fontFamilyStart = style.indexOf("font-family:");
        if (fontFamilyStart >= 0) {
            fontFamilyStart = fontFamilyStart + SVG_ATTRIBUTE_fontFamily.length() + 1;
            sb.append(style.substring(0, fontFamilyStart));
            sb.append(fontFamily);
            int fontFamilyEnd = style.indexOf(";", fontFamilyStart);
            if (fontFamilyEnd >= 0) {
                sb.append(style.substring(fontFamilyEnd));
            }
        } else {
            sb.append(style);
            if (!style.trim().endsWith(";")) {
                sb.append(";");
            }
            sb.append("font-family: " + fontFamily + ";");
        }
        return sb.toString();
    }

    public abstract String getFontFamily(String var1, Locale var2);
}

