/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.WrappingDataToGraphics2DRenderer;

public class WrappingDeprecatedRenderable
implements Renderable {
    private static final long serialVersionUID = 10200L;
    private final String id;
    private final Graphics2DRenderable grxRenderable;
    private final DataRenderable dataRenderable;
    private final DimensionRenderable dimensionRenderable;
    private ImageTypeEnum imageType = null;

    public WrappingDeprecatedRenderable(String id, Graphics2DRenderable grxRenderable, DataRenderable dataRenderable, DimensionRenderable dimensionRenderable) {
        this.id = id;
        this.grxRenderable = grxRenderable;
        this.dataRenderable = dataRenderable;
        this.dimensionRenderable = dimensionRenderable;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public byte getType() {
        return this.getTypeValue().getValue();
    }

    @Override
    public byte getImageType() {
        return this.getImageTypeValue().getValue();
    }

    @Override
    public Dimension2D getDimension() throws JRException {
        return this.getDimension(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public byte[] getImageData() throws JRException {
        return this.getImageData(DefaultJasperReportsContext.getInstance());
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    @Override
    public RenderableTypeEnum getTypeValue() {
        if (this.grxRenderable instanceof WrappingDataToGraphics2DRenderer) {
            return ((WrappingDataToGraphics2DRenderer)this.grxRenderable).getRenderableType();
        }
        return RenderableTypeEnum.SVG;
    }

    @Override
    public ImageTypeEnum getImageTypeValue() {
        if (this.imageType == null) {
            try {
                return JRTypeSniffer.getImageTypeValue(this.getImageData());
            }
            catch (JRException e) {
                return ImageTypeEnum.UNKNOWN;
            }
        }
        return this.imageType;
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        return this.dimensionRenderable == null ? null : this.dimensionRenderable.getDimension(jasperReportsContext);
    }

    @Override
    public byte[] getImageData(JasperReportsContext jasperReportsContext) throws JRException {
        byte[] imageData = this.dataRenderable.getData(jasperReportsContext);
        this.imageType = JRTypeSniffer.getImageTypeValue(imageData);
        return imageData;
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.grxRenderable.render(jasperReportsContext, grx, rectangle);
    }
}

