/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.LocalVirtualizationSerializer;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class JRAbstractLRUVirtualizer
implements JRVirtualizer {
    private static final Log log = LogFactory.getLog(JRAbstractLRUVirtualizer.class);
    protected final VirtualizationSerializer serializer;
    protected final Cache pagedIn;
    protected final ReferenceMap<String, Object> pagedOut;
    protected volatile WeakReference<JRVirtualizable> lastObjectRef;
    protected ReferenceMap<JRVirtualizationContext, Object> lastObjectMap;
    protected ReferenceMap<Object, Boolean> lastObjectSet;
    private boolean readOnly;

    protected JRAbstractLRUVirtualizer(int maxSize) {
        this(new LocalVirtualizationSerializer(), maxSize);
    }

    protected JRAbstractLRUVirtualizer(VirtualizationSerializer serializer, int maxSize) {
        this.serializer = serializer;
        this.pagedIn = new Cache(maxSize);
        this.pagedOut = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);
        this.lastObjectRef = null;
        this.lastObjectMap = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.WEAK);
        this.lastObjectSet = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);
    }

    protected final synchronized boolean isPagedOut(String id) {
        return this.pagedOut.containsKey((Object)id);
    }

    protected synchronized boolean isPagedOutAndTouch(JRVirtualizable o, String uid) {
        boolean virtualized = this.isPagedOut(uid);
        if (!virtualized) {
            this.touch(o);
        }
        return virtualized;
    }

    protected JRVirtualizable lastObject() {
        WeakReference<JRVirtualizable> ref = this.lastObjectRef;
        JRVirtualizable object = ref == null ? null : (JRVirtualizable)ref.get();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLastObject(JRVirtualizable o) {
        JRVirtualizable currentLast = this.lastObject();
        if (o != null && currentLast != o) {
            this.lastObjectRef = new WeakReference<JRVirtualizable>(o);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                JRVirtualizationContext context = o.getContext();
                Object ownerLast = this.lastObjectMap.get((Object)context);
                if (ownerLast != o) {
                    if (ownerLast != null) {
                        this.lastObjectSet.remove(ownerLast);
                    }
                    this.lastObjectMap.put((Object)context, (Object)o);
                    this.lastObjectSet.put((Object)o, (Object)Boolean.TRUE);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextChanged(JRVirtualizable<?> o, JRVirtualizationContext oldContext) {
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            Object oldContextLast = this.lastObjectMap.get((Object)oldContext);
            if (oldContextLast == o) {
                this.lastObjectMap.remove((Object)oldContext);
                this.lastObjectSet.remove(o);
            }
        }
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected final boolean isReadOnly(JRVirtualizable o) {
        return this.readOnly || o.getContext().isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(JRVirtualizable o) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering " + o.getUID() + " with context " + o.getContext()));
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            this.setLastObject(o);
            JRVirtualizable old = this.pagedIn.put(o.getUID(), o);
            if (old != null && old != o) {
                this.pagedIn.put(o.getUID(), old);
                throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registered object " + o + " with id " + o.getUID()));
        }
        this.evict();
    }

    protected boolean isEvictable(JRVirtualizable value) {
        return value.getContext().isDisposed() || !this.lastObjectSet.containsKey((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        List<JRVirtualizable> candidates;
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            candidates = this.pagedIn.evictionCandidates();
        }
        for (JRVirtualizable o : candidates) {
            String uid = o.getUID();
            if (o.getContext().tryLock()) {
                try {
                    boolean evictable;
                    JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer2 = this;
                    synchronized (jRAbstractLRUVirtualizer2) {
                        boolean bl = evictable = this.pagedIn.contains(uid) && this.isEvictable(o);
                        if (evictable) {
                            this.pagedIn.remove(uid);
                        }
                    }
                    if (evictable) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("evicting " + uid));
                        }
                        if (o.getContext().isDisposed()) continue;
                        this.virtualizeData(o);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("no longer evictable: " + uid));
                    continue;
                }
                finally {
                    o.getContext().unlock();
                    continue;
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("couldn't lock for eviction " + uid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterObject(JRVirtualizable o) {
        String uid = o.getUID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("deregistering " + uid));
        }
        try {
            this.dispose(o);
        }
        catch (Exception e) {
            log.error((Object)"Error removing virtual data", (Throwable)e);
        }
        JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
        synchronized (jRAbstractLRUVirtualizer) {
            JRVirtualizable oldIn = this.pagedIn.remove(uid);
            if (oldIn != null) {
                if (oldIn != o) {
                    this.pagedIn.put(uid, oldIn);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
                }
                Object contextLast = this.lastObjectMap.get((Object)o.getContext());
                if (contextLast == o) {
                    this.lastObjectMap.remove((Object)o.getContext());
                    this.lastObjectSet.remove((Object)o);
                }
            } else {
                Object oldOut = this.pagedOut.remove((Object)uid);
                if (oldOut != null && oldOut != o) {
                    this.pagedOut.put((Object)uid, oldOut);
                    throw new IllegalStateException("Wrong object stored with UID \"" + o.getUID() + "\"");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("deregistered object " + o + " with id " + o.getUID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void touch(JRVirtualizable o) {
        if (this.lastObject() != o) {
            JRVirtualizable internalObject;
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                internalObject = this.pagedIn.get(o.getUID());
            }
            this.setLastObject(internalObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestData(JRVirtualizable o) {
        boolean evictRequired;
        block10: {
            String uid = o.getUID();
            evictRequired = false;
            o.getContext().lock();
            try {
                if (!this.isPagedOutAndTouch(o, uid)) break block10;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("internalizing " + uid));
                }
                try {
                    this.pageIn(o);
                }
                catch (IOException e) {
                    log.error((Object)"Error devirtualizing object", (Throwable)e);
                    throw new JRRuntimeException(e);
                }
                JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
                synchronized (jRAbstractLRUVirtualizer) {
                    this.setLastObject(o);
                    this.pagedOut.remove((Object)uid);
                    this.pagedIn.put(uid, o);
                }
                o.afterInternalization();
                evictRequired = true;
            }
            finally {
                o.getContext().unlock();
            }
        }
        if (evictRequired) {
            this.evict();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearData(JRVirtualizable o) {
        String uid = o.getUID();
        if (this.isPagedOutAndTouch(o, uid)) {
            this.dispose(uid);
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.remove((Object)uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void virtualizeData(JRVirtualizable o) {
        String uid = o.getUID();
        if (!this.isPagedOut(uid)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("externalizing " + uid));
            }
            o.beforeExternalization();
            try {
                this.pageOut(o);
            }
            catch (IOException e) {
                log.error((Object)"Error virtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
            o.afterExternalization();
            o.removeVirtualData();
            JRAbstractLRUVirtualizer jRAbstractLRUVirtualizer = this;
            synchronized (jRAbstractLRUVirtualizer) {
                this.pagedOut.put((Object)uid, (Object)o);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    protected final void writeData(JRVirtualizable o, OutputStream out) throws JRRuntimeException {
        try {
            this.serializer.writeData(o, out);
        }
        catch (IOException e) {
            log.error((Object)"Error virtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected final void readData(JRVirtualizable o, InputStream in) throws JRRuntimeException {
        try {
            this.serializer.readData(o, in);
        }
        catch (IOException e) {
            log.error((Object)"Error devirtualizing object", (Throwable)e);
            throw new JRRuntimeException(e);
        }
    }

    protected synchronized void reset() {
        this.readOnly = false;
    }

    protected final void disposeAll() {
        String id;
        Iterator<Object> it = this.pagedOut.keySet().iterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
        it = this.pagedIn.idIterator();
        while (it.hasNext()) {
            id = (String)it.next();
            try {
                this.dispose(id);
                it.remove();
            }
            catch (Exception e) {
                log.error((Object)"Error cleaning up virtualizer.", (Throwable)e);
            }
        }
    }

    protected abstract void pageOut(JRVirtualizable var1) throws IOException;

    protected abstract void pageIn(JRVirtualizable var1) throws IOException;

    protected void dispose(JRVirtualizable o) {
        this.dispose(o.getUID());
    }

    protected abstract void dispose(String var1);

    protected class Cache {
        private final int maxSize;
        private final ReferenceQueue<JRVirtualizable> refQueue;
        private final LinkedHashMap<String, CacheReference> map;

        Cache(int maxSize) {
            this.maxSize = maxSize;
            this.map = new LinkedHashMap(16, 0.75f, true);
            this.refQueue = new ReferenceQueue();
        }

        protected JRVirtualizable getMapValue(CacheReference val) {
            JRVirtualizable o = val == null ? null : (val.isEnqueued() ? null : (JRVirtualizable)val.get());
            return o;
        }

        protected CacheReference toMapValue(JRVirtualizable val) {
            return val == null ? null : new CacheReference(val, this.refQueue);
        }

        protected void purge() {
            CacheReference ref;
            while ((ref = (CacheReference)this.refQueue.poll()) != null) {
                this.map.remove(ref.getId());
            }
        }

        public boolean contains(String id) {
            this.purge();
            return this.map.containsKey(id);
        }

        public JRVirtualizable get(String id) {
            this.purge();
            return this.getMapValue(this.map.get(id));
        }

        public JRVirtualizable put(String id, JRVirtualizable o) {
            this.purge();
            return this.getMapValue(this.map.put(id, this.toMapValue(o)));
        }

        public List<JRVirtualizable> evictionCandidates() {
            if (this.map.size() <= this.maxSize) {
                return Collections.emptyList();
            }
            int candidateCount = this.map.size() - this.maxSize;
            ArrayList<JRVirtualizable> candidates = new ArrayList<JRVirtualizable>();
            Iterator<Map.Entry<String, CacheReference>> mapIterator = this.map.entrySet().iterator();
            while (candidates.size() < candidateCount && mapIterator.hasNext()) {
                Map.Entry<String, CacheReference> entry = mapIterator.next();
                JRVirtualizable value = this.getMapValue(entry.getValue());
                if (value == null) {
                    --candidateCount;
                    continue;
                }
                if (!JRAbstractLRUVirtualizer.this.isEvictable(value)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LRU eviction candidate: " + entry.getKey()));
                }
                candidates.add(value);
            }
            if (candidates.size() < candidateCount) {
                log.debug((Object)("The virtualizer is used by more contexts than its in-memory cache size " + this.maxSize));
            }
            return candidates;
        }

        public JRVirtualizable remove(String id) {
            this.purge();
            return this.getMapValue((CacheReference)this.map.remove(id));
        }

        public Iterator<String> idIterator() {
            this.purge();
            final Iterator<CacheReference> valsIt = this.map.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return valsIt.hasNext();
                }

                @Override
                public String next() {
                    CacheReference ref = (CacheReference)valsIt.next();
                    return ref.getId();
                }

                @Override
                public void remove() {
                    valsIt.remove();
                }
            };
        }
    }

    protected static class CacheReference
    extends WeakReference<JRVirtualizable> {
        private final String id;

        public CacheReference(JRVirtualizable o, ReferenceQueue<JRVirtualizable> queue) {
            super(o, queue);
            this.id = o.getUID();
        }

        public String getId() {
            return this.id;
        }
    }
}

