/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;

public final class JRHyperlinkHelper {
    public static final String EXCEPTION_MESSAGE_KEY_TARGET_BYTE_CONSTANT_USED = "engine.hyperlink.target.byte.constant.used";
    public static final String EXCEPTION_MESSAGE_KEY_TYPE_BYTE_CONSTANT_USED = "engine.hyperlink.type.byte.constant.used";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_HYPERLINK_TARGET = "engine.hyperlink.unknown.hyperlink.target";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_HYPERLINK_TYPE = "engine.hyperlink.unknown.hyperlink.type";

    public static HyperlinkTypeEnum getHyperlinkTypeValue(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTypeValue(hyperlink.getLinkType());
    }

    public static HyperlinkTypeEnum getHyperlinkTypeValue(String linkType) {
        HyperlinkTypeEnum builtinType;
        HyperlinkTypeEnum type = linkType == null ? HyperlinkTypeEnum.NONE : ((builtinType = HyperlinkTypeEnum.getByName(linkType)) == null ? HyperlinkTypeEnum.CUSTOM : builtinType);
        return type;
    }

    public static HyperlinkTargetEnum getHyperlinkTargetValue(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTargetValue(hyperlink.getLinkTarget());
    }

    public static byte getHyperlinkTarget(JRHyperlink hyperlink) {
        return JRHyperlinkHelper.getHyperlinkTargetValue(hyperlink.getLinkTarget()).getValue();
    }

    public static HyperlinkTargetEnum getHyperlinkTargetValue(String linkTarget) {
        HyperlinkTargetEnum builtinTarget;
        HyperlinkTargetEnum target = linkTarget == null ? HyperlinkTargetEnum.SELF : ((builtinTarget = HyperlinkTargetEnum.getByName(linkTarget)) == null ? HyperlinkTargetEnum.CUSTOM : builtinTarget);
        return target;
    }

    public static String getLinkType(HyperlinkTypeEnum hyperlinkType) {
        String type;
        switch (hyperlinkType) {
            case NULL: 
            case NONE: {
                type = null;
                break;
            }
            case REFERENCE: 
            case LOCAL_ANCHOR: 
            case LOCAL_PAGE: 
            case REMOTE_ANCHOR: 
            case REMOTE_PAGE: {
                type = hyperlinkType.getName();
                break;
            }
            case CUSTOM: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TYPE_BYTE_CONSTANT_USED, (Object[])null);
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_HYPERLINK_TYPE, hyperlinkType);
            }
        }
        return type;
    }

    public static String getLinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        String target;
        switch (hyperlinkTarget) {
            case NONE: 
            case SELF: {
                target = null;
                break;
            }
            case BLANK: {
                target = HyperlinkTargetEnum.BLANK.getName();
                break;
            }
            case PARENT: {
                target = HyperlinkTargetEnum.PARENT.getName();
                break;
            }
            case TOP: {
                target = HyperlinkTargetEnum.TOP.getName();
                break;
            }
            case CUSTOM: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TARGET_BYTE_CONSTANT_USED, (Object[])null);
            }
            default: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_HYPERLINK_TARGET, hyperlinkTarget);
            }
        }
        return target;
    }

    public static boolean isEmpty(JRHyperlink hyperlink) {
        return hyperlink == null || hyperlink.getHyperlinkTypeValue() == HyperlinkTypeEnum.NONE && hyperlink.getHyperlinkTooltipExpression() == null;
    }

    private JRHyperlinkHelper() {
    }
}

