/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.jdbc;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MapDeserializer
extends StdDeserializer<Map<String, String>> {
    private static final long serialVersionUID = 1L;

    public MapDeserializer() {
        this(null);
    }

    public MapDeserializer(Class<?> vc) {
        super(vc);
    }

    public Map<String, String> deserialize(JsonParser p, DeserializationContext ctxt, Map<String, String> intoValue) throws IOException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        intoValue.put(node.get("key").asText(), node.get("value").asText());
        return intoValue;
    }

    public Map<String, String> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return this.deserialize(p, ctxt, new HashMap<String, String>());
    }
}

