/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.math.BigInteger;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ConstantColumnValue;
import net.sf.jasperreports.data.cache.EmptyColumnValues;
import net.sf.jasperreports.data.cache.LongArrayStore;
import net.sf.jasperreports.data.cache.NumberToBigIntegerOffsetTransformer;
import net.sf.jasperreports.data.cache.NumberToBigIntegerTransformer;
import net.sf.jasperreports.data.cache.ObjectArrayStore;
import net.sf.jasperreports.data.cache.TransformedColumnValues;
import net.sf.jasperreports.data.cache.ValueTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BigIntegerStore
implements BufferColumnStore {
    private static final Log log = LogFactory.getLog(BigIntegerStore.class);
    private final ObjectArrayStore<BigInteger> rawStore;
    private BigInteger min;
    private BigInteger max;
    private LongArrayStore primitiveStore;

    public BigIntegerStore(int size) {
        this.rawStore = new ObjectArrayStore<BigInteger>(BigInteger.class, size);
        this.reset();
        if (log.isDebugEnabled()) {
            log.debug((Object)("created object store " + this.rawStore + " for " + this));
        }
    }

    private void reset() {
        this.rawStore.resetValues();
        this.min = BigInteger.valueOf(Long.MAX_VALUE);
        this.max = BigInteger.valueOf(Long.MIN_VALUE);
    }

    @Override
    public Class<?> getBaseValuesType() {
        return BigInteger.class;
    }

    @Override
    public void addValue(Object object) {
        if (!(object instanceof BigInteger)) {
            throw new IllegalArgumentException();
        }
        BigInteger value = (BigInteger)object;
        this.rawStore.addValue(value);
        this.min = this.min.min(value);
        this.max = this.max.max(value);
    }

    @Override
    public boolean full() {
        return this.rawStore.full();
    }

    @Override
    public void resetValues() {
        this.reset();
    }

    @Override
    public ColumnValues createValues() {
        int count = this.rawStore.count();
        if (count == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": empty values"));
            }
            return EmptyColumnValues.instance();
        }
        if (this.min.equals(this.max)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": constant values of size " + count));
            }
            return new ConstantColumnValue(count, this.min);
        }
        BigInteger delta = this.max.subtract(this.min);
        int deltaLength = delta.bitLength();
        boolean useOffset = false;
        ColumnValues primitiveValues = null;
        if (deltaLength < 64) {
            boolean bl = useOffset = this.min.signum() < 0 || this.min.bitLength() >= 64 || this.max.signum() < 0 || this.max.bitLength() >= 64;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": creating privitive store of size " + count + ", with offset " + useOffset));
            }
            primitiveValues = this.createPrimitiveValues(useOffset);
        }
        if (primitiveValues == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": creating raw array store of size " + count));
            }
            return this.rawStore.createValues();
        }
        ValueTransformer transformer = useOffset ? new NumberToBigIntegerOffsetTransformer(this.min) : NumberToBigIntegerTransformer.instance();
        TransformedColumnValues columnValues = new TransformedColumnValues(primitiveValues, transformer);
        return columnValues;
    }

    protected ColumnValues createPrimitiveValues(boolean useOffset) {
        if (this.primitiveStore == null) {
            this.primitiveStore = new LongArrayStore(this.rawStore.size(), true);
        } else {
            this.primitiveStore.resetValues();
        }
        int count = this.rawStore.count();
        Object[] values = this.rawStore.valuesBuffer();
        for (int i = 0; i < count; ++i) {
            BigInteger value = (BigInteger)values[i];
            if (useOffset) {
                value = value.subtract(this.min);
            }
            this.primitiveStore.add(value.longValue());
        }
        ColumnValues primitiveValues = this.primitiveStore.createValues();
        return primitiveValues;
    }

    public String toString() {
        return "BigIntegerStore@" + this.hashCode();
    }
}

