/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;

class BigDecimalValuesIterator
implements ColumnValuesIterator {
    private final ColumnValuesIterator unscaledIterator;
    private final ColumnValuesIterator scaleIterator;

    public BigDecimalValuesIterator(ColumnValuesIterator unscaledIterator, ColumnValuesIterator scaleIterator) {
        this.unscaledIterator = unscaledIterator;
        this.scaleIterator = scaleIterator;
    }

    @Override
    public void moveFirst() {
        this.unscaledIterator.moveFirst();
        this.scaleIterator.moveFirst();
    }

    @Override
    public boolean next() {
        return this.unscaledIterator.next() && this.scaleIterator.next();
    }

    @Override
    public Object get() {
        BigInteger unscaled = (BigInteger)this.unscaledIterator.get();
        int scale = ((Number)this.scaleIterator.get()).intValue();
        return new BigDecimal(unscaled, scale);
    }
}

