/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.type.TimePeriodEnum;
import net.sf.jasperreports.charts.util.ChartUtil;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseChartDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseTimeSeriesDataset
extends JRBaseChartDataset
implements JRTimeSeriesDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_TIME_PERIOD = "timePeriod";
    private JRTimeSeries[] timeSeries;
    private TimePeriodEnum timePeriodValue;
    private transient JRPropertyChangeSupport eventSupport;
    private int PSEUDO_SERIAL_VERSION_UID = 62100;
    private Class<?> timePeriod;

    protected JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset) {
        super(dataset);
    }

    public JRBaseTimeSeriesDataset(JRTimeSeriesDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        this.timePeriodValue = dataset.getTimePeriodValue();
        JRTimeSeries[] srcTimeSeries = dataset.getSeries();
        if (srcTimeSeries != null && srcTimeSeries.length > 0) {
            this.timeSeries = new JRTimeSeries[srcTimeSeries.length];
            for (int i = 0; i < this.timeSeries.length; ++i) {
                this.timeSeries[i] = factory.getTimeSeries(srcTimeSeries[i]);
            }
        }
    }

    @Override
    public JRTimeSeries[] getSeries() {
        return this.timeSeries;
    }

    @Override
    public Class<?> getTimePeriod() {
        return ChartUtil.getTimePeriod(this.timePeriodValue);
    }

    @Override
    public void setTimePeriod(Class<?> timePeriod) {
        this.setTimePeriod(ChartUtil.getTimePeriod(timePeriod));
    }

    @Override
    public TimePeriodEnum getTimePeriodValue() {
        return this.timePeriodValue;
    }

    @Override
    public void setTimePeriod(TimePeriodEnum timePeriodValue) {
        TimePeriodEnum old = this.timePeriodValue;
        this.timePeriodValue = timePeriodValue;
        this.getEventSupport().firePropertyChange(PROPERTY_TIME_PERIOD, old, this.timePeriodValue);
    }

    @Override
    public byte getDatasetType() {
        return 6;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    @Override
    public Object clone() {
        JRBaseTimeSeriesDataset clone = (JRBaseTimeSeriesDataset)super.clone();
        clone.timeSeries = (JRTimeSeries[])JRCloneUtils.cloneArray((JRCloneable[])this.timeSeries);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseTimeSeriesDataset jRBaseTimeSeriesDataset = this;
        synchronized (jRBaseTimeSeriesDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 62100) {
            this.timePeriodValue = ChartUtil.getTimePeriod(this.timePeriod);
        }
    }
}

