/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.util;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.util.FileHolder;
import org.dbforms.util.Util;
import org.dbforms.util.external.FileUtil;

public class MultipartRequest {
    private static Log logCat = LogFactory.getLog(MultipartRequest.class);
    private Hashtable files = new Hashtable();
    private Hashtable parameters = new Hashtable();

    public MultipartRequest(HttpServletRequest request, int maxPostSize) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        DiskFileUpload upload = new DiskFileUpload();
        upload.setSizeMax((long)maxPostSize);
        String tmpDir = System.getProperty("java.io.tmpdir");
        upload.setRepositoryPath(tmpDir);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                String name = item.getFieldName();
                if (item.isFormField()) {
                    String value = item.getString();
                    Vector<String> existingValues = (Vector<String>)this.parameters.get(name);
                    if (existingValues == null) {
                        existingValues = new Vector<String>();
                        this.parameters.put(name, existingValues);
                    }
                    existingValues.addElement(value);
                    continue;
                }
                String fileName = item.getName();
                if (Util.isNull(fileName)) continue;
                File f = new File(fileName);
                fileName = FileUtil.filename(f.getName());
                FileHolder fileHolder = new FileHolder(fileName, item);
                this.files.put(name, fileHolder);
                logCat.info((Object)("buffered and now added as " + name + " the following fileHolder:" + fileHolder.getFileName()));
                Vector<String> existingValues = (Vector<String>)this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new Vector<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.addElement(fileName);
            }
        }
        catch (Exception e) {
            logCat.error((Object)"MultipartRequest", (Throwable)e);
        }
    }

    public String getContentType(String name) {
        try {
            FileHolder filePart = (FileHolder)this.files.get(name);
            return filePart.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public FileHolder getFileHolder(String name) {
        try {
            return (FileHolder)this.files.get(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InputStream getFileInputStream(String name) {
        try {
            FileHolder filePart = (FileHolder)this.files.get(name);
            return filePart.getInputStreamFromBuffer();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getFilesystemName(String name) {
        try {
            FileHolder filePart = (FileHolder)this.files.get(name);
            return filePart.getFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getParameter(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = (String)values.elementAt(0);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String[] getParameterValues(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }
}

