/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator.generation;

import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.transfer.CoreCommunicationInterface;
import de.destatis.core.connect.util.ClientLogger;
import de.destatis.core.generator.DataProvider;
import de.destatis.core.generator.DescriptorFactory;
import de.destatis.core.generator.FieldDescriptor;
import de.destatis.core.generator.MappingProvider;
import de.destatis.core.generator.StructureDescriptor;
import de.destatis.core.generator.generation.CollectConditionInfoTraverser;
import de.destatis.core.generator.generation.CollectRecordDataTraverser;
import de.destatis.core.generator.generation.ConditionInfo;
import de.destatis.core.generator.generation.SDFMetaDataCollector;
import de.destatis.core.generator.generation.SubMapDataProvider;
import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.FieldSetBinding;
import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingCheck;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.MetaMapping;
import de.destatis.core.map.model.SelectorBinding;
import de.destatis.core.resource.NoResourceFoundException;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SurveyResource;
import de.destatis.core.resource.SurveyResourceProvider;
import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.interpreter.DefaultClassificationFactory;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.sdf.generator.interpreter.SDFFieldDescriptorFactory;
import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.MetaCustomSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.MetaCustomSDFMerkmal;
import de.statspez.sdf.generator.meta.MetaCustomSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAufruf;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateAusfuehrung;
import de.statspez.sdf.generator.meta.MetaCustomSDFTemplateProgramm;
import de.statspez.sdf.generator.meta.SDFElement;
import de.statspez.sdf.generator.meta.SDFMetaElementVisitor;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFDokumenterzeuger;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetaMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFMetabeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplate;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateArgument;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAufruf;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAusfuehrung;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateAusgabe;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateParameter;
import de.statspez.sdf.generator.meta.generated.MetaSDFTemplateProgramm;
import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.sdf.generator.meta.util.SDFStructureHelper;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentBuilderInterpreter
implements SDFMetaElementVisitor {
    private static final String SPECIAL_REF_PRAEFIX = "#";
    private static final String REF_NAME = "#name";
    private static final String REF_VALUE = "#value";
    private static final String REF_INDEX = "#index";
    private static final String REF_DATETIME_REGEX = "#datetime\\((.+)\\)";
    private static final Pattern REF_DATETIME_PATTERN = Pattern.compile("#datetime\\((.+)\\)");
    private static final String REF_SDF_RESSOURCE_ID = "#sdf";
    private static final String REF_SDF_META_RESSOURCE_ID = "#sdfmeta";
    private static final String REF_DOCUMENT_ENCODING = "#encoding";
    private static final String REF_UUID = "#uuid";
    private static final String FOR_SDF_MERKMAL = "sdf:includeVariable";
    private static final String FOR_SDF_MERKMALSGRUPPE = "sdf:includeVariableGroup";
    private static final String FOR_RECORD = "sdf:dataGroup";
    private static final String FOR_MESSAGE = "messageMetadataGroup";
    private static final String FOR_HELPFEATURES = "sdf:messageDataGroup";
    private static final String METHOD_XML = "xml";
    private static ClientLogger LOG = ClientLogger.getLogger(DocumentBuilderInterpreter.class);
    private MetaSDFMetabeschreibung sdfMetaBeschreibung;
    private BufferedWriter writer;
    private DataProvider rootDataProvider;
    private SurveyResourceProvider surveyResourceProvider;
    private boolean sdfStrictMode;
    private boolean sdfMetaStrictMode;
    private MetaMapping metaMapping;
    private final MappingProvider mappingProvider;
    private Mapping currentMapping;
    private String documentBuilderEncoding;
    private EscapeMethod escapeMethod;
    private ProgramInterpreter interpreter = new ProgramInterpreter();
    private InterpreterContext templateAusfuehrungInterpreterContext;
    private Map documentMetaDataValues;
    private SurveyResource currentDatmlSdfSource;
    private MetaErhebungsbeschreibung currentErhebungsbeschreibung;
    private Stack dataProviderStack;
    private Stack structureDescriptorStack;
    private Stack sdfMetaDataProviderStack;
    private Stack sdfDataProviderStack;
    private Stack sdfStack;
    private Stack mmgrIndexStack;
    private Stack mmgrStack;
    private String sdfMerkmalValue;
    private Map recordFieldConditionsForAusgabegruppe;
    private Stack sdfMetaStack;
    private InterpreterContext conditionalFieldsInterpreterContext;
    private SDFFieldDescriptorFactory conditionalFieldsFieldDescriptorFactory;
    private Map currentFieldConditions;
    private Map helpFeaturesFieldConditions;
    private MetaSDFAusgabegruppe helpFeaturesAusgabegruppe;
    private Map helpFeatureValues;
    private DataProvider helpFeatureValuesDataProvider;
    private Date documentDate;
    private Map valueCheckMap;
    private SimpleDataset valueCheckDataset;
    private InterpreterContext valueCheckInterpreterContext;

    public DocumentBuilderInterpreter(DataProvider rootDataProvider, MetaSDFMetabeschreibung sdfMetaBeschreibung, BufferedWriter writer, SurveyResourceProvider surveyResourceProvider, boolean sdfStrictMode, boolean sdfMetaStrictMode, MetaMapping metaMapping, MappingProvider mappingProvider) {
        this.rootDataProvider = rootDataProvider;
        this.sdfMetaBeschreibung = sdfMetaBeschreibung;
        this.writer = writer;
        this.surveyResourceProvider = surveyResourceProvider;
        this.sdfStrictMode = sdfStrictMode;
        this.sdfMetaStrictMode = sdfMetaStrictMode;
        this.metaMapping = metaMapping;
        this.mappingProvider = mappingProvider;
    }

    public void visitSDFDokumenterzeuger(MetaSDFDokumenterzeuger dokumenterzeuger) {
        this.documentBuilderEncoding = dokumenterzeuger.getEncoding();
        String method = dokumenterzeuger.getMethode();
        this.escapeMethod = this.createEscapeMethod(method);
        this.documentDate = new Date();
        this.dataProviderStack = new Stack();
        this.dataProviderStack.push(this.rootDataProvider);
        this.structureDescriptorStack = new Stack();
        this.sdfStack = new Stack();
        this.sdfDataProviderStack = new Stack();
        this.sdfMetaDataProviderStack = new Stack();
        this.mmgrIndexStack = new Stack();
        this.mmgrStack = new Stack();
        this.valueCheckMap = new HashMap();
        this.valueCheckDataset = new SimpleDataset(this.valueCheckMap);
        this.valueCheckInterpreterContext = new InterpreterContext();
        this.valueCheckInterpreterContext.setSatz((SatzInterface)this.valueCheckDataset);
        MetaSDFMetaAusgabegruppe dokumentAusgabegruppe = this.sdfMetaBeschreibung.getDokumentAusgabegruppe();
        this.documentMetaDataValues = new HashMap();
        SDFMetaDataCollector dokumentMetaDataCollector = new SDFMetaDataCollector(null, (DataProvider)this.dataProviderStack.peek(), this.documentMetaDataValues, this.metaMapping, this.sdfMetaStrictMode);
        dokumentAusgabegruppe.accept((ElementVisitorInterface)dokumentMetaDataCollector);
        this.sdfMetaStack = new Stack();
        this.sdfMetaStack.push(dokumentAusgabegruppe);
        this.sdfMetaDataProviderStack.push(new SubMapDataProvider(this.documentMetaDataValues, null));
        MetaSDFTemplate startTemplate = ((MetaCustomSDFDokumenterzeuger)dokumenterzeuger).getStartTemplate();
        startTemplate.accept((ElementVisitorInterface)this);
        this.sdfMetaStack.pop();
        this.sdfMetaDataProviderStack.pop();
    }

    public void visitSDFMetaAusgabegruppe(MetaSDFMetaAusgabegruppe ausgabegruppe) {
    }

    public void visitSDFMetaFeldReferenz(MetaSDFMetaFeldReferenz feldrefernz) {
    }

    public void visitSDFMetaMerkmal(MetaSDFMetaMerkmal merkmal) {
    }

    public void visitSDFMetaMerkmalsgruppe(MetaSDFMetaMerkmalsgruppe merkmalsgruppe) {
    }

    public void visitSDFMetabeschreibung(MetaSDFMetabeschreibung metabeschreibung) {
    }

    public void visitSDFTemplate(MetaSDFTemplate template) {
        Iterator it = template.getAnweisungen();
        while (it.hasNext()) {
            ((SDFElement)it.next()).accept((ElementVisitorInterface)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitSDFTemplateArgument(MetaSDFTemplateArgument argument) {
        InvalidValue plValue;
        boolean escape = false;
        short escapingType = argument.getEscapingTyp();
        String argumentName = argument.getName();
        String value = argument.getWert();
        String ref = argument.getReferenz();
        boolean doCheckValue = false;
        MetaSDFMerkmal checkValueMerkmal = null;
        if (value == null && ref != null) {
            String dynValue;
            if (escapingType != 2) {
                escape = true;
            }
            if (ref.startsWith(SPECIAL_REF_PRAEFIX)) {
                if (REF_NAME.equals(ref)) {
                    SDFElement sdfElement = (SDFElement)this.sdfStack.peek();
                    if (sdfElement instanceof MetaStatspezObjekt) {
                        dynValue = ((MetaStatspezObjekt)sdfElement).getName();
                    } else {
                        if (!(sdfElement instanceof MetaSDFAusgabegruppe)) throw new IllegalStateException("Nicht unterst\u00fctzes Element auf dem SDFStack: '" + sdfElement.getClass() + "'.");
                        dynValue = ((MetaSDFAusgabegruppe)sdfElement).getName();
                    }
                } else if (REF_VALUE.equals(ref)) {
                    MetaSDFMerkmal sdfMerkmal = (MetaSDFMerkmal)this.sdfStack.peek();
                    dynValue = this.sdfMerkmalValue;
                    checkValueMerkmal = sdfMerkmal;
                    doCheckValue = this.sdfStrictMode;
                } else if (REF_UUID.equals(ref)) {
                    dynValue = null;
                } else if (REF_INDEX.equals(ref)) {
                    MetaSDFMerkmalsgruppe merkmalsgruppe = (MetaSDFMerkmalsgruppe)this.sdfStack.peek();
                    StructureDescriptor structureDescriptor = (StructureDescriptor)this.structureDescriptorStack.peek();
                    Integer index = structureDescriptor.getIndex();
                    String indexAttrValue = null;
                    short mmgrIndex = merkmalsgruppe.getIndex();
                    switch (mmgrIndex) {
                        case 2: {
                            if (index == null) break;
                            indexAttrValue = String.valueOf(index + 1);
                            break;
                        }
                        case 3: {
                            indexAttrValue = "name(" + merkmalsgruppe.getIndexVariable() + ")";
                        }
                    }
                    dynValue = indexAttrValue;
                } else if (REF_SDF_RESSOURCE_ID.equals(ref)) {
                    dynValue = this.currentDatmlSdfSource.getResourceId();
                } else if (REF_DOCUMENT_ENCODING.equals(ref)) {
                    dynValue = this.documentBuilderEncoding;
                } else if (REF_SDF_META_RESSOURCE_ID.equals(ref)) {
                    dynValue = this.sdfMetaBeschreibung.getProzedurCode();
                } else {
                    Matcher m = REF_DATETIME_PATTERN.matcher(ref);
                    if (!m.matches()) throw new DocumentbuilderInterpreterException("Unbekannte spezielle Argument-Referenz: '" + ref + "'.");
                    String dateFormatPattern = m.group(1);
                    SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatPattern);
                    dynValue = dateFormat.format(this.documentDate);
                }
            } else {
                MetaSDFMetaFeldReferenz sdfMetaFeldReferenz;
                SDFElement parentSdfMetaElement = (SDFElement)this.sdfMetaStack.peek();
                if (parentSdfMetaElement instanceof MetaSDFMetaMerkmalsgruppe) {
                    sdfMetaFeldReferenz = this.findSDFMetaMerkmalReferenz((MetaSDFMetaMerkmalsgruppe)parentSdfMetaElement, ref);
                } else {
                    if (!(parentSdfMetaElement instanceof MetaSDFMetaAusgabegruppe)) throw new IllegalStateException("Keine MetaSDFMetaMerkmalsgruppe oder MetaSDFMetaAusgabegruppe auf dem SDFMetaStack.");
                    sdfMetaFeldReferenz = this.findSDFMetaMerkmalReferenz((MetaSDFMetaAusgabegruppe)parentSdfMetaElement, ref);
                }
                if (sdfMetaFeldReferenz == null) {
                    throw new DocumentbuilderInterpreterException("Kein MetaSDFMetaMerkmal mit dem Namen '" + ref + "' gefunden.");
                }
                MetaSDFMetaMerkmal sdfMetaMerkmal = (MetaSDFMetaMerkmal)sdfMetaFeldReferenz.getKlasse();
                DataProvider dataProvider = (DataProvider)this.sdfMetaDataProviderStack.peek();
                StructureDescriptor structureDescriptor = this.structureDescriptorStack.empty() ? null : (StructureDescriptor)this.structureDescriptorStack.peek();
                FieldDescriptor metaFieldDescriptor = DescriptorFactory.createMetaFieldDescriptor(structureDescriptor, sdfMetaMerkmal, null, null);
                dynValue = dataProvider.getFieldValue(metaFieldDescriptor);
                checkValueMerkmal = sdfMetaMerkmal;
                if (this.sdfMetaStrictMode && (value != null || 2 == sdfMetaFeldReferenz.getAttributRequired())) {
                    doCheckValue = true;
                }
            }
            value = dynValue;
        }
        if (doCheckValue) {
            this.checkMerkmalValue(checkValueMerkmal, value);
        }
        if (value == null) {
            plValue = InvalidValue.instance();
        } else {
            if (escape) {
                value = this.escapeMethod.escape(value);
            }
            plValue = ValueFactory.instance().valueFor(value);
        }
        this.templateAusfuehrungInterpreterContext.setVariableValue(argumentName, (Value)plValue);
    }

    private void checkMerkmalValue(MetaSDFMerkmal merkmal, String value) {
        MetaProgram metaProgramm;
        boolean sdf = false;
        if (merkmal instanceof MetaCustomSDFMerkmal) {
            sdf = true;
            metaProgramm = ((MetaCustomSDFMerkmal)merkmal).getSpecification();
        } else {
            metaProgramm = ((MetaCustomSDFMetaMerkmal)merkmal).getSpecification();
        }
        if (metaProgramm != null) {
            DefaultClassificationFactory classificationFactory = new DefaultClassificationFactory();
            MetaAuspraegungsgruppe auspraegungsgruppe = merkmal.getKlasseWertebereich();
            if (auspraegungsgruppe != null) {
                ClassificationGroup classificationGroup = SDFFieldDescriptorFactory.createClassificationGroup((MetaAuspraegungsgruppe)auspraegungsgruppe);
                classificationFactory.registerClassificationGroup(classificationGroup.value().asString(), classificationGroup);
            }
            this.valueCheckInterpreterContext.setClassificationFactory((ClassificationFactory)classificationFactory);
            String merkmalName = merkmal.getName();
            this.valueCheckMap.put(merkmalName, value);
            this.valueCheckInterpreterContext.setCurrentField(SDFFieldDescriptorFactory.createSimpleFieldDescriptor((MetaSDFMerkmal)merkmal));
            if (!this.interpreter.execute(metaProgramm, this.valueCheckInterpreterContext).asBoolean()) {
                StructureDescriptor structureDescriptor = this.structureDescriptorStack.empty() ? null : (StructureDescriptor)this.structureDescriptorStack.peek();
                String path = structureDescriptor == null ? merkmalName : structureDescriptor.getPathString() + "." + merkmalName;
                throw new DocumentbuilderInterpreterException("Der Wert " + (value == null ? "null" : "'" + value + "'") + " des " + (sdf ? "SDF" : "SDFMeta") + "-Merkmals '" + path + "' liegt nicht im definierten Wertebereich.");
            }
            this.valueCheckMap.clear();
        }
    }

    public void visitSDFTemplateAufruf(MetaSDFTemplateAufruf aufruf) {
        MetaCustomSDFTemplateAufruf customAufruf = (MetaCustomSDFTemplateAufruf)aufruf;
        boolean isIteration = customAufruf.isIteration();
        String[] templateStrukturen = customAufruf.getTemplateStrukturen();
        MetaSDFTemplate template = customAufruf.getTemplate();
        if (templateStrukturen != null && templateStrukturen.length > 0) {
            if (templateStrukturen.length > 1) {
                if (templateStrukturen.length == 2 && isIteration) {
                    String templateStruktur1 = templateStrukturen[0];
                    String templateStruktur2 = templateStrukturen[1];
                    if (FOR_SDF_MERKMAL.equals(templateStruktur1) && FOR_SDF_MERKMALSGRUPPE.equals(templateStruktur2) || FOR_SDF_MERKMAL.equals(templateStruktur2) && FOR_SDF_MERKMALSGRUPPE.equals(templateStruktur1)) {
                        this.templateAufrufSDFMerkmalAndSDFMerkmalsgruppe(customAufruf);
                    }
                }
            } else if (templateStrukturen.length == 1) {
                String templateStruktur = templateStrukturen[0];
                if (isIteration) {
                    if (FOR_SDF_MERKMAL.equals(templateStruktur)) {
                        this.templateAufrufSDFMerkmal(customAufruf);
                    } else if (FOR_SDF_MERKMALSGRUPPE.equals(templateStruktur)) {
                        this.templateAufrufSDFMerkmalsgruppe(customAufruf);
                    } else if (FOR_RECORD.equals(templateStruktur)) {
                        this.templateAufrufSatz(customAufruf, template);
                    } else if (FOR_MESSAGE.equals(templateStruktur)) {
                        this.templateAufrufMessage(customAufruf, template);
                    }
                } else if (FOR_HELPFEATURES.equals(templateStruktur)) {
                    this.templateAufrufHelpFeatures(customAufruf, template);
                } else {
                    this.templateAufrufSDFMetaMerkmalsgruppe(customAufruf, templateStruktur, template);
                }
            }
        } else if (template != null) {
            template.accept((ElementVisitorInterface)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void templateAufrufMessage(MetaCustomSDFTemplateAufruf aufruf, MetaSDFTemplate template) {
        DataProvider rootDataProvider = (DataProvider)this.dataProviderStack.peek();
        int index = 0;
        DataProvider messageDataProvider = null;
        do {
            StructureDescriptor messageDescriptor;
            if ((messageDataProvider = rootDataProvider.getDataProvider(messageDescriptor = DescriptorFactory.createMessageDescriptor(index))) == null) continue;
            try {
                MappingCheck mappingCheck;
                MappingCheckResult checkResult;
                SurveyResource sdfSource;
                this.structureDescriptorStack.push(messageDescriptor);
                this.dataProviderStack.push(messageDataProvider);
                MetaSDFMetaAusgabegruppe nachrichtAusgabegruppe = this.sdfMetaBeschreibung.getNachrichtAusgabegruppe();
                HashMap nachrichtMetaDataValues = new HashMap();
                SDFMetaDataCollector nachrichtMetaDataCollector = new SDFMetaDataCollector(messageDescriptor, messageDataProvider, nachrichtMetaDataValues, this.metaMapping, this.sdfMetaStrictMode);
                nachrichtAusgabegruppe.accept((ElementVisitorInterface)nachrichtMetaDataCollector);
                this.sdfMetaStack.push(nachrichtAusgabegruppe);
                SubMapDataProvider nachrichtMetaDataProvider = new SubMapDataProvider(nachrichtMetaDataValues, messageDescriptor);
                this.sdfMetaDataProviderStack.push(nachrichtMetaDataProvider);
                FieldDescriptor statIdDescriptor = this.getStatIdDescriptor(messageDescriptor, nachrichtAusgabegruppe);
                if (statIdDescriptor == null) {
                    throw new DocumentbuilderInterpreterException("Das StatistikId-SDFMetaMerkmal existiert nicht.");
                }
                String statId = nachrichtMetaDataProvider.getFieldValue(statIdDescriptor);
                try {
                    CoreCommunicationInterface.checkStatisticID(statId);
                }
                catch (IncompleteRequestException e) {
                    throw new DocumentbuilderInterpreterException("Ungueltige StatistikID '" + statId + "'.", e);
                }
                FieldDescriptor referencePeriodDescriptor = this.getReferencePeriodDescriptor(messageDescriptor, nachrichtAusgabegruppe);
                if (referencePeriodDescriptor == null) {
                    throw new DocumentbuilderInterpreterException("Das Berichtszeitraum-SDFMetaMerkmal existiert nicht.");
                }
                String berichtszeitraum = nachrichtMetaDataProvider.getFieldValue(referencePeriodDescriptor);
                String referencePeriod = DocumentBuilderInterpreter.convertBzrToEidReferencePeriod(berichtszeitraum);
                FieldDescriptor collectorDescriptor = this.getCollectorDescriptor(messageDescriptor, nachrichtAusgabegruppe);
                if (collectorDescriptor == null) {
                    throw new DocumentbuilderInterpreterException("Das Berichtsempfaenger-SDFMetaMerkmal existiert nicht.");
                }
                String collector = nachrichtMetaDataProvider.getFieldValue(collectorDescriptor);
                try {
                    CoreCommunicationInterface.checkCollector(collector);
                }
                catch (IncompleteRequestException e) {
                    throw new DocumentbuilderInterpreterException("Ungueltiger Berichtsempfaenger '" + collector + "'.", e);
                }
                try {
                    sdfSource = this.surveyResourceProvider.getSurveyResource(statId, referencePeriod, collector);
                }
                catch (NoResourceFoundException e) {
                    throw new DocumentbuilderInterpreterException("Keine Erhebungsbeschreibung f\u00fcr '" + this.getErhebungParamString(statId, referencePeriod, collector) + "' gefunden.", e);
                }
                try {
                    this.currentErhebungsbeschreibung = sdfSource.getErhebungsbeschreibung();
                    this.currentDatmlSdfSource = sdfSource;
                }
                catch (ResourceException e) {
                    throw new DocumentbuilderInterpreterException("Fehler beim Parsen der Erhebungsbeschreibung '" + sdfSource.getResourceId() + "': " + e.toString(), e);
                }
                if (this.mappingProvider != null) {
                    this.currentMapping = this.mappingProvider.getMapping(index);
                }
                if (this.currentMapping != null && !(checkResult = (mappingCheck = new MappingCheck()).check(this.currentMapping, this.currentErhebungsbeschreibung)).isOk()) {
                    String error = checkResult.getErrorDescriptionString();
                    throw new DocumentbuilderInterpreterException("Das gegebene Mapping ist nicht fehlerfrei:\n" + error);
                }
                this.helpFeatureValues = new HashMap();
                MetaSDFAusgabesatz ausgabesatz = this.currentErhebungsbeschreibung.getAusgabesatz();
                Iterator ausgabegruppenIt = ausgabesatz.getAusgabegruppen();
                if (ausgabegruppenIt != null) {
                    while (ausgabegruppenIt.hasNext()) {
                        MetaSDFAusgabegruppe ausgabegruppe = (MetaSDFAusgabegruppe)ausgabegruppenIt.next();
                        short attributDaten = ausgabegruppe.getAttributDaten();
                        if (2 != attributDaten) continue;
                        this.helpFeaturesAusgabegruppe = ausgabegruppe;
                        CollectConditionInfoTraverser collectConditionsTraverser = new CollectConditionInfoTraverser(ausgabegruppe);
                        this.helpFeaturesFieldConditions = collectConditionsTraverser.collectConditionInfo();
                        CollectRecordDataTraverser collectRecordDataTraverser = new CollectRecordDataTraverser(messageDescriptor, messageDataProvider, this.currentMapping, this.helpFeatureValues);
                        ausgabegruppe.accept((ElementVisitorInterface)collectRecordDataTraverser);
                    }
                }
                this.helpFeatureValuesDataProvider = new SubMapDataProvider(this.helpFeatureValues, messageDescriptor);
                this.conditionalFieldsInterpreterContext = new InterpreterContext();
                this.conditionalFieldsFieldDescriptorFactory = new SDFFieldDescriptorFactory(this.currentErhebungsbeschreibung);
                Iterator iter = this.conditionalFieldsFieldDescriptorFactory.getClassificationGroups();
                while (iter != null && iter.hasNext()) {
                    ClassificationGroup classGroup = (ClassificationGroup)iter.next();
                    this.conditionalFieldsInterpreterContext.registerClassificationGroup(classGroup.value().asString(), classGroup);
                }
                this.conditionalFieldsInterpreterContext.setFieldDescriptorFactory((FieldDescriptorFactory)this.conditionalFieldsFieldDescriptorFactory);
                this.recordFieldConditionsForAusgabegruppe = new HashMap();
                template.accept((ElementVisitorInterface)this);
                this.recordFieldConditionsForAusgabegruppe = null;
                this.sdfMetaDataProviderStack.pop();
                this.sdfMetaStack.pop();
                this.structureDescriptorStack.pop();
                this.dataProviderStack.pop();
                this.helpFeaturesFieldConditions = null;
                this.currentErhebungsbeschreibung = null;
                this.currentDatmlSdfSource = null;
                this.conditionalFieldsInterpreterContext = null;
                this.conditionalFieldsFieldDescriptorFactory = null;
                this.helpFeaturesAusgabegruppe = null;
                this.helpFeatureValues = null;
                this.helpFeatureValuesDataProvider = null;
                ++index;
            }
            finally {
                messageDataProvider.close();
            }
        } while (messageDataProvider != null);
    }

    private String getErhebungParamString(String statId, String referencePeriod, String collector) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("StatistikId: ").append(statId);
        buffer.append(", Berichtszeitraum: ").append(referencePeriod);
        buffer.append(", Berichtsempf\u00e4nger: ").append(collector);
        return buffer.toString();
    }

    public static String convertBzrToEidReferencePeriod(String berichtszeitraum) {
        StringBuffer referencePeriod = new StringBuffer(6);
        try {
            String year;
            int yearInt;
            int bzrLength = berichtszeitraum.length();
            if (bzrLength > 3 && (yearInt = Integer.parseInt(year = berichtszeitraum.substring(0, 4))) > 0) {
                String yearTwoDigit = year.substring(2);
                if (bzrLength > 4) {
                    char check = berichtszeitraum.charAt(4);
                    if (check == 'H') {
                        int halfOfYear;
                        if (bzrLength == 6 && ((halfOfYear = Integer.parseInt(berichtszeitraum.substring(5))) == 1 || halfOfYear == 2)) {
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("1");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, halfOfYear, 3);
                        }
                    } else if (check == 'S') {
                        int semester;
                        if (bzrLength == 6 && ((semester = Integer.parseInt(berichtszeitraum.substring(5))) == 1 || semester == 2)) {
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("2");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, semester, 3);
                        }
                    } else if (check == 'Q') {
                        int quarter;
                        if (bzrLength == 6 && (quarter = Integer.parseInt(berichtszeitraum.substring(5))) > 0 && quarter < 5) {
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("3");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, quarter, 3);
                        }
                    } else if (check == 'W') {
                        int week;
                        if (bzrLength == 7 && (week = Integer.parseInt(berichtszeitraum.substring(5))) > 0 && week <= 53) {
                            GregorianCalendar calendar = new GregorianCalendar(Locale.GERMAN);
                            calendar.setLenient(false);
                            calendar.set(1, yearInt);
                            calendar.set(3, week);
                            calendar.get(3);
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("5");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, week, 3);
                        }
                    } else if (bzrLength == 6) {
                        int month = Integer.parseInt(berichtszeitraum.substring(4));
                        if (month > 0 && month <= 12) {
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("4");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, month, 3);
                        }
                    } else if (bzrLength == 8) {
                        int month = Integer.parseInt(berichtszeitraum.substring(4, 6));
                        int day = Integer.parseInt(berichtszeitraum.substring(6));
                        if (month > 0 && month <= 12 && day > 0 && day <= 31) {
                            GregorianCalendar calendar = new GregorianCalendar(Locale.GERMAN);
                            calendar.setLenient(false);
                            calendar.set(1, yearInt);
                            calendar.set(2, month - 1);
                            calendar.set(5, day);
                            int dayOfYear = calendar.get(6);
                            referencePeriod.append(yearTwoDigit);
                            referencePeriod.append("6");
                            DocumentBuilderInterpreter.appendWithZeroFill(referencePeriod, dayOfYear, 3);
                        }
                    }
                } else if (bzrLength == 4) {
                    referencePeriod.append(yearTwoDigit);
                    referencePeriod.append("0");
                    referencePeriod.append("000");
                }
            }
        }
        catch (RuntimeException e) {
            throw new DocumentbuilderInterpreterException("Ung\u00fcltiger Berichtszeitraum '" + berichtszeitraum + "': " + e.toString(), e);
        }
        if (referencePeriod.length() == 0) {
            throw new DocumentbuilderInterpreterException("Ung\u00fcltiger Berichtszeitraum '" + berichtszeitraum + "'.");
        }
        return referencePeriod.toString();
    }

    private static void appendWithZeroFill(StringBuffer buffer, int number, int length) {
        String numberStr = String.valueOf(number);
        int zeroFillCount = length - numberStr.length();
        for (int i = 0; i < zeroFillCount; ++i) {
            buffer.append('0');
        }
        buffer.append(numberStr);
    }

    private void templateAufrufSDFMetaMerkmalsgruppe(MetaCustomSDFTemplateAufruf aufruf, String sdfMetaMerkmalsgruppeHiearchie, MetaSDFTemplate template) {
        StructureDescriptor metaMmgrDescriptor;
        DataProvider dataProvider;
        DataProvider mmgrDataProvider;
        short applyType = aufruf.getVorbedingung();
        String[] metaMerkmalsGruppenNamen = sdfMetaMerkmalsgruppeHiearchie.split("\\.");
        int len = metaMerkmalsGruppenNamen.length;
        for (int i = 0; i < len; ++i) {
            MetaSDFMetaMerkmalsgruppe sdfMetaMmgr;
            String metaMerkmalsgruppeName = metaMerkmalsGruppenNamen[i];
            SDFElement parentSdfMetaElement = (SDFElement)this.sdfMetaStack.peek();
            if (parentSdfMetaElement instanceof MetaSDFMetaMerkmalsgruppe) {
                sdfMetaMmgr = this.findSDFMetaMerkmalsgruppe((MetaSDFMetaMerkmalsgruppe)parentSdfMetaElement, metaMerkmalsgruppeName);
            } else if (parentSdfMetaElement instanceof MetaSDFMetaAusgabegruppe) {
                sdfMetaMmgr = this.findSDFMetaMerkmalsgruppe((MetaSDFMetaAusgabegruppe)parentSdfMetaElement, metaMerkmalsgruppeName);
            } else {
                throw new IllegalStateException("Keine MetaSDFMetaMerkmalsgruppe oder MetaSDFMetaAusgabegruppe auf dem Stack.");
            }
            if (sdfMetaMmgr == null) {
                throw new DocumentbuilderInterpreterException("Keine MetaSDFMetaMerkmalsgruppe mit dem Namen '" + metaMerkmalsgruppeName + "' gefunden.");
            }
            this.sdfMetaStack.push(sdfMetaMmgr);
            StructureDescriptor parentDescriptor = this.structureDescriptorStack.empty() ? null : (StructureDescriptor)this.structureDescriptorStack.peek();
            StructureDescriptor sdfMetaMmgrDescriptor = DescriptorFactory.createMetaMmgrDescriptor(parentDescriptor, sdfMetaMmgr, null, null, null, null);
            this.structureDescriptorStack.push(sdfMetaMmgrDescriptor);
        }
        boolean invokeTemplate = applyType == 2 ? (mmgrDataProvider = (dataProvider = (DataProvider)this.sdfMetaDataProviderStack.peek()).getDataProvider(metaMmgrDescriptor = (StructureDescriptor)this.structureDescriptorStack.peek())) != null : true;
        if (invokeTemplate) {
            template.accept((ElementVisitorInterface)this);
        }
        int len2 = metaMerkmalsGruppenNamen.length;
        for (int i = 0; i < len2; ++i) {
            this.structureDescriptorStack.pop();
            this.sdfMetaStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void templateAufrufSatz(MetaCustomSDFTemplateAufruf aufruf, MetaSDFTemplate template) {
        MetaSDFAusgabegruppe ausgabegruppe;
        HashMap<MetaSDFAusgabegruppe, Integer> recordQuantities = null;
        if (this.sdfStrictMode) {
            recordQuantities = new HashMap<MetaSDFAusgabegruppe, Integer>();
        }
        StructureDescriptor messageDescriptor = (StructureDescriptor)this.structureDescriptorStack.peek();
        DataProvider messageDataProvider = (DataProvider)this.dataProviderStack.peek();
        int index = 0;
        DataProvider recordDataProvider = null;
        do {
            StructureDescriptor recordDescriptor;
            if ((recordDataProvider = messageDataProvider.getDataProvider(recordDescriptor = DescriptorFactory.createRecordDescriptor(messageDescriptor, index))) == null) continue;
            try {
                this.structureDescriptorStack.push(recordDescriptor);
                this.dataProviderStack.push(recordDataProvider);
                HashMap recordValues = new HashMap(this.helpFeatureValues);
                ausgabegruppe = this.getSDFAusgabegruppe(recordDescriptor, recordDataProvider, recordValues);
                if (ausgabegruppe == null) {
                    throw new DocumentbuilderInterpreterException("Die SDFAusgabegruppe des Satzes '" + recordDescriptor.getPathString() + "' konnte nicht bestimmt werden.");
                }
                if (this.sdfStrictMode) {
                    Integer quantity = (Integer)recordQuantities.get(ausgabegruppe);
                    quantity = quantity == null ? new Integer(1) : new Integer(quantity + 1);
                    recordQuantities.put(ausgabegruppe, quantity);
                    int maxOccurs = SDFUtil.getMaxOccurs((String)ausgabegruppe.getMaximaleAnzahl());
                    if (maxOccurs != -1 && quantity > maxOccurs) {
                        int minOccurs = SDFUtil.getMinOccurs((String)ausgabegruppe.getMinimaleAnzahl());
                        if (minOccurs != -1 && minOccurs == maxOccurs) {
                            throw new DocumentbuilderInterpreterException("Zu viel S\u00e4tze f\u00fcr Ausgabegruppe '" + ausgabegruppe.getName() + "' (" + recordDescriptor.getPathString() + "): Es m\u00fcssen genau " + maxOccurs + " Datens\u00e4tze geliefert werden.");
                        }
                        throw new DocumentbuilderInterpreterException("Zu viel S\u00e4tze f\u00fcr Ausgabegruppe '" + ausgabegruppe.getName() + "' (" + recordDescriptor.getPathString() + "): Es d\u00fcrfen h\u00f6chstens " + maxOccurs + " Datens\u00e4tze geliefert werden.");
                    }
                }
                this.sdfStack.push(ausgabegruppe);
                Map recordFieldConditions = (Map)this.recordFieldConditionsForAusgabegruppe.get(ausgabegruppe.getName());
                if (recordFieldConditions == null) {
                    CollectConditionInfoTraverser collectConditionsTraverser = new CollectConditionInfoTraverser(ausgabegruppe);
                    recordFieldConditions = collectConditionsTraverser.collectConditionInfo();
                    this.recordFieldConditionsForAusgabegruppe.put(ausgabegruppe.getName(), recordFieldConditions);
                }
                this.currentFieldConditions = recordFieldConditions;
                FieldSetBinding fieldSetBinding = null;
                if (this.currentMapping != null) {
                    fieldSetBinding = (FieldSetBinding)BindingHelper.getBindingByIdStrict(this.currentMapping, ausgabegruppe.getName());
                }
                CollectRecordDataTraverser collectRecordDataTraverser = new CollectRecordDataTraverser(recordDescriptor, recordDataProvider, fieldSetBinding, recordValues);
                ausgabegruppe.accept((ElementVisitorInterface)collectRecordDataTraverser);
                this.sdfDataProviderStack.push(new SubMapDataProvider(recordValues, recordDescriptor));
                SimpleDataset dataSet = new SimpleDataset(recordValues);
                dataSet.setNameSeparator(".");
                dataSet.setIndicesPrefix("[");
                dataSet.setIndicesSuffix("]");
                dataSet.setNumberOfSuffix("#anzahl");
                this.conditionalFieldsInterpreterContext.setSatz((SatzInterface)dataSet);
                this.conditionalFieldsFieldDescriptorFactory.setCurrentOutputGroup(ausgabegruppe);
                template.accept((ElementVisitorInterface)this);
                this.conditionalFieldsFieldDescriptorFactory.setCurrentOutputGroup(null);
                this.conditionalFieldsInterpreterContext.setSatz(null);
                this.sdfDataProviderStack.pop();
                this.sdfStack.pop();
                this.dataProviderStack.pop();
                this.structureDescriptorStack.pop();
                this.currentFieldConditions = null;
                ++index;
            }
            finally {
                recordDataProvider.close();
            }
        } while (recordDataProvider != null);
        if (this.sdfStrictMode) {
            MetaSDFAusgabesatz ausgabesatz = this.currentErhebungsbeschreibung.getAusgabesatz();
            Iterator it = ausgabesatz.getAusgabegruppen();
            while (it.hasNext()) {
                Integer recordsInteger;
                int records;
                int minOccurs;
                ausgabegruppe = (MetaSDFAusgabegruppe)it.next();
                if (1 != ausgabegruppe.getAttributDaten() || (minOccurs = SDFUtil.getMinOccurs((String)ausgabegruppe.getMinimaleAnzahl())) == -1 || (records = (recordsInteger = (Integer)recordQuantities.get(ausgabegruppe)) == null ? 0 : recordsInteger) >= minOccurs) continue;
                int maxOccurs = SDFUtil.getMaxOccurs((String)ausgabegruppe.getMaximaleAnzahl());
                if (maxOccurs != -1 && minOccurs == maxOccurs) {
                    throw new DocumentbuilderInterpreterException("Zu wenig S\u00e4tze (" + records + ") f\u00fcr Ausgabegruppe '" + ausgabegruppe.getName() + "' in Nachricht '" + messageDescriptor.getPathString() + "': Es m\u00fcssen genau " + minOccurs + " Datens\u00e4tze geliefert werden.");
                }
                throw new DocumentbuilderInterpreterException("Zu wenig S\u00e4tze (" + records + ") f\u00fcr Ausgabegruppe '" + ausgabegruppe.getName() + "' in Nachricht '" + messageDescriptor.getPathString() + "': Es m\u00fcssen mindestens " + minOccurs + " Datens\u00e4tze geliefert werden.");
            }
            recordQuantities = null;
        }
    }

    private MetaSDFAusgabegruppe getSDFAusgabegruppe(StructureDescriptor recordDescriptor, DataProvider recordDataProvider, Map recordValues) {
        MetaSDFAusgabegruppe result;
        MetaSDFAusgabesatz ausgabesatz = this.currentErhebungsbeschreibung.getAusgabesatz();
        MetaSDFAusgabegruppe defaultAusgabegruppe = SDFStructureHelper.getDeafaultDataGroup((MetaSDFAusgabesatz)ausgabesatz);
        if (defaultAusgabegruppe == null) {
            throw new IllegalStateException("Keine Defaultausgabegruppe vorhanden.");
        }
        if (SDFStructureHelper.hasManyDataGroups((MetaSDFAusgabesatz)ausgabesatz)) {
            MetaSDFAusgabegruppe metaSDFAusgabegruppe;
            Vector<MetaStatspezObjekt> selektorMerkmale = new Vector<MetaStatspezObjekt>();
            Iterator feldRefIt = defaultAusgabegruppe.getSDFFeldReferenzen();
            while (feldRefIt.hasNext()) {
                MetaSDFFeldReferenz feldReferenz = (MetaSDFFeldReferenz)feldRefIt.next();
                if (!feldReferenz.isIstSelektor()) continue;
                selektorMerkmale.add(feldReferenz.getKlasse());
            }
            HashMap<String, String> selektorFieldValues = new HashMap<String, String>();
            for (MetaSDFMerkmal metaSDFMerkmal : selektorMerkmale) {
                FieldDescriptor fieldDescriptor;
                String value;
                String mmName = metaSDFMerkmal.getName();
                String customName = null;
                Integer csvPosition = null;
                SelectorBinding selectorBinding = null;
                if (this.currentMapping != null) {
                    selectorBinding = (SelectorBinding)BindingHelper.getBindingByIdStrict(this.currentMapping, mmName);
                    customName = selectorBinding.getCustomName();
                    csvPosition = selectorBinding.getPosition();
                }
                if ((value = recordDataProvider.getFieldValue(fieldDescriptor = DescriptorFactory.createFieldDescriptor(recordDescriptor, metaSDFMerkmal, customName, csvPosition))) == null && selectorBinding != null) {
                    value = selectorBinding.getDefaultValue();
                }
                selektorFieldValues.put(mmName, value);
                recordValues.put(mmName, value);
            }
            result = metaSDFAusgabegruppe = SDFStructureHelper.findDataGroup((MetaErhebungsbeschreibung)this.currentErhebungsbeschreibung, selektorFieldValues);
        } else {
            result = defaultAusgabegruppe;
        }
        return result;
    }

    private void templateAufrufHelpFeatures(MetaCustomSDFTemplateAufruf aufruf, MetaSDFTemplate template) {
        this.currentFieldConditions = this.helpFeaturesFieldConditions;
        this.sdfDataProviderStack.push(this.helpFeatureValuesDataProvider);
        this.sdfStack.push(this.helpFeaturesAusgabegruppe);
        SimpleDataset dataSet = new SimpleDataset(this.helpFeatureValues);
        dataSet.setNameSeparator(".");
        dataSet.setIndicesPrefix("[");
        dataSet.setIndicesSuffix("]");
        dataSet.setNumberOfSuffix("#anzahl");
        this.conditionalFieldsInterpreterContext.setSatz((SatzInterface)dataSet);
        this.conditionalFieldsFieldDescriptorFactory.setCurrentOutputGroup(this.helpFeaturesAusgabegruppe);
        template.accept((ElementVisitorInterface)this);
        this.conditionalFieldsFieldDescriptorFactory.setCurrentOutputGroup(null);
        this.conditionalFieldsInterpreterContext.setSatz(null);
        this.sdfStack.pop();
        this.sdfDataProviderStack.pop();
        this.currentFieldConditions = null;
    }

    private void templateAufrufSDFMerkmal(MetaCustomSDFTemplateAufruf aufruf) {
        this.templateAufrufSDFMerkmalSDFMerkmalsgruppe(aufruf, true, false);
    }

    private void templateAufrufSDFMerkmalsgruppe(MetaCustomSDFTemplateAufruf aufruf) {
        this.templateAufrufSDFMerkmalSDFMerkmalsgruppe(aufruf, false, true);
    }

    private void templateAufrufSDFMerkmalAndSDFMerkmalsgruppe(MetaCustomSDFTemplateAufruf aufruf) {
        this.templateAufrufSDFMerkmalSDFMerkmalsgruppe(aufruf, true, true);
    }

    private void templateAufrufSDFMerkmalSDFMerkmalsgruppe(MetaCustomSDFTemplateAufruf aufruf, boolean doProcessMerkmale, boolean doProcessMerkmalsgruppen) {
        SDFElement sdfElement = (SDFElement)this.sdfStack.peek();
        Iterator feldRefIt = sdfElement instanceof MetaSDFMerkmalsgruppe ? ((MetaSDFMerkmalsgruppe)sdfElement).getSDFFeldReferenzen() : ((MetaSDFAusgabegruppe)sdfElement).getSDFFeldReferenzen();
        MetaSDFTemplate sdfMerkmalTemplate = null;
        MetaSDFTemplate sdfMerkmalsgruppeTemplate = null;
        if (doProcessMerkmale && doProcessMerkmalsgruppen) {
            sdfMerkmalTemplate = aufruf.getTemplateFor(FOR_SDF_MERKMAL);
            sdfMerkmalsgruppeTemplate = aufruf.getTemplateFor(FOR_SDF_MERKMALSGRUPPE);
        } else if (doProcessMerkmale) {
            sdfMerkmalTemplate = aufruf.getTemplate();
        } else if (doProcessMerkmalsgruppen) {
            sdfMerkmalsgruppeTemplate = aufruf.getTemplate();
        }
        while (feldRefIt.hasNext()) {
            Boolean[] conditionHint;
            MetaSDFFeldReferenz feldReferenz = (MetaSDFFeldReferenz)feldRefIt.next();
            MetaStatspezObjekt metaStatspezObjekt = feldReferenz.getKlasse();
            if (feldReferenz.getArt() == 2 && doProcessMerkmalsgruppen) {
                int stop;
                conditionHint = null;
                if (this.sdfStrictMode) {
                    conditionHint = new Boolean[1];
                }
                if (this.sdfStrictMode && !this.shouldEnterSdfMerkmalsgruppe((MetaSDFMerkmalsgruppe)metaStatspezObjekt, conditionHint)) continue;
                this.sdfStack.push(metaStatspezObjekt);
                this.mmgrStack.push(metaStatspezObjekt);
                int minOccurs = SDFUtil.getMinOccurs((String)feldReferenz.getMinimaleAnzahl());
                int maxOccurs = SDFUtil.getMaxOccurs((String)feldReferenz.getMaximaleAnzahl());
                if (minOccurs == 1 && maxOccurs == 1) {
                    stop = 1;
                } else {
                    stop = maxOccurs;
                    if (stop == -1) {
                        stop = Integer.MAX_VALUE;
                    }
                }
                for (int index = 0; index < stop; ++index) {
                    Integer indexInteger = new Integer(index);
                    this.mmgrIndexStack.push(indexInteger);
                    StructureDescriptor parent = (StructureDescriptor)this.structureDescriptorStack.peek();
                    DataProvider dataProvider = (DataProvider)this.sdfDataProviderStack.peek();
                    StructureDescriptor mmgrDescriptor = DescriptorFactory.createMmgrDescriptor(parent, (MetaSDFMerkmalsgruppe)metaStatspezObjekt, indexInteger, null, null, null, null);
                    DataProvider mmgrDataProvider = dataProvider.getDataProvider(mmgrDescriptor);
                    if (mmgrDataProvider == null) {
                        if (this.sdfStrictMode) {
                            if (index == 0) {
                                boolean reportError = false;
                                Boolean conditionResult = conditionHint[0];
                                if (conditionResult != null) {
                                    if (conditionResult.booleanValue()) {
                                        reportError = true;
                                    }
                                } else if (3 != feldReferenz.getAttributRequired()) {
                                    reportError = true;
                                }
                                if (reportError) {
                                    throw new DocumentbuilderInterpreterException("Es ist kein Satz '" + mmgrDescriptor.getPathString() + "' f\u00fcr die erforderliche SDFMerkmalsgruppe '" + metaStatspezObjekt.getName() + "' vorhanden.");
                                }
                            } else if (minOccurs != -1 && index < minOccurs) {
                                throw new DocumentbuilderInterpreterException("Es m\u00fcssen mindestens " + minOccurs + " Datens\u00e4tze f\u00fcr die SDFMerkmalsgruppe '" + metaStatspezObjekt.getName() + "' geliefert werden. Satz '" + mmgrDescriptor.getPathString() + "' ist nicht vorhanden.");
                            }
                        }
                        this.mmgrIndexStack.pop();
                        break;
                    }
                    this.structureDescriptorStack.push(mmgrDescriptor);
                    sdfMerkmalsgruppeTemplate.accept((ElementVisitorInterface)this);
                    this.structureDescriptorStack.pop();
                    this.mmgrIndexStack.pop();
                }
                this.mmgrStack.pop();
                this.sdfStack.pop();
                continue;
            }
            if (!doProcessMerkmale) continue;
            conditionHint = null;
            if (this.sdfStrictMode) {
                conditionHint = new Boolean[1];
            }
            if (this.sdfStrictMode && !this.shouldEnterSdfMerkmal((MetaSDFMerkmal)metaStatspezObjekt, conditionHint)) continue;
            this.sdfStack.push(metaStatspezObjekt);
            StructureDescriptor parent = (StructureDescriptor)this.structureDescriptorStack.peek();
            FieldDescriptor mmDescriptor = DescriptorFactory.createFieldDescriptor(parent, (MetaSDFMerkmal)metaStatspezObjekt, null, null);
            DataProvider dataProvider = (DataProvider)this.sdfDataProviderStack.peek();
            this.sdfMerkmalValue = dataProvider.getFieldValue(mmDescriptor);
            if (this.sdfMerkmalValue == null) {
                if (this.sdfStrictMode) {
                    boolean reportError = false;
                    Boolean conditionResult = conditionHint[0];
                    if (conditionResult != null) {
                        if (conditionResult.booleanValue()) {
                            reportError = true;
                        }
                    } else if (3 != feldReferenz.getAttributRequired()) {
                        reportError = true;
                    }
                    if (reportError) {
                        throw new DocumentbuilderInterpreterException("Es ist kein Wert f\u00fcr das erforderliche SDFMerkmal '" + mmDescriptor.getPathString() + "' angegeben.");
                    }
                }
            } else {
                sdfMerkmalTemplate.accept((ElementVisitorInterface)this);
            }
            this.sdfMerkmalValue = null;
            this.sdfStack.pop();
        }
    }

    private boolean shouldEnterSdfMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe, Boolean[] conditionHint) {
        return this.shouldEnterSdfMerkmalOrSdfMerkmalsgruppe((MetaStatspezObjekt)merkmalsgruppe, conditionHint);
    }

    private boolean shouldEnterSdfMerkmal(MetaSDFMerkmal merkmal, Boolean[] conditionHint) {
        return this.shouldEnterSdfMerkmalOrSdfMerkmalsgruppe((MetaStatspezObjekt)merkmal, conditionHint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldEnterSdfMerkmalOrSdfMerkmalsgruppe(MetaStatspezObjekt metaStatspezObject, Boolean[] conditionHint) {
        Boolean conditionResult;
        short conditionType;
        String fieldPath = this.getMmgrHierarchy() + metaStatspezObject.getName();
        ConditionInfo conditionInfo = (ConditionInfo)this.currentFieldConditions.get(fieldPath);
        if (conditionInfo != null) {
            boolean processCondition;
            MetaCustomSDFBedingung condition = conditionInfo.getCondition();
            conditionType = condition.getBedingungsTyp();
            boolean bl = processCondition = 2 == conditionType || conditionHint != null && 3 != conditionType;
            if (processCondition) {
                SDFElement ausgabegruppeOrMerkmalsgruppe = conditionInfo.getMetaStatspezObjekt();
                if (ausgabegruppeOrMerkmalsgruppe instanceof MetaSDFAusgabegruppe) {
                    this.conditionalFieldsFieldDescriptorFactory.setCurrentStructure(null, null);
                } else {
                    if (!(ausgabegruppeOrMerkmalsgruppe instanceof MetaSDFMerkmalsgruppe)) throw new DocumentbuilderInterpreterException("Bedingungen k\u00f6nnen nur durch Merkmalsgruppen oder Ausgabegruppen definiert werden ( Feld: " + fieldPath + ")!");
                    this.conditionalFieldsFieldDescriptorFactory.setCurrentStructure(this.mmgrStack, this.mmgrIndexStack);
                    int structureLevel = this.mmgrStack.indexOf(ausgabegruppeOrMerkmalsgruppe);
                    this.conditionalFieldsFieldDescriptorFactory.setCurrentStructureLevel(structureLevel);
                }
                if (condition.getSpecification() == null) throw new DocumentbuilderInterpreterException("Ung\u00fcltige Bedingung: " + condition.getBedingung());
                try {
                    conditionResult = this.interpreter.execute(condition.getSpecification(), this.conditionalFieldsInterpreterContext).asBoolean();
                }
                catch (Exception e) {
                    StringBuffer error = new StringBuffer("Fehler beim Pr\u00fcfen der Bedingung von Feld '");
                    error.append(fieldPath);
                    error.append("'.");
                    LOG.trace(error.toString(), e);
                    throw new DocumentbuilderInterpreterException(error.toString(), e);
                }
            } else {
                conditionResult = conditionHint != null && 3 == conditionType ? Boolean.FALSE : null;
            }
        } else {
            if (conditionHint == null) return true;
            conditionHint[0] = null;
            return true;
        }
        boolean shouldEnter = 2 == conditionType ? conditionResult : true;
        if (conditionHint == null) return shouldEnter;
        conditionHint[0] = conditionResult;
        return shouldEnter;
    }

    private String getMmgrHierarchy() {
        StringBuffer buffer = new StringBuffer();
        int len = this.mmgrStack.size();
        for (int i = 0; i < len; ++i) {
            buffer.append(((MetaSDFMerkmalsgruppe)this.mmgrStack.get(i)).getName());
            buffer.append(".");
        }
        return buffer.toString();
    }

    public void visitSDFTemplateAusfuehrung(MetaSDFTemplateAusfuehrung ausfuehrung) {
        this.templateAusfuehrungInterpreterContext = new InterpreterContext();
        MetaCustomSDFTemplateProgramm programm = (MetaCustomSDFTemplateProgramm)((MetaCustomSDFTemplateAusfuehrung)ausfuehrung).getProgramm();
        MetaProgram plProgramm = programm.getSpecification();
        if (plProgramm == null) {
            throw new IllegalArgumentException("Es wird nur PL-Code unterst\u00fctzt.");
        }
        Iterator parameterIt = programm.getParameter();
        while (parameterIt.hasNext()) {
            ((SDFElement)parameterIt.next()).accept((ElementVisitorInterface)this);
        }
        Iterator iter = ausfuehrung.getArgumente();
        while (iter.hasNext()) {
            ((SDFElement)iter.next()).accept((ElementVisitorInterface)this);
        }
        this.templateAusfuehrungInterpreterContext.setConsole(this.writer);
        programm.accept((ElementVisitorInterface)this);
        this.templateAusfuehrungInterpreterContext = null;
    }

    public void visitSDFTemplateAusgabe(MetaSDFTemplateAusgabe ausgabe) {
        String text = ausgabe.getText();
        try {
            this.writer.write(text);
        }
        catch (IOException e) {
            throw new DocumentbuilderInterpreterException(e);
        }
    }

    public void visitSDFTemplateParameter(MetaSDFTemplateParameter parameter) {
        String parameterName = parameter.getName();
        String vorgabeWert = parameter.getVorgabeWert();
        this.templateAusfuehrungInterpreterContext.declareVariable(parameterName);
        if (vorgabeWert != null) {
            Value value = ValueFactory.instance().valueFor(vorgabeWert);
            this.templateAusfuehrungInterpreterContext.setVariableValue(parameterName, value);
        }
    }

    public void visitSDFTemplateProgramm(MetaSDFTemplateProgramm programm) {
        this.interpreter.execute(((MetaCustomSDFTemplateProgramm)programm).getSpecification(), this.templateAusfuehrungInterpreterContext);
    }

    private MetaSDFMetaMerkmalsgruppe findSDFMetaMerkmalsgruppe(MetaSDFMetaMerkmalsgruppe parent, String metaMmmgrName) {
        MetaSDFMetaMerkmalsgruppe result = null;
        Iterator it = parent.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            MetaSDFMetaMerkmalsgruppe mmgr;
            String mmgrName;
            MetaSDFMetaFeldReferenz feldReferenz = (MetaSDFMetaFeldReferenz)it.next();
            short art = feldReferenz.getArt();
            if (art != 2 || !metaMmmgrName.equals(mmgrName = (mmgr = (MetaSDFMetaMerkmalsgruppe)feldReferenz.getKlasse()).getName())) continue;
            result = mmgr;
            break;
        }
        return result;
    }

    private MetaSDFMetaMerkmalsgruppe findSDFMetaMerkmalsgruppe(MetaSDFMetaAusgabegruppe parent, String metaMmmgrName) {
        MetaSDFMetaMerkmalsgruppe result = null;
        Iterator it = parent.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            MetaSDFMetaMerkmalsgruppe mmgr;
            String mmgrName;
            MetaSDFMetaFeldReferenz feldReferenz = (MetaSDFMetaFeldReferenz)it.next();
            short art = feldReferenz.getArt();
            if (art != 2 || !metaMmmgrName.equals(mmgrName = (mmgr = (MetaSDFMetaMerkmalsgruppe)feldReferenz.getKlasse()).getName())) continue;
            result = mmgr;
            break;
        }
        return result;
    }

    private MetaSDFMetaFeldReferenz findSDFMetaMerkmalReferenz(MetaSDFMetaMerkmalsgruppe parent, String metaMerkmalName) {
        MetaSDFMetaFeldReferenz result = null;
        Iterator it = parent.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            MetaSDFMetaMerkmal merkmal;
            String mmgrName;
            MetaSDFMetaFeldReferenz feldReferenz = (MetaSDFMetaFeldReferenz)it.next();
            short art = feldReferenz.getArt();
            if (art != 1 || !metaMerkmalName.equals(mmgrName = (merkmal = (MetaSDFMetaMerkmal)feldReferenz.getKlasse()).getName())) continue;
            result = feldReferenz;
            break;
        }
        return result;
    }

    private MetaSDFMetaFeldReferenz findSDFMetaMerkmalReferenz(MetaSDFMetaAusgabegruppe parent, String metaMerkmalName) {
        MetaSDFMetaFeldReferenz result = null;
        Iterator it = parent.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            MetaSDFMetaMerkmal merkmal;
            String mmgrName;
            MetaSDFMetaFeldReferenz feldReferenz = (MetaSDFMetaFeldReferenz)it.next();
            short art = feldReferenz.getArt();
            if (art != 1 || !metaMerkmalName.equals(mmgrName = (merkmal = (MetaSDFMetaMerkmal)feldReferenz.getKlasse()).getName())) continue;
            result = feldReferenz;
            break;
        }
        return result;
    }

    private FieldDescriptor getStatIdDescriptor(StructureDescriptor nachrichtDescriptor, MetaSDFMetaAusgabegruppe nachrichtAusgabegruppe) {
        return this.getSDFMetaMerkmalDescriptor(nachrichtDescriptor, nachrichtAusgabegruppe, "ErhebungsID");
    }

    private FieldDescriptor getReferencePeriodDescriptor(StructureDescriptor nachrichtDescriptor, MetaSDFMetaAusgabegruppe nachrichtAusgabegruppe) {
        return this.getSDFMetaMerkmalDescriptor(nachrichtDescriptor, nachrichtAusgabegruppe, "Berichtszeitraum");
    }

    private FieldDescriptor getCollectorDescriptor(StructureDescriptor nachrichtDescriptor, MetaSDFMetaAusgabegruppe nachrichtAusgabegruppe) {
        return this.getSDFMetaMerkmalDescriptor(nachrichtDescriptor, nachrichtAusgabegruppe, "Berichtsempfaenger");
    }

    private FieldDescriptor getSDFMetaMerkmalDescriptor(StructureDescriptor nachrichtDescriptor, MetaSDFMetaAusgabegruppe nachrichtAusgabegruppe, String sdfMetaMerkmalName) {
        FieldDescriptor result = null;
        FieldBinding fieldBinding = null;
        if (this.metaMapping != null) {
            FieldSetBinding messageBinding = this.metaMapping.getMessageBinding();
            fieldBinding = (FieldBinding)BindingHelper.getBindingByIdStrict(messageBinding, sdfMetaMerkmalName);
        }
        Iterator it = nachrichtAusgabegruppe.getSDFMetaFeldReferenzen();
        while (it.hasNext()) {
            MetaSDFMetaMerkmal merkmal;
            String name;
            MetaSDFMetaFeldReferenz feldReferenz = (MetaSDFMetaFeldReferenz)it.next();
            if (feldReferenz.getArt() != 1 || !(name = (merkmal = (MetaSDFMetaMerkmal)feldReferenz.getKlasse()).getName()).equals(sdfMetaMerkmalName)) continue;
            String customName = null;
            Integer csvPosition = null;
            if (fieldBinding != null) {
                customName = fieldBinding.getCustomName();
                csvPosition = fieldBinding.getPosition();
            }
            result = DescriptorFactory.createMetaFieldDescriptor(nachrichtDescriptor, merkmal, customName, csvPosition);
            break;
        }
        return result;
    }

    private EscapeMethod createEscapeMethod(String method) {
        if (!METHOD_XML.equalsIgnoreCase(method)) {
            throw new IllegalArgumentException("Unbekannte Ausgabemethode '" + method + "'.");
        }
        XmlEscapeMethod result = new XmlEscapeMethod();
        return result;
    }

    public static class XmlEscapeMethod
    implements EscapeMethod {
        @Override
        public String escape(String value) {
            return XmlEscapeMethod.escapeString(value);
        }

        public static String escapeString(String inputString) {
            String erg = inputString;
            if (inputString != null && inputString.length() > 0) {
                StringBuffer buffer = null;
                int len = inputString.length();
                for (int i = 0; i < len; ++i) {
                    char check = inputString.charAt(i);
                    String replacement = XmlEscapeMethod.getReplacement(check);
                    if (replacement != null) {
                        if (buffer == null) {
                            buffer = new StringBuffer(inputString.length() + 30);
                            if (i > 0) {
                                buffer.append(inputString.toCharArray(), 0, i);
                            }
                        }
                        buffer.append(replacement);
                        continue;
                    }
                    if (buffer == null) continue;
                    buffer.append(check);
                }
                if (buffer != null) {
                    erg = buffer.toString();
                }
            }
            return erg;
        }

        private static String getReplacement(char character) {
            String replacememt = null;
            if (character == '&') {
                replacememt = "&amp;";
            } else if (character == '<') {
                replacememt = "&lt;";
            } else if (character == '>') {
                replacememt = "&gt;";
            } else if (character == '\"') {
                replacememt = "&quot;";
            } else if (character == '\'') {
                replacememt = "&apos;";
            }
            return replacememt;
        }
    }

    protected static interface EscapeMethod {
        public String escape(String var1);
    }

    public static class DocumentbuilderInterpreterException
    extends RuntimeException {
        public DocumentbuilderInterpreterException(Throwable cause) {
            super(cause);
        }

        public DocumentbuilderInterpreterException(String message) {
            super(message);
        }

        public DocumentbuilderInterpreterException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

