/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.linear.QRDecomposition;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixImpl;

public class QRDecompositionImpl
implements QRDecomposition {
    private double[][] qr;
    private double[] rDiag;
    private int m;
    private int n;

    public QRDecompositionImpl(RealMatrix matrix) {
        this.m = matrix.getRowDimension();
        this.n = matrix.getColumnDimension();
        this.qr = matrix.getData();
        this.rDiag = new double[this.n];
        for (int minor = 0; minor < Math.min(this.m, this.n); ++minor) {
            double xNormSqr = 0.0;
            for (int row = minor; row < this.m; ++row) {
                xNormSqr += this.qr[row][minor] * this.qr[row][minor];
            }
            double a = Math.sqrt(xNormSqr);
            if (this.qr[minor][minor] > 0.0) {
                a = -a;
            }
            this.rDiag[minor] = a;
            if (a == 0.0) continue;
            double[] dArray = this.qr[minor];
            int n = minor;
            dArray[n] = dArray[n] - a;
            for (int col = minor + 1; col < this.n; ++col) {
                int row;
                double alpha = 0.0;
                for (row = minor; row < this.m; ++row) {
                    alpha -= this.qr[row][col] * this.qr[row][minor];
                }
                alpha /= a * this.qr[minor][minor];
                for (row = minor; row < this.m; ++row) {
                    double[] dArray2 = this.qr[row];
                    int n2 = col;
                    dArray2[n2] = dArray2[n2] - alpha * this.qr[row][minor];
                }
            }
        }
    }

    public RealMatrix getR() {
        RealMatrixImpl ret = new RealMatrixImpl(this.m, this.n);
        double[][] r = ret.getDataRef();
        for (int row = Math.min(this.m, this.n) - 1; row >= 0; --row) {
            r[row][row] = this.rDiag[row];
            for (int col = row + 1; col < this.n; ++col) {
                r[row][col] = this.qr[row][col];
            }
        }
        return ret;
    }

    public RealMatrix getQ() {
        int minor;
        RealMatrixImpl ret = new RealMatrixImpl(this.m, this.m);
        double[][] Q = ret.getDataRef();
        for (minor = this.m - 1; minor >= Math.min(this.m, this.n); --minor) {
            Q[minor][minor] = 1.0;
        }
        for (minor = Math.min(this.m, this.n) - 1; minor >= 0; --minor) {
            Q[minor][minor] = 1.0;
            if (this.qr[minor][minor] == 0.0) continue;
            for (int col = minor; col < this.m; ++col) {
                int row;
                double alpha = 0.0;
                for (row = minor; row < this.m; ++row) {
                    alpha -= Q[row][col] * this.qr[row][minor];
                }
                alpha /= this.rDiag[minor] * this.qr[minor][minor];
                for (row = minor; row < this.m; ++row) {
                    double[] dArray = Q[row];
                    int n = col;
                    dArray[n] = dArray[n] - alpha * this.qr[row][minor];
                }
            }
        }
        return ret;
    }
}

