/*
 * Decompiled with CFR 0.152.
 */
package de.superx.util;

import de.memtext.util.StringUtils;
import java.util.StringTokenizer;

public class HtmlUtils {
    public static String adapt(StringBuffer txt) {
        StringUtils.replace(txt, "\n", "<br>");
        return txt.toString();
    }

    public static String adapt(String txt) {
        return HtmlUtils.adapt(new StringBuffer(txt));
    }

    public static String chooseName(String varname, String caption_short) {
        String result = caption_short;
        if (result == null || result.trim().equals("") || result.equals("null")) {
            result = varname;
        }
        return result;
    }

    public static String encodeURL(String url, String sessionid) {
        if (sessionid != null && !sessionid.trim().equals("")) {
            return String.valueOf(url) + ";jsessionid=" + sessionid;
        }
        return url;
    }

    public static String headers2multiheaders(String headerStr) {
        if ((headerStr = headerStr.trim()).endsWith("^")) {
            headerStr = headerStr.substring(0, headerStr.length() - 1);
        }
        StringBuffer buf = new StringBuffer(headerStr);
        StringUtils.replace(buf, "\\n", "\n");
        StringUtils.replace(buf, "\\000", "\u0000");
        HeaderMatrix headers = null;
        headers = new HeaderMatrix(buf.toString(), "^", "\u0000");
        return headers.toMultiheadersString();
    }

    public static String headers2html(String headerStr) {
        if ((headerStr = headerStr.trim()).endsWith("^")) {
            headerStr = headerStr.substring(0, headerStr.length() - 1);
        }
        StringBuffer buf = new StringBuffer(headerStr);
        StringUtils.replace(buf, "\\n", "\n");
        StringUtils.replace(buf, "\\000", "\u0000");
        HeaderMatrix headers = null;
        headers = new HeaderMatrix(buf.toString(), "^", "\u0000");
        return headers.toString();
    }

    public static void main(String[] args) {
        String header = "Lehreinheit^1.FS\\000K\u00f6pfe^1.FS\\000F\u00e4lle^Absolvten";
    }

    private static class HeaderData {
        private String headerStr;
        private String colspanIndicator;
        private boolean log = false;

        HeaderData(String headerStr, String colspanIndicator) {
            this.headerStr = headerStr;
            this.colspanIndicator = colspanIndicator;
        }

        void cut(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            this.headerStr = this.headerStr.substring(0, potHeader.length());
        }

        HeaderData getRest(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            if (this.log) {
                System.out.println("header:" + potHeader + " headerStr:" + potHeader);
            }
            HeaderData result = new HeaderData("", this.colspanIndicator);
            if (this.headerStr.length() > potHeader.length()) {
                result = new HeaderData(this.headerStr.substring(potHeader.length() + 1), this.colspanIndicator);
            }
            return result;
        }

        boolean hasRest(String potHeader) {
            if (!this.headerStr.startsWith(potHeader)) {
                throw new IllegalArgumentException("must start with " + potHeader);
            }
            return this.headerStr.length() > potHeader.length();
        }

        String getPotHeader() {
            return this.headerStr.substring(0, this.headerStr.indexOf(this.colspanIndicator));
        }

        boolean startsWith(String str) {
            return this.headerStr.startsWith(str);
        }

        String substring(int begin, int end) {
            return this.headerStr.substring(begin, end);
        }

        int indexOf(String str) {
            return this.headerStr.indexOf(str);
        }

        public String toString() {
            return this.headerStr;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o != null && o instanceof HeaderData && this.toString().equals(o.toString())) {
                result = true;
            }
            return result;
        }
    }

    private static class HeaderMatrix {
        private int colCount;
        private int rowCount;
        private int currRow;
        private HeaderData[][] headers;
        private String colspanIndicator;
        private boolean log = false;

        HeaderMatrix(String headerString, String headerDelim, String colspanIndicator) {
            if (headerDelim.length() != 1 || colspanIndicator.length() != 1) {
                throw new IllegalArgumentException("header delim and indicator must be one char");
            }
            if (headerDelim.equals(colspanIndicator)) {
                throw new IllegalArgumentException("Cannot use same delim for headers and col/row spanning");
            }
            this.colspanIndicator = colspanIndicator;
            StringBuffer buf = new StringBuffer(headerString);
            StringUtils.replace(buf, String.valueOf(headerDelim) + headerDelim, String.valueOf(headerDelim) + " " + headerDelim);
            headerString = buf.toString();
            StringTokenizer st = new StringTokenizer(headerString, headerDelim);
            this.colCount = st.countTokens();
            this.headers = new HeaderData[20][this.colCount];
            int col = 0;
            while (st.hasMoreTokens()) {
                this.headers[this.currRow][col++] = new HeaderData(st.nextToken(), colspanIndicator);
            }
            boolean isAnotherRunNeeded = true;
            boolean isRowAdded = false;
            while (isAnotherRunNeeded) {
                isRowAdded = false;
                col = 0;
                while (col < this.colCount) {
                    HeaderData hd = this.headers[this.currRow][col];
                    if (hd != null && hd.indexOf(colspanIndicator) > -1) {
                        String potHeader = hd.getPotHeader();
                        if (col < this.colCount - 1 && this.headers[this.currRow][col + 1].startsWith(potHeader)) {
                            int followingCol = col;
                            while (followingCol < this.colCount) {
                                HeaderData hd2 = this.headers[this.currRow][followingCol];
                                if (hd2 == null || !hd2.startsWith(potHeader) || !hd2.hasRest(potHeader)) break;
                                if (this.log) {
                                    System.out.println("row " + this.currRow + " col:" + followingCol + " get Rest");
                                }
                                this.headers[this.currRow + 1][followingCol] = hd2.getRest(potHeader);
                                hd2.cut(potHeader);
                                isRowAdded = true;
                                col = followingCol++;
                            }
                        }
                    }
                    ++col;
                }
                if (isRowAdded) {
                    ++this.currRow;
                    continue;
                }
                isAnotherRunNeeded = false;
            }
            this.updateRowCount();
        }

        private void updateRowCount() {
            int i2 = 0;
            while (i2 < this.headers.length) {
                int i22 = 0;
                while (i22 < this.colCount) {
                    if (this.headers[i2][i22] != null) {
                        ++this.rowCount;
                        break;
                    }
                    ++i22;
                }
                ++i2;
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            int row = 0;
            while (row < this.rowCount) {
                result.append("<tr>");
                HeaderData lastHeader = new HeaderData("dummyColForCompare", this.colspanIndicator);
                int col = 0;
                while (col < this.colCount) {
                    if (this.headers[row][col] != null && !this.headers[row][col].equals(lastHeader)) {
                        lastHeader = this.headers[row][col];
                        int colspan = this.getColSpan(row, col);
                        String scope = "col";
                        if (colspan > 1) {
                            scope = "colgroup";
                        }
                        result.append("<th class=\"header\" scope=\"" + scope + "\"");
                        int rowspan = this.getRowSpan(row, col);
                        if (rowspan > 1) {
                            result.append(" rowspan=" + rowspan);
                        }
                        if (colspan > 1) {
                            result.append(" colspan=" + colspan);
                        }
                        result.append(">");
                        result.append(lastHeader + "</th>");
                    }
                    ++col;
                }
                result.append("</tr>");
                ++row;
            }
            StringUtils.replace(result, "\n", "<p class='smallBreak'></p>");
            StringUtils.replace(result, this.colspanIndicator, " ");
            return result.toString();
        }

        public String toMultiheadersString() {
            StringBuffer result = new StringBuffer();
            int row = 0;
            while (row < this.rowCount) {
                result.append("<table-row>");
                HeaderData lastHeader = new HeaderData("dummyColForCompare", this.colspanIndicator);
                int col = 0;
                while (col < this.colCount) {
                    if (this.headers[row][col] != null && !this.headers[row][col].equals(lastHeader)) {
                        int colspan;
                        lastHeader = this.headers[row][col];
                        result.append("<table-cell ");
                        int rowspan = this.getRowSpan(row, col);
                        if (rowspan > 1) {
                            result.append(" column-number=\"" + (col + 1) + "\" number-rows-spanned=\"" + rowspan + "\"");
                        }
                        if ((colspan = this.getColSpan(row, col)) > 1) {
                            result.append(" column-number=\"" + (col + 1) + "\" number-columns-spanned=\"" + colspan + "\"");
                        }
                        result.append("><block>");
                        result.append(lastHeader + "</block></table-cell>");
                    }
                    ++col;
                }
                result.append("</table-row>");
                ++row;
            }
            StringUtils.replace(result, "\n", " ");
            StringUtils.replace(result, this.colspanIndicator, "x");
            return result.toString();
        }

        private int getColSpan(int row, int col) {
            int colspan = 1;
            int testcol = col + 1;
            while (testcol < this.colCount) {
                if (this.headers[row][testcol] == null || !this.headers[row][testcol].equals(this.headers[row][col])) break;
                ++colspan;
                ++testcol;
            }
            return colspan;
        }

        private int getRowSpan(int row, int col) {
            int followingRowCount = 0;
            int testrow = row + 1;
            int rowSpan = 0;
            while (testrow < this.rowCount) {
                if (this.headers[testrow][col] != null) {
                    ++followingRowCount;
                }
                ++testrow;
            }
            if (followingRowCount == 0) {
                rowSpan = this.rowCount - row;
            }
            return rowSpan;
        }
    }
}

