/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.superx.bin.SxJdbcClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class DoShutdown {
    Connection myDb;
    Statement st;
    DatabaseMetaData dbmd;
    boolean done = false;
    String delim = "\t";
    String header = "false";
    String outFormat = "txt";
    String logfile = "../conf/logging.properties";
    String tabelle = "";
    String dbpropfile = "../conf/db.properties";
    String outfile = "";
    Logger logger = Logger.getLogger(DoShutdown.class.toString());
    private ExceptionHandler exceptionHandler = new ExceptionHandler(false);
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin DoShutdown -logger:<<Pfad zu logging.properties>> -dbproperties:<<Pfad zu den db.properties>> -cancel=<<Abbrechen bei Fehler (true/false)>>(optional)  \ndrei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties  erforderlich---------------------------------------------------";

    public DoShutdown(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String cancel = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent("-logger,-dbproperties");
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent("-logger")) {
            this.logfile = GetOpts.getValue("-logger");
        }
        if (GetOpts.isPresent("-dbproperties")) {
            this.dbpropfile = GetOpts.getValue("-dbproperties");
        }
        if (GetOpts.isPresent("-cancel")) {
            cancel = GetOpts.getValue("-cancel");
        }
        this.initLoggingSystem();
        boolean systemExitWanted = true;
        if (cancel.equalsIgnoreCase("false")) {
            systemExitWanted = false;
        }
        SxJdbcClient myClient = new SxJdbcClient(this.logger, this.dbpropfile, "checkpoint;");
        try {
            myClient.execute();
        }
        catch (SQLException e2) {
            this.logger.severe("Fehler beim sql-Script: " + e2.toString());
            this.exceptionHandler.handle(e2);
        }
        this.exceptionHandler.setExitWanted(systemExitWanted);
        myClient.sqlstmt = "shutdown immediately;";
        try {
            this.logger.info("shutdown erfolgreich");
            myClient.execute();
        }
        catch (SQLException e3) {
            if (systemExitWanted) {
                this.logger.severe("Fehler beim sql-Script: " + e3.toString());
            }
            this.exceptionHandler.handle(e3);
        }
    }

    private void initLoggingSystem() throws IOException, FileNotFoundException {
        File f2 = new File(this.logfile);
        if (!f2.exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        this.logfile = MyLogManager.getProperty(".level");
        this.logger.info("Using Loggging-Level " + this.logfile);
    }

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Java-Programm beendet einen hsqldb-Datenbankserver\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            DoShutdown test = new DoShutdown(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

