/*
 * Decompiled with CFR 0.152.
 */
package de.superx.applet;

import de.superx.applet.SxDate;
import de.superx.applet.SxSQLMetaData;
import de.superx.applet.SxTableModel;
import de.superx.common.SuperX_el;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SxJDBCAdapter
extends AbstractTableModel
implements SxTableModel {
    Connection connection;
    Properties db_props = null;
    boolean isClosed = true;
    boolean isEditable = false;
    Statement statement = null;
    ResultSet resultSet = null;
    String[] columnNames = new String[0];
    Class[] columnTpyes = new Class[0];
    Vector rows = new Vector();
    SxSQLMetaData metaData;
    NumberFormat nf = NumberFormat.getInstance();

    public void executeQuery(String query) throws SQLException {
        this.resultSet = this.statement.executeQuery(query);
        this.metaData = new SxSQLMetaData(new SuperX_el());
        int numberOfColumns = this.metaData.getColumnCount();
        this.columnNames = new String[numberOfColumns];
        int column = 0;
        while (column < numberOfColumns) {
            this.columnNames[column] = this.metaData.getColumnLabel(column + 1);
            ++column;
        }
        this.rows = new Vector();
        while (this.resultSet.next()) {
            Vector<Object> newRow = new Vector<Object>();
            int i2 = 0;
            while (i2 < this.getColumnCount()) {
                newRow.addElement(this.resultSet.getObject(i2 + 1));
                ++i2;
            }
            this.rows.addElement(newRow);
        }
        this.fireTableChanged(null);
    }

    public void cancel(String url, String user, String passwd) throws Exception {
        try {
            System.err.println("Cancel statement");
            this.statement.cancel();
        }
        catch (Exception e2) {
            System.err.println("Error canceling statement: " + e2);
        }
    }

    public void close() throws SQLException {
        try {
            System.err.println("Closing db connection");
            if (!this.isClosed) {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                this.connection.close();
                this.isClosed = true;
            }
        }
        catch (SQLException e2) {
            System.err.println("Error closing db connection: " + e2);
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            this.close();
            this.isClosed = true;
        }
        super.finalize();
    }

    @Override
    public String getColumnName(int column) {
        if (this.columnNames[column] != null) {
            return this.columnNames[column];
        }
        return "";
    }

    @Override
    public int getColumnSize(int column) {
        if (this.metaData == null) {
            return -1;
        }
        return this.metaData.getColumnDisplaySize(column + 1);
    }

    public Class getColumnClass(int column) {
        if (this.metaData == null) {
            return Object.class;
        }
        int type = this.metaData.getColumnType(column + 1);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 91: {
                return Date.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        return Object.class;
    }

    @Override
    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.isEditable) {
            return this.metaData.isWritable(column);
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)this.rows.elementAt(aRow);
        Object value = row.elementAt(aColumn);
        return this.dbRepresentation(aColumn, value, true);
    }

    @Override
    public Object getObjectAt(int aRow, int aColumn) {
        Vector row = (Vector)this.rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    private String dbRepresentation(int column, Object value, boolean isDecimalParsingWanted) {
        if (this.metaData == null) {
            return value.toString();
        }
        if (value == null || value.equals("")) {
            return " ";
        }
        int type = this.metaData.getColumnType(column + 1);
        int scale = this.metaData.getScale(column + 1);
        switch (type) {
            case 5: {
                int int_value = Short.MIN_VALUE;
                if (value instanceof Short) {
                    int_value = ((Short)value).shortValue();
                } else if (value instanceof Integer) {
                    int_value = (Integer)value;
                }
                if (int_value == Short.MIN_VALUE) {
                    return " ";
                }
                return value.toString();
            }
            case 4: {
                if (!(value instanceof Integer)) {
                    return value.toString();
                }
                if ((Integer)value == Integer.MIN_VALUE) {
                    return " ";
                }
                return value.toString();
            }
            case 8: {
                if (isDecimalParsingWanted) {
                    if (((Double)value).isNaN()) {
                        return " ";
                    }
                    this.nf.setMinimumFractionDigits(scale);
                    this.nf.setGroupingUsed(true);
                    if (scale > 3) {
                        this.nf.setMaximumFractionDigits(3);
                    }
                    return this.nf.format((Double)value);
                }
                return value.toString();
            }
            case 2: 
            case 3: {
                if (isDecimalParsingWanted) {
                    double db = ((BigDecimal)value).doubleValue();
                    this.nf.setGroupingUsed(true);
                    if (db == Double.NaN) {
                        return " ";
                    }
                    this.nf.setMaximumFractionDigits(2);
                    this.nf.setMinimumFractionDigits(2);
                    return this.nf.format(db);
                }
                return value.toString();
            }
            case -7: {
                return (Boolean)value != false ? "1" : "0";
            }
            case 91: {
                String str = SxDate.toString((Date)value);
                if (str.length() == 0) {
                    return " ";
                }
                return str;
            }
            case 93: {
                String str = ((Timestamp)value).toString();
                if (str.length() == 0) {
                    return " ";
                }
                return str;
            }
        }
        if (value.toString().length() == 0) {
            return " ";
        }
        return value.toString();
    }

    private Object tableRepresentation(int column, Object value) {
        if (value == null) {
            return "";
        }
        if (this.metaData == null) {
            return value;
        }
        int type = this.metaData.getColumnType(column + 1);
        switch (type) {
            case 5: {
                try {
                    return new Short(value.toString());
                }
                catch (NumberFormatException e2) {
                    System.err.println("tableRepresentation: ERROR: " + value.toString());
                    return "";
                }
            }
            case 4: {
                try {
                    return new Integer(value.toString());
                }
                catch (NumberFormatException e3) {
                    System.err.println("tableRepresentation: ERROR: " + value.toString());
                    return "";
                }
            }
            case 6: 
            case 8: {
                try {
                    Number new_number = this.nf.parse(value.toString());
                    Double new_double = new Double(new_number.doubleValue());
                    return new_double;
                }
                catch (ParseException e4) {
                    System.err.println("tableRepresentation: ERROR parse: Double=" + value.toString());
                    return "";
                }
            }
            case 3: {
                try {
                    Number new_number = this.nf.parse(value.toString());
                    BigDecimal new_dec = new BigDecimal(new_number.doubleValue());
                    return new_dec;
                }
                catch (ParseException e5) {
                    System.err.println("tableRepresentation: ERROR parse: BigDecimal=" + value.toString());
                    return "";
                }
            }
            case -7: {
                return new Boolean(value.toString());
            }
            case 91: {
                return SxDate.getDate(value.toString());
            }
            case 93: {
                return Timestamp.valueOf(value.toString());
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            String tableName = "info_usr";
            if (tableName == null) {
                System.err.println("Table name returned null.");
            }
            String colName = this.getColumnName(column);
            Object new_value = this.tableRepresentation(column, value);
            if (new_value == null) {
                throw new SQLException("conversion error");
            }
            System.err.println("column: " + colName + ", value: " + new_value);
            String query = "update " + tableName + " set " + colName + " = " + "'" + this.dbRepresentation(column, new_value, true) + "'" + " where ";
            int col = 0;
            while (col < this.getColumnCount()) {
                String columnName = this.getColumnName(col);
                if (!columnName.equals("")) {
                    if (col != 0) {
                        query = String.valueOf(query) + " and ";
                    }
                    query = String.valueOf(query) + columnName + " = " + "'" + this.getValueAt(row, col) + "'";
                }
                ++col;
            }
            System.err.println(query);
            System.err.println("Sending update to database");
            int rc = 1;
            if (rc != 1) {
                throw new SQLException("Update failed: " + rc);
            }
            System.err.println("Update succeeded");
            Vector dataRow = (Vector)this.rows.elementAt(row);
            dataRow.setElementAt(new_value, column);
        }
        catch (SQLException e2) {
            System.err.println("ERROR: " + e2);
        }
    }

    @Override
    public void setDataVector(Vector Rows, Vector Header2, Object Meta) {
        int numberOfColumns = Header2.size();
        this.columnNames = new String[numberOfColumns];
        this.rows = Rows;
        if (Meta instanceof SxSQLMetaData) {
            this.metaData = (SxSQLMetaData)Meta;
            int column = 0;
            while (column < numberOfColumns) {
                this.columnNames[column] = (String)Header2.elementAt(column);
                ++column;
            }
        } else {
            this.metaData = null;
        }
        this.fireTableChanged(null);
    }

    @Override
    public void setDataVector(Vector Rows) {
        this.rows = Rows;
        this.fireTableDataChanged();
    }

    @Override
    public Object getValueAt2(int aRow, int aColumn) {
        Vector row = (Vector)this.rows.elementAt(aRow);
        Object value = row.elementAt(aColumn);
        return this.dbRepresentation(aColumn, value, false);
    }
}

