/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.convention;

import java.lang.reflect.AnnotatedElement;
import java.util.List;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.hint.annotation.ReflectiveProcessor;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.bean.override.convention.TestBean;
import org.springframework.util.Assert;

class TestBeanReflectiveProcessor
implements ReflectiveProcessor {
    TestBeanReflectiveProcessor() {
    }

    public void registerReflectionHints(ReflectionHints hints, AnnotatedElement element) {
        MergedAnnotations.from((AnnotatedElement)element).get(TestBean.class).synthesize(MergedAnnotation::isPresent).map(TestBean::methodName).filter(methodName -> methodName.contains("#")).ifPresent(methodName -> {
            int indexOfHash = methodName.lastIndexOf(35);
            String className = methodName.substring(0, indexOfHash).trim();
            Assert.hasText((String)className, () -> "No class name present in fully-qualified method name: " + methodName);
            String methodNameToUse = methodName.substring(indexOfHash + 1).trim();
            Assert.hasText((String)methodNameToUse, () -> "No method name present in fully-qualified method name: " + methodName);
            hints.registerType(TypeReference.of((String)className), builder -> builder.withMethod(methodNameToUse, List.of(), ExecutableMode.INVOKE));
        });
    }
}

