/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping.event;

import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.mapping.event.AbstractRelationalEvent;
import org.springframework.data.relational.core.mapping.event.Identifier;
import org.springframework.data.relational.core.mapping.event.WithAggregateChange;
import org.springframework.data.relational.core.mapping.event.WithId;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class RelationalDeleteEvent<E>
extends AbstractRelationalEvent<E>
implements WithId<E>,
WithAggregateChange<E> {
    private static final long serialVersionUID = -8071323168471611098L;
    private final Identifier id;
    @Nullable
    private final E entity;
    private final AggregateChange<E> change;

    RelationalDeleteEvent(Identifier id, @Nullable E entity, AggregateChange<E> change) {
        super(id);
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(change, (String)"Change must not be null");
        this.id = id;
        this.entity = entity;
        this.change = change;
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    @Override
    @Nullable
    public E getEntity() {
        return this.entity;
    }

    @Override
    public AggregateChange<E> getAggregateChange() {
        return this.change;
    }

    @Override
    public Class<E> getType() {
        return this.change.getEntityType();
    }
}

