/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping.schema;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.annotation.Id;
import org.springframework.data.jdbc.core.mapping.schema.Column;
import org.springframework.data.jdbc.core.mapping.schema.DefaultSqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.SqlTypeMapping;
import org.springframework.data.jdbc.core.mapping.schema.Table;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;

record Tables(List<Table> tables) {
    public static Tables from(RelationalMappingContext context) {
        return Tables.from(context.getPersistentEntities().stream(), new DefaultSqlTypeMapping(), null);
    }

    public static Tables from(Stream<? extends RelationalPersistentEntity<?>> persistentEntities, SqlTypeMapping sqlTypeMapping, @Nullable String defaultSchema) {
        List<Table> tables = persistentEntities.filter(it -> it.isAnnotationPresent(org.springframework.data.relational.core.mapping.Table.class)).map(entity -> {
            Table table = new Table(defaultSchema, entity.getTableName().getReference());
            LinkedHashSet identifierColumns = new LinkedHashSet();
            entity.getPersistentProperties(Id.class).forEach(identifierColumns::add);
            for (RelationalPersistentProperty property : entity) {
                if (property.isEntity() && !property.isEmbedded()) continue;
                String columnType = sqlTypeMapping.getRequiredColumnType(property);
                Column column = new Column(property.getColumnName().getReference(), sqlTypeMapping.getColumnType(property), sqlTypeMapping.isNullable(property), identifierColumns.contains(property));
                table.columns().add(column);
            }
            return table;
        }).collect(Collectors.toList());
        return new Tables(tables);
    }

    public static Tables empty() {
        return new Tables(Collections.emptyList());
    }
}

