/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.mapping;

import java.sql.SQLType;
import java.util.Objects;
import org.springframework.lang.Nullable;

public class JdbcValue {
    private final Object value;
    private final SQLType jdbcType;

    protected JdbcValue(@Nullable Object value, @Nullable SQLType jdbcType) {
        this.value = value;
        this.jdbcType = jdbcType;
    }

    public static JdbcValue of(@Nullable Object value, @Nullable SQLType jdbcType) {
        return new JdbcValue(value, jdbcType);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public SQLType getJdbcType() {
        return this.jdbcType;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcValue jdbcValue = (JdbcValue)o;
        return Objects.equals(this.value, jdbcValue.value) && this.jdbcType == jdbcValue.jdbcType;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.jdbcType);
    }
}

