/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.jdbc.core.convert.ResultSetAccessor;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;

class JdbcPropertyValueProvider
implements PropertyValueProvider<RelationalPersistentProperty> {
    private final AggregatePath basePath;
    private final ResultSetAccessor resultSet;

    JdbcPropertyValueProvider(AggregatePath basePath, ResultSetAccessor resultSet) {
        this.resultSet = resultSet;
        this.basePath = basePath;
    }

    public <T> T getPropertyValue(RelationalPersistentProperty property) {
        return (T)this.resultSet.getObject(this.getColumnName(property));
    }

    public boolean hasProperty(RelationalPersistentProperty property) {
        return this.resultSet.hasValue(this.getColumnName(property));
    }

    private String getColumnName(RelationalPersistentProperty property) {
        AggregatePath.ColumnInfo columnInfo = this.basePath.append(property).getColumnInfo();
        return columnInfo.alias().getReference();
    }

    public JdbcPropertyValueProvider extendBy(RelationalPersistentProperty property) {
        return new JdbcPropertyValueProvider(this.basePath.append(property), this.resultSet);
    }
}

