/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.Collection;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;

public class MetaDataInstanceFactory {
    public static final String DEFAULT_JOB_NAME = "job";
    public static final long DEFAULT_JOB_INSTANCE_ID = 12L;
    public static final long DEFAULT_JOB_EXECUTION_ID = 123L;
    public static final String DEFAULT_STEP_NAME = "step";
    public static final long DEFAULT_STEP_EXECUTION_ID = 1234L;

    public static JobInstance createJobInstance(String jobName, Long instanceId) {
        return new JobInstance(instanceId, jobName);
    }

    public static JobInstance createJobInstance() {
        return new JobInstance(Long.valueOf(12L), DEFAULT_JOB_NAME);
    }

    public static JobExecution createJobExecution() {
        return MetaDataInstanceFactory.createJobExecution(123L);
    }

    public static JobExecution createJobExecution(Long executionId) {
        return MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, executionId);
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId) {
        return MetaDataInstanceFactory.createJobExecution(jobName, instanceId, executionId, new JobParameters());
    }

    public static JobExecution createJobExecution(String jobName, Long instanceId, Long executionId, JobParameters jobParameters) {
        return new JobExecution(MetaDataInstanceFactory.createJobInstance(jobName, instanceId), executionId, jobParameters);
    }

    public static StepExecution createStepExecution() {
        return MetaDataInstanceFactory.createStepExecution(DEFAULT_STEP_NAME, 1234L);
    }

    public static StepExecution createStepExecution(String stepName, Long executionId) {
        return MetaDataInstanceFactory.createStepExecution(MetaDataInstanceFactory.createJobExecution(), stepName, executionId);
    }

    public static StepExecution createStepExecution(JobExecution jobExecution, String stepName, Long executionId) {
        StepExecution stepExecution = jobExecution.createStepExecution(stepName);
        stepExecution.setId(executionId);
        return stepExecution;
    }

    public static JobExecution createJobExecutionWithStepExecutions(Long executionId, Collection<String> stepNames) {
        JobExecution jobExecution = MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, executionId);
        Long stepExecutionId = 1234L;
        for (String stepName : stepNames) {
            MetaDataInstanceFactory.createStepExecution(jobExecution, stepName, stepExecutionId);
            Long l = stepExecutionId;
            stepExecutionId = stepExecutionId + 1L;
        }
        return jobExecution;
    }

    public static StepExecution createStepExecution(JobParameters jobParameters, ExecutionContext executionContext) {
        StepExecution stepExecution = MetaDataInstanceFactory.createStepExecution(jobParameters);
        stepExecution.setExecutionContext(executionContext);
        return stepExecution;
    }

    public static StepExecution createStepExecution(JobParameters jobParameters) {
        JobExecution jobExecution = MetaDataInstanceFactory.createJobExecution(DEFAULT_JOB_NAME, 12L, 123L, jobParameters);
        return jobExecution.createStepExecution(DEFAULT_STEP_NAME);
    }

    public static StepExecution createStepExecution(ExecutionContext executionContext) {
        StepExecution stepExecution = MetaDataInstanceFactory.createStepExecution();
        stepExecution.setExecutionContext(executionContext);
        return stepExecution;
    }
}

