/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping.display.helper;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.display.MappingJTree;
import de.werum.sis.mapping.display.helper.MappingDisplayHelper;
import de.werum.sis.mapping.item.MappingContainer;
import de.werum.sis.mapping.item.assignment.AssignmentStore;
import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import de.werum.sis.mapping.item.mappingelement.MappingElementLink;
import de.werum.sis.mapping.item.tree.MappingTreeModel;
import de.werum.sis.mapping.item.tree.MappingTreeNode;
import de.werum.sis.mapping.util.MathHelper;
import de.werum.sis.mapping.util.PointXY;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.swing.tree.TreePath;

public class MappingJTreeDisplayHelper
extends MappingDisplayHelper {
    private Map leftKeyIndex_ = null;
    private Map rightKeyIndex_ = null;
    private MappingJTree leftStructure_ = null;
    private MappingJTree rightStructure_ = null;
    private boolean modifyAnchor_ = true;
    private final int ANCHOR_NOKEY = 0;
    private final int ANCHOR_UNMATCHED = 10;
    private final int ANCHOR_MATCHED = 20;
    private final int ANCHOR_MATCHEDCHILD = 30;
    private final int ANCHOR_DEFAULT = 10;
    private int leftRowHeight_ = 19;
    private int leftRowCounter_ = 0;
    private int rightRowHeight_ = 19;
    private int rightRowCounter_ = 0;
    private int sideMargin_ = 5;
    private int assignmentWidth_ = 80;
    private boolean refreshAssignmentCoordinates_ = true;

    public MappingJTreeDisplayHelper() {
    }

    public MappingJTreeDisplayHelper(MappingContainer mapping) {
        super(mapping);
    }

    public MappingJTreeDisplayHelper(SortedMap left, SortedMap right) {
        super(left, right);
    }

    public MappingJTreeDisplayHelper(SortedMap left, SortedMap right, AssignmentStore assignment, boolean validateassignment) throws InvalidAssignmentDataException {
        super(left, right, assignment, validateassignment);
    }

    public void setLeftStructure(MappingJTree left) {
        this.leftStructure_ = left;
        if (this.getLeftStructure() != null) {
            this.setLeftKeyIndex(this.getLeftStructure().getIndexForKeys());
            this.setLeftRowCounter(this.getLeftStructure().getRowCount());
        } else {
            this.setLeftKeyIndex(null);
            this.setLeftRowCounter(0);
        }
    }

    protected MappingJTree getLeftStructure() {
        return this.leftStructure_;
    }

    public void setRightStructure(MappingJTree right) {
        this.rightStructure_ = right;
        if (this.getRightStructure() != null) {
            this.setRightKeyIndex(this.getRightStructure().getIndexForKeys());
            this.setRightRowCounter(this.getRightStructure().getRowCount());
        } else {
            this.setRightKeyIndex(null);
            this.setRightRowCounter(0);
        }
    }

    protected MappingJTree getRightStructure() {
        return this.rightStructure_;
    }

    public int getAnchorTopMargin(int rowheight) {
        return rowheight / 2;
    }

    public int getLeftRowHeight() {
        return this.leftRowHeight_;
    }

    public void setLeftRowHeight(int rowheight) {
        if (this.leftRowHeight_ != rowheight) {
            this.setRefreshAssignmentCoordinates(true);
        }
        this.leftRowHeight_ = rowheight;
    }

    public int getRightRowHeight() {
        return this.rightRowHeight_;
    }

    public void setRightRowHeight(int rowheight) {
        if (this.rightRowHeight_ != rowheight) {
            this.setRefreshAssignmentCoordinates(true);
        }
        this.rightRowHeight_ = rowheight;
    }

    public int getSideMargin() {
        return this.sideMargin_;
    }

    public void setSideMargin(int sideMargin) {
        this.sideMargin_ = sideMargin;
    }

    public void setAssignmentWidth(int assignmentWidth) {
        if (this.assignmentWidth_ != assignmentWidth) {
            this.setRefreshAssignmentCoordinates(true);
        }
        this.assignmentWidth_ = assignmentWidth;
    }

    public void setModifyAnchor(boolean newvalue) {
        if (this.modifyAnchor_ != newvalue) {
            this.modifyAnchor_ = newvalue;
            this.setRefreshAssignmentCoordinates(true);
        }
    }

    public void setRefreshAssignmentCoordinates(boolean refresh) {
        this.refreshAssignmentCoordinates_ = refresh;
    }

    private Map getRightKeyIndex() {
        return this.rightKeyIndex_;
    }

    private void setRightKeyIndex(Map sourceKeyIndex) {
        this.rightKeyIndex_ = sourceKeyIndex;
    }

    private Map getLeftKeyIndex() {
        return this.leftKeyIndex_;
    }

    private void setLeftKeyIndex(Map targetKeyIndex) {
        this.leftKeyIndex_ = targetKeyIndex;
    }

    private void setRightRowCounter(int numOfRows) {
        if (this.rightRowCounter_ != numOfRows) {
            this.setRefreshAssignmentCoordinates(true);
        }
        this.rightRowCounter_ = numOfRows;
    }

    private void setLeftRowCounter(int numOfRows) {
        if (this.leftRowCounter_ != numOfRows) {
            this.setRefreshAssignmentCoordinates(true);
        }
        this.leftRowCounter_ = numOfRows;
    }

    protected void refreshAssignmentCoordinates() {
        if (this.refreshAssignmentCoordinates_) {
            this.assignmentCoordinates_ = new ArrayList();
            Iterator iter = this.getMapping().getAssignment().getAssignmentValues().iterator();
            while (iter.hasNext()) {
                MappingElementLink asak = (MappingElementLink)iter.next();
                this.assignmentCoordinates_.add(new MappingDisplayHelper.AssignmentCoordinates(new PointXY(this.getSideMargin(), this.getAnchorTopMargin(this.leftRowHeight_) + this.getIndex(this.getLeftKeyIndex(), asak.getLeftKey()) * this.leftRowHeight_), new PointXY(this.assignmentWidth_ - this.getSideMargin(), this.getAnchorTopMargin(this.rightRowHeight_) + this.getIndex(this.getRightKeyIndex(), asak.getRightKey()) * this.rightRowHeight_), asak.getLeftKey(), asak.getRightKey()));
            }
        }
        this.setRefreshAssignmentCoordinates(false);
    }

    private int getIndex(Map keyIndexMap, String key) {
        if (keyIndexMap != null && keyIndexMap.containsKey(key)) {
            return (Integer)keyIndexMap.get(key);
        }
        return -1;
    }

    public List getAssignment(PointXY point, int maxdistance) {
        ArrayList<Object> elementlinklist = new ArrayList<Object>();
        int _maxdistance = maxdistance;
        if (point.X <= this.getSideMargin()) {
            _maxdistance = this.getLeftRowHeight() / 2 - 1;
        } else if (point.X >= this.assignmentWidth_ - this.getSideMargin()) {
            _maxdistance = this.getRightRowHeight() / 2 - 1;
        }
        Iterator iter = this.assignmentCoordinates_.iterator();
        while (iter.hasNext()) {
            MappingDisplayHelper.AssignmentCoordinates asc = (MappingDisplayHelper.AssignmentCoordinates)iter.next();
            if (!MathHelper.isInRange(asc.P1, asc.P2, point, _maxdistance)) continue;
            elementlinklist.add(this.getMapping().getAssignment().get(asc.assignmentKeyP1, asc.assignmentKeyP2));
        }
        if (elementlinklist.size() == 0) {
            Logger.getInstance().log(40, (Object)"getAssignment", "NO assignment found");
            return null;
        }
        Logger.getInstance().log(40, (Object)"getAssignment", elementlinklist.size() + " assignment(s) found");
        return elementlinklist;
    }

    public void paintAssignments(Graphics g) {
        this.refreshAssignmentCoordinates();
        super.paintAssignments(g);
    }

    public void paintAnchors(Graphics g) {
        int index;
        int y = 0;
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, this.getSideMargin(), this.leftRowCounter_ * this.getLeftRowHeight() + 1);
        block12: for (index = 0; index < this.leftRowCounter_; ++index) {
            y = this.getAnchorTopMargin(this.getLeftRowHeight()) + index * this.getLeftRowHeight();
            switch (this.checkLeftAnchor(this.getLeftStructure(), this.getLeftModel(), this.getMapping().getLeftAssignedKeys(), index)) {
                case 10: {
                    g.setColor(Color.black);
                    g.drawRect(0, y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.white);
                    g.fillRect(1, y - 1, this.getSideMargin() - 2, 3);
                    continue block12;
                }
                case 20: {
                    g.setColor(Color.black);
                    g.drawRect(0, y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.black);
                    g.fillRect(1, y - 1, this.getSideMargin() - 2, 3);
                    continue block12;
                }
                case 30: {
                    g.setColor(Color.black);
                    g.drawRect(0, y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.lightGray);
                    g.fillRect(1, y - 1, this.getSideMargin() - 2, 3);
                    continue block12;
                }
                case 0: {
                    g.setColor(Color.black);
                    g.drawRect(0, y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.white);
                    g.fillRect(1, y - 1, this.getSideMargin() - 2, 3);
                    g.setColor(Color.black);
                    g.drawLine(0, y + 2, this.getSideMargin() - 1, y - 2);
                }
            }
        }
        g.setColor(Color.lightGray);
        g.fillRect(this.assignmentWidth_ - this.getSideMargin(), 0, this.getSideMargin(), this.rightRowCounter_ * this.getRightRowHeight() + 1);
        g.setColor(Color.black);
        block13: for (index = 0; index < this.rightRowCounter_; ++index) {
            y = this.getAnchorTopMargin(this.getRightRowHeight()) + index * this.getRightRowHeight();
            switch (this.checkLeftAnchor(this.getRightStructure(), this.getRightModel(), this.getMapping().getRightAssignedKeys(), index)) {
                case 10: {
                    g.setColor(Color.black);
                    g.drawRect(this.assignmentWidth_ - this.getSideMargin(), y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.white);
                    g.fillRect(this.assignmentWidth_ - this.getSideMargin() + 1, y - 1, this.getSideMargin() - 2, 3);
                    continue block13;
                }
                case 20: {
                    g.setColor(Color.black);
                    g.drawRect(this.assignmentWidth_ - this.getSideMargin(), y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.black);
                    g.fillRect(this.assignmentWidth_ - this.getSideMargin() + 1, y - 1, this.getSideMargin() - 2, 3);
                    continue block13;
                }
                case 30: {
                    g.setColor(Color.black);
                    g.drawRect(this.assignmentWidth_ - this.getSideMargin(), y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.lightGray);
                    g.fillRect(this.assignmentWidth_ - this.getSideMargin() + 1, y - 1, this.getSideMargin() - 2, 3);
                    continue block13;
                }
                case 0: {
                    g.setColor(Color.black);
                    g.drawRect(this.assignmentWidth_ - this.getSideMargin(), y - 2, this.getSideMargin() - 1, 4);
                    g.setColor(Color.white);
                    g.fillRect(this.assignmentWidth_ - this.getSideMargin() + 1, y - 1, this.getSideMargin() - 2, 3);
                    g.setColor(Color.black);
                    g.drawLine(this.assignmentWidth_ - this.getSideMargin(), y + 2, this.getSideMargin() - 1, y - 2);
                }
            }
        }
    }

    private int checkLeftAnchor(MappingJTree actualview, MappingTreeModel actualmodel, List allassignedkeys, int index) {
        MappingTreeNode modelnode;
        if (!this.modifyAnchor_) {
            return 10;
        }
        TreePath jtreepath = actualview.getPathForRow(index);
        if (jtreepath != null && (modelnode = actualmodel.getMappingTreeNode(jtreepath)) != null) {
            if (modelnode.getMappingElementObject() != null && modelnode.getMappingElementObject().isHasKey() && allassignedkeys.contains(modelnode.getMappingElementObject().getKey())) {
                return 20;
            }
            Iterator iterator = modelnode.getAllChildNodes().iterator();
            while (iterator.hasNext()) {
                MappingTreeNode tempnode = (MappingTreeNode)iterator.next();
                if (tempnode == null || tempnode.getMappingElementObject() == null || !tempnode.getMappingElementObject().isHasKey() || !allassignedkeys.contains(tempnode.getMappingElementObject().getKey())) continue;
                return 30;
            }
            if (modelnode.isMappable() || modelnode.hasMappableChildNodes()) {
                return 10;
            }
        }
        return 0;
    }
}

