/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.mapping;

import de.werum.sis.mapping.debug.Logger;
import de.werum.sis.mapping.display.AssignmentJPanel;
import de.werum.sis.mapping.display.MappingJTree;
import de.werum.sis.mapping.display.helper.GlobalAttributes;
import de.werum.sis.mapping.display.helper.MappingJTreeDisplayHelper;
import de.werum.sis.mapping.item.MappingContainer;
import de.werum.sis.mapping.item.assignment.InvalidAssignmentDataException;
import de.werum.sis.mapping.item.mappingelement.MappingElementLink;
import de.werum.sis.mapping.item.mappingelement.MappingElementLinkImpl;
import de.werum.sis.mapping.item.mappingelement.MappingElementObject;
import de.werum.sis.mapping.item.tree.MappingTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class MappingDisplay
extends JPanel {
    private static final long serialVersionUID = 3544395811656970291L;
    private MappingJTree leftJtree_ = null;
    private AssignmentJPanel assignment_ = null;
    private MappingJTree rightJtree_ = null;
    protected MappingJTreeDisplayHelper _mappingJTDH = null;
    private boolean executeLeftJTreeSelectionListener_ = true;
    private boolean executeRightJTreeSelectionListener_ = true;
    private boolean ctrlIsDown_ = false;
    private MappingElementObject assignmentCandidate_ = null;
    private TreePath assignmentCandidatePath_ = null;
    private MappingJTree lastEnteredTree_ = null;
    private JLabel dragLabel = null;
    private JDialog dragPane = null;

    public MappingDisplay() {
        BorderLayout _layout = new BorderLayout();
        super.setLayout(_layout);
        super.setBackground(GlobalAttributes.WHITE);
        try {
            this.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMapping(MappingContainer mapping) {
        try {
            mapping.validate();
        }
        catch (InvalidAssignmentDataException iex) {
            Logger.getInstance().error(this, iex);
        }
        this._mappingJTDH.setMapping(mapping);
        this.leftJtree_.setModel(MappingJTree.buildTreeModel(this._mappingJTDH.getLeftTreePath()));
        this.rightJtree_.setModel(MappingJTree.buildTreeModel(this._mappingJTDH.getRightTreePath()));
        this.expand(this.leftJtree_, (MappingTreeNode)this.leftJtree_.getModel().getRoot());
        this.expand(this.rightJtree_, (MappingTreeNode)this.rightJtree_.getModel().getRoot());
        this._mappingJTDH.setLeftStructure(this.leftJtree_);
        this._mappingJTDH.setRightStructure(this.rightJtree_);
        this._mappingJTDH.initLeftModel(MappingJTree.buildTreeModel(this._mappingJTDH.getLeftTreePath()));
        this._mappingJTDH.initRightModel(MappingJTree.buildTreeModel(this._mappingJTDH.getRightTreePath()));
    }

    public void init() throws Exception {
        this._mappingJTDH = new MappingJTreeDisplayHelper();
        BuildJTreeMouseListener bamlist = new BuildJTreeMouseListener();
        this.leftJtree_ = new MappingJTree(this._mappingJTDH.getLeftTreePath());
        this.leftJtree_.setRowHeight(this._mappingJTDH.getLeftRowHeight());
        this.leftJtree_.setType(10);
        this.leftJtree_.setRootVisible(false);
        this.leftJtree_.expandAll();
        this.leftJtree_.addTreeExpansionListener(new MappingTreeExpansionListener());
        this.leftJtree_.addTreeSelectionListener(new LeftTreeSelectionListener());
        this.leftJtree_.addMouseListener(bamlist);
        this._mappingJTDH.setLeftStructure(this.leftJtree_);
        this.rightJtree_ = new MappingJTree(this._mappingJTDH.getRightTreePath());
        this.rightJtree_.setRowHeight(this._mappingJTDH.getRightRowHeight());
        this.rightJtree_.setType(20);
        this.rightJtree_.setRootVisible(false);
        this.rightJtree_.expandAll();
        this.rightJtree_.addTreeExpansionListener(new MappingTreeExpansionListener());
        this.rightJtree_.addTreeSelectionListener(new RightTreeSelectionListener());
        this.rightJtree_.addMouseListener(bamlist);
        this._mappingJTDH.setRightStructure(this.rightJtree_);
        this.assignment_ = new AssignmentJPanel(this._mappingJTDH);
        this.assignment_.setMinimumSize(new Dimension(50, 0));
        this.assignment_.setPreferredSize(new Dimension(50, 0));
        this.assignment_.setBackground(GlobalAttributes.WHITE);
        this.assignment_.addMouseMotionListener(new AssignmentAnchorMouseMotionListener());
        this.dragLabel = new JLabel();
        this.dragLabel.setOpaque(true);
        this.dragLabel.setBackground(SystemColor.info);
        this.dragLabel.setForeground(SystemColor.infoText);
        this.dragLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0, SystemColor.controlHighlight, SystemColor.controlShadow), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.dragPane = new JDialog();
        this.dragPane.setUndecorated(true);
        this.dragPane.setContentPane(this.dragLabel);
        this.dragPane.setFocusableWindowState(false);
        DragMouseListener dml = new DragMouseListener();
        this.leftJtree_.addMouseMotionListener(dml);
        this.rightJtree_.addMouseMotionListener(dml);
        super.add((Component)this.leftJtree_, "West");
        super.add((Component)this.assignment_, "Center");
        super.add((Component)this.rightJtree_, "East");
    }

    public MappingContainer getMapping() {
        return this.assignment_.getMappingJTreeDisplayHelper().getMapping();
    }

    protected void updateAssignment() {
        if (this.lastEnteredTree_ != null && this.lastEnteredTree_.getType() == 10) {
            this.assignment_.getMappingJTreeDisplayHelper().setLeftStructure(this.leftJtree_);
        } else if (this.lastEnteredTree_ != null && this.lastEnteredTree_.getType() == 20) {
            this.assignment_.getMappingJTreeDisplayHelper().setRightStructure(this.rightJtree_);
        }
        this.assignment_.getMappingJTreeDisplayHelper().setRefreshAssignmentCoordinates(true);
        this.assignment_.repaint();
    }

    private boolean isControlDown(MouseEvent e) {
        this.ctrlIsDown_ = e.isControlDown();
        return this.ctrlIsDown_;
    }

    protected JMenuItem buildRemoveMenuItem() {
        JMenuItem _menuItem = new JMenuItem("aktuelles Element");
        _menuItem.setActionCommand("ELEMENT");
        _menuItem.addActionListener(new RemoveElementTreeViewActionListener());
        return _menuItem;
    }

    protected JMenuItem buildRemoveAllUnMatchedMenuItem() {
        JMenuItem _menuItem = new JMenuItem("alle unverkn\u00fcpften Endelemente");
        _menuItem.setActionCommand("UNASSIGNED");
        _menuItem.addActionListener(new RemoveElementTreeViewActionListener());
        return _menuItem;
    }

    protected JMenuItem buildRemoveAllMatchedMenuItem() {
        JMenuItem _menuItem = new JMenuItem("alle verkn\u00fcpften Endelemente");
        _menuItem.setActionCommand("ASSIGNED");
        _menuItem.addActionListener(new RemoveElementTreeViewActionListener());
        return _menuItem;
    }

    protected JMenuItem buildReinitializeTree() {
        JMenuItem _menuItem = new JMenuItem("Wiederherstellen");
        _menuItem.addActionListener(new ReinitializeTreeViewActionListener());
        return _menuItem;
    }

    protected JMenuItem buildChangeRuleMenuItem(String actioncommand) {
        JMenuItem _menuItem = new JMenuItem("Bearbeiten");
        _menuItem.setActionCommand(actioncommand);
        _menuItem.addActionListener(new ChangeTreeRuleActionListener());
        return _menuItem;
    }

    private void expand(MappingJTree tree, MappingTreeNode node) {
        if (node.getMappingElementObject().isInitialExpanded()) {
            tree.expandNode(node);
            for (int childindex = 0; childindex < node.getChildCount(); ++childindex) {
                MappingTreeNode child = (MappingTreeNode)node.getChildAt(childindex);
                this.expand(tree, child);
            }
        } else {
            for (int childindex = 0; childindex < node.getChildCount(); ++childindex) {
                MappingTreeNode child = (MappingTreeNode)node.getChildAt(childindex);
                this.expand(tree, child);
            }
            TreePath path = new TreePath(node.getPath());
            tree.collapsePath(path);
        }
    }

    protected class AssignmentAnchorMouseMotionListener
    implements MouseMotionListener {
        protected AssignmentAnchorMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getY() > 0) {
                int _x = e.getX();
                int _y = e.getY();
                int _index = 0;
                if (_x > 0 && _x <= MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getSideMargin() + 2) {
                    _index = _y / MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getLeftRowHeight();
                    Logger.getInstance().debug("--mouse moved", " left " + _y + " index " + _index);
                    MappingDisplay.this.assignment_.setToolTipText(this.getName(MappingDisplay.this.leftJtree_, _index));
                } else if (_x <= MappingDisplay.this.assignment_.getWidth() && _x >= MappingDisplay.this.assignment_.getWidth() - MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getSideMargin() - 2) {
                    _index = _y / MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getRightRowHeight();
                    Logger.getInstance().debug("--mouse moved", " right " + _y + " index " + _index);
                    MappingDisplay.this.assignment_.setToolTipText(this.getName(MappingDisplay.this.rightJtree_, _index));
                } else {
                    MappingDisplay.this.assignment_.setToolTipText(null);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private String getName(MappingJTree tree, int index) {
            MappingElementObject _activ_meo;
            String _name = null;
            TreePath _path = tree.getPathForRow(index);
            if (_path != null && (MappingTreeNode)_path.getLastPathComponent() != null && (_activ_meo = ((MappingTreeNode)_path.getLastPathComponent()).getMappingElementObject()) != null && _activ_meo.isHasKey()) {
                _name = _activ_meo.getDisplayName();
            }
            return _name;
        }
    }

    protected class RightTreeSelectionListener
    implements TreeSelectionListener {
        protected RightTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!MappingDisplay.this.ctrlIsDown_) {
                if (MappingDisplay.this.executeRightJTreeSelectionListener_) {
                    MappingDisplay.this.executeLeftJTreeSelectionListener_ = false;
                    MappingDisplay.this.leftJtree_.setSelectionPaths(null);
                    this.markPath(e.getPath());
                    MappingDisplay.this.executeLeftJTreeSelectionListener_ = true;
                } else {
                    MappingDisplay.this.executeLeftJTreeSelectionListener_ = true;
                }
            }
        }

        private void markPath(TreePath path) {
            List meo_assignedkeys;
            MappingTreeNode mtn_selected;
            if (path != null && path.getLastPathComponent() != null && (mtn_selected = (MappingTreeNode)path.getLastPathComponent()) != null && mtn_selected.isUserObjectAMappingElementObject() && mtn_selected.getMappingElementObject().isHasKey() && (meo_assignedkeys = MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getAssignment().getAssignmentsForRight(mtn_selected.getMappingElementObject().getKey())) != null && meo_assignedkeys.size() > 0) {
                MappingDisplay.this.leftJtree_.selectNodes(meo_assignedkeys);
                MappingDisplay.this.updateAssignment();
            }
        }
    }

    protected class LeftTreeSelectionListener
    implements TreeSelectionListener {
        protected LeftTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (!MappingDisplay.this.ctrlIsDown_) {
                if (MappingDisplay.this.executeLeftJTreeSelectionListener_) {
                    MappingDisplay.this.executeRightJTreeSelectionListener_ = false;
                    MappingDisplay.this.rightJtree_.setSelectionPaths(null);
                    this.markPath(e.getPath());
                    MappingDisplay.this.updateAssignment();
                    MappingDisplay.this.executeRightJTreeSelectionListener_ = true;
                } else {
                    MappingDisplay.this.executeRightJTreeSelectionListener_ = true;
                }
            }
        }

        private void markPath(TreePath path) {
            List meo_assignedkeys;
            MappingTreeNode mtn_selected;
            if (path != null && path.getLastPathComponent() != null && (mtn_selected = (MappingTreeNode)path.getLastPathComponent()) != null && mtn_selected.isUserObjectAMappingElementObject() && mtn_selected.getMappingElementObject().isHasKey() && (meo_assignedkeys = MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getAssignment().getAssignmentsForLeft(mtn_selected.getMappingElementObject().getKey())) != null && meo_assignedkeys.size() > 0) {
                MappingDisplay.this.rightJtree_.selectNodes(meo_assignedkeys);
                MappingDisplay.this.updateAssignment();
            }
        }
    }

    protected class MappingTreeExpansionListener
    implements TreeExpansionListener {
        protected MappingTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            MappingDisplay.this.updateAssignment();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            MappingDisplay.this.updateAssignment();
        }
    }

    protected class ChangeTreeRuleActionListener
    implements ActionListener {
        protected ChangeTreeRuleActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Logger.getInstance().debug("--actionPerformed", " Change - A c t i o n " + e.getActionCommand());
            if (e.getActionCommand() != null && MappingDisplay.this.lastEnteredTree_ != null && MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping() != null && MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getMapMaker() != null) {
                switch (MappingDisplay.this.lastEnteredTree_.getType()) {
                    case 10: {
                        if (MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getLeft().get(e.getActionCommand()) == null) break;
                        Logger.getInstance().debug("-- TODO actionPerformed", " modify L rule for " + MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getLeft().get(e.getActionCommand()).toString());
                        MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getMapMaker().editLeftElement(MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getLeft().get(e.getActionCommand()));
                        break;
                    }
                    case 20: {
                        if (MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getRight().get(e.getActionCommand()) == null) break;
                        Logger.getInstance().debug("-- TODO actionPerformed", " modify R rule for " + MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getRight().get(e.getActionCommand()).toString());
                        MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getMapMaker().editRightElement(MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getRight().get(e.getActionCommand()));
                    }
                }
            }
        }
    }

    protected class ReinitializeTreeViewActionListener
    implements ActionListener {
        protected ReinitializeTreeViewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Logger.getInstance().debug("--actionPerformed", " Remove - A c t i o n " + e.getActionCommand());
            if (MappingDisplay.this.lastEnteredTree_ != null) {
                switch (MappingDisplay.this.lastEnteredTree_.getType()) {
                    case 10: {
                        MappingDisplay.this.leftJtree_.setModel(MappingJTree.buildTreeModel(MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getLeftTreePath()));
                        MappingDisplay.this.leftJtree_.expandAll();
                        MappingDisplay.this.leftJtree_.setSelectionPaths(null);
                        MappingDisplay.this.rightJtree_.setSelectionPaths(null);
                        MappingDisplay.this.updateAssignment();
                        break;
                    }
                    case 20: {
                        MappingDisplay.this.rightJtree_.setModel(MappingJTree.buildTreeModel(MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getRightTreePath()));
                        MappingDisplay.this.rightJtree_.expandAll();
                        MappingDisplay.this.leftJtree_.setSelectionPaths(null);
                        MappingDisplay.this.rightJtree_.setSelectionPaths(null);
                        MappingDisplay.this.updateAssignment();
                    }
                }
            }
        }
    }

    protected class RemoveElementTreeViewActionListener
    implements ActionListener {
        protected RemoveElementTreeViewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() != null) {
                Logger.getInstance().debug("--actionPerformed", " Remove - A c t i o n " + e.getActionCommand());
                if (e.getActionCommand().equals("UNASSIGNED")) {
                    if (MappingDisplay.this.lastEnteredTree_ != null) {
                        switch (MappingDisplay.this.lastEnteredTree_.getType()) {
                            case 10: {
                                MappingDisplay.this.lastEnteredTree_.remove(MappingDisplay.this.getMapping().getLeftUnassignedKeys());
                                MappingDisplay.this.updateAssignment();
                                break;
                            }
                            case 20: {
                                MappingDisplay.this.lastEnteredTree_.remove(MappingDisplay.this.getMapping().getRightUnassignedKeys());
                                MappingDisplay.this.updateAssignment();
                            }
                        }
                    }
                } else if (e.getActionCommand().equals("ASSIGNED")) {
                    if (MappingDisplay.this.lastEnteredTree_ != null) {
                        switch (MappingDisplay.this.lastEnteredTree_.getType()) {
                            case 10: {
                                MappingDisplay.this.lastEnteredTree_.remove(MappingDisplay.this.getMapping().getLeftAssignedKeys());
                                MappingDisplay.this.updateAssignment();
                                break;
                            }
                            case 20: {
                                MappingDisplay.this.lastEnteredTree_.remove(MappingDisplay.this.getMapping().getRightAssignedKeys());
                                MappingDisplay.this.updateAssignment();
                            }
                        }
                    }
                } else if (e.getActionCommand().equals("ELEMENT") && MappingDisplay.this.assignmentCandidatePath_.getLastPathComponent() != null) {
                    MappingDisplay.this.lastEnteredTree_.remove((MappingTreeNode)MappingDisplay.this.assignmentCandidatePath_.getLastPathComponent());
                    MappingDisplay.this.updateAssignment();
                }
            }
        }
    }

    protected class BuildJTreeMouseListener
    implements MouseListener {
        protected BuildJTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                MappingDisplay.this.assignmentCandidatePath_ = MappingDisplay.this.lastEnteredTree_.getClosestPathForLocation(e.getX(), e.getY());
                if (MappingDisplay.this.assignmentCandidatePath_ != null && MappingDisplay.this.assignmentCandidatePath_.getLastPathComponent() != null) {
                    MappingDisplay.this.lastEnteredTree_.setSelectionPaths(null);
                    MappingDisplay.this.lastEnteredTree_.addSelectionPath(MappingDisplay.this.assignmentCandidatePath_);
                    MappingElementObject _activ_meo = ((MappingTreeNode)MappingDisplay.this.assignmentCandidatePath_.getLastPathComponent()).getMappingElementObject();
                    if (_activ_meo != null) {
                        JPopupMenu _mainMPU = new JPopupMenu(_activ_meo.getDisplayName());
                        if (_activ_meo.isHasKey()) {
                            _mainMPU.add(MappingDisplay.this.buildChangeRuleMenuItem(_activ_meo.getKey()));
                        }
                        JMenu _subMenu = new JMenu("Ausblenden");
                        _subMenu.add(MappingDisplay.this.buildRemoveMenuItem());
                        _subMenu.add(MappingDisplay.this.buildRemoveAllUnMatchedMenuItem());
                        _subMenu.add(MappingDisplay.this.buildRemoveAllMatchedMenuItem());
                        _mainMPU.add(_subMenu);
                        if (MappingDisplay.this.lastEnteredTree_.hasRemovedElements()) {
                            _mainMPU.add(MappingDisplay.this.buildReinitializeTree());
                        }
                        _mainMPU.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            } else if (SwingUtilities.isLeftMouseButton(e)) {
                if (MappingDisplay.this.isControlDown(e)) {
                    Logger.getInstance().debug("baml", "l_clicked, ctrl down:start");
                    this.assign(e);
                } else {
                    Logger.getInstance().debug("baml", "l_clicked:start");
                    this.readAssignmentCandidate(e);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!MappingDisplay.this.isControlDown(e)) {
                this.readAssignmentCandidate(e);
                if (MappingDisplay.this.assignmentCandidatePath_ != null && MappingDisplay.this.assignmentCandidate_ != null) {
                    MappingDisplay.this.dragPane.setName("activated");
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Logger.getInstance().debug(this, " mouse released");
            if (!MappingDisplay.this.isControlDown(e)) {
                this.assign(e);
            }
            if (MappingDisplay.this.dragPane.isVisible()) {
                MappingDisplay.this.dragPane.setVisible(false);
                MappingDisplay.this.dragPane.setName(null);
            }
        }

        private void readAssignmentCandidate(MouseEvent e) {
            MappingDisplay.this.assignmentCandidate_ = null;
            MappingDisplay.this.assignmentCandidatePath_ = ((MappingJTree)e.getSource()).getClosestPathForLocation(e.getX(), e.getY());
            if (MappingDisplay.this.assignmentCandidatePath_ != null) {
                MappingDisplay.this.lastEnteredTree_.setSelectionPaths(null);
                MappingDisplay.this.lastEnteredTree_.addSelectionPath(MappingDisplay.this.assignmentCandidatePath_);
                MappingTreeNode assignmentCandidateNode_ = (MappingTreeNode)MappingDisplay.this.assignmentCandidatePath_.getLastPathComponent();
                if (assignmentCandidateNode_ != null && assignmentCandidateNode_.getMappingElementObject() != null && assignmentCandidateNode_.getMappingElementObject().isHasKey()) {
                    MappingDisplay.this.assignmentCandidate_ = assignmentCandidateNode_.getMappingElementObject();
                    if (MappingDisplay.this.assignmentCandidate_ != null) {
                        Logger.getInstance().debug(this, "pressed - chosen:" + MappingDisplay.this.assignmentCandidate_.getPath() + " - " + MappingDisplay.this.assignmentCandidate_.getKey());
                        MappingDisplay.this.dragLabel.setText(MappingDisplay.this.assignmentCandidate_.getDisplayName());
                        MappingDisplay.this.dragLabel.setIcon(MappingDisplay.this.assignmentCandidate_.getIcon());
                        MappingDisplay.this.dragPane.pack();
                    }
                }
            }
        }

        private void assign(MouseEvent e) {
            MappingElementObject _assignWith;
            TreePath _path;
            if (MappingDisplay.this.assignmentCandidate_ != null && !MappingDisplay.this.lastEnteredTree_.isType(MappingDisplay.this.assignmentCandidate_.getType()) && (_path = MappingDisplay.this.lastEnteredTree_.getClosestPathForLocation(e.getX(), e.getY())) != null && (MappingTreeNode)_path.getLastPathComponent() != null && (_assignWith = ((MappingTreeNode)_path.getLastPathComponent()).getMappingElementObject()).isHasKey()) {
                switch (MappingDisplay.this.assignmentCandidate_.getType()) {
                    case 10: {
                        this.buildAssignment(MappingDisplay.this.assignmentCandidate_, _assignWith);
                        MappingDisplay.this.leftJtree_.setSelectionPaths(null);
                        MappingDisplay.this.leftJtree_.addSelectionPath(MappingDisplay.this.assignmentCandidatePath_);
                        break;
                    }
                    case 20: {
                        this.buildAssignment(_assignWith, MappingDisplay.this.assignmentCandidate_);
                        MappingDisplay.this.rightJtree_.setSelectionPaths(null);
                        MappingDisplay.this.rightJtree_.addSelectionPath(MappingDisplay.this.assignmentCandidatePath_);
                        break;
                    }
                    default: {
                        Logger.getInstance().debug(this, "no assignment created");
                        MappingDisplay.this.assignmentCandidate_ = null;
                    }
                }
            }
        }

        private void buildAssignment(MappingElementObject leftObject, MappingElementObject rightObject) {
            MappingElementLink mel = null;
            if (MappingDisplay.this.getMapping().getMapMaker() == null) {
                mel = new MappingElementLinkImpl(leftObject.getKey(), rightObject.getKey());
            } else if (MappingDisplay.this.getMapping().getMapMaker().canMap(leftObject, rightObject)) {
                mel = MappingDisplay.this.getMapping().getMapMaker().getMappingElementLink(leftObject, rightObject);
            }
            if (mel != null) {
                if (!MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().getAssignment().containsKey(leftObject.getKey(), rightObject.getKey())) {
                    MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().getMapping().putAssignment(mel);
                    MappingDisplay.this.assignment_.getMappingJTreeDisplayHelper().setRefreshAssignmentCoordinates(true);
                    MappingDisplay.this.assignment_.repaint();
                    Logger.getInstance().debug(this, "keycombination created - " + mel.toString());
                } else {
                    Logger.getInstance().debug(this, "keycombination already exists - " + mel.toString());
                }
            } else {
                Logger.getInstance().debug(this, "Mapping Link = null -> target/source not mappable");
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MappingDisplay.this.lastEnteredTree_ = (MappingJTree)e.getSource();
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    protected class DragMouseListener
    implements MouseMotionListener {
        protected DragMouseListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!MappingDisplay.this.dragPane.isVisible() && MappingDisplay.this.dragPane.getName() != null && MappingDisplay.this.dragPane.getName().equals("activated")) {
                Point point = e.getPoint();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                MappingDisplay.this.dragPane.setLocation((int)point.getX(), (int)point.getY() + 16);
                MappingDisplay.this.dragPane.setVisible(true);
            } else if (MappingDisplay.this.dragPane.isVisible()) {
                Point point = e.getPoint();
                SwingUtilities.convertPointToScreen(point, e.getComponent());
                MappingDisplay.this.dragPane.setLocation((int)point.getX(), (int)point.getY() + 16);
                MappingDisplay.this.scrollRectToVisible(new Rectangle(e.getPoint()));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

