/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.testdriver;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XmlProcessingError;

public class StaticErrorCollector
extends StandardErrorReporter {
    private Set<String> errorCodes = new HashSet<String>();
    private boolean foundWarnings = false;
    private boolean madeEarlyExit = false;
    public XmlProcessingError lastError;

    protected void warning(XmlProcessingError exception) {
        this.foundWarnings = true;
        super.warning(exception);
    }

    protected void error(XmlProcessingError exception) {
        this.lastError = exception;
        this.addErrorCode(exception);
        super.error(exception);
    }

    private void addErrorCode(XmlProcessingError exception) {
        QName errorCode = exception.getErrorCode();
        if (errorCode != null) {
            String ns = errorCode.getNamespaceURI();
            String code = ns != null && !"http://www.w3.org/2005/xqt-errors".equals(ns) ? errorCode.getLocalName() : errorCode.getEQName();
            this.errorCodes.add(code);
        } else {
            this.errorCodes.add("error-with-no-error-code");
        }
    }

    public Set<String> getErrorCodes() {
        return this.errorCodes;
    }

    public boolean getFoundWarnings() {
        return this.foundWarnings;
    }

    public boolean isMadeEarlyExit() {
        return this.madeEarlyExit;
    }
}

