/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.svg;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.html.WebColors;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.print.PrintTranscoder;
import org.apache.commons.lang.StringUtils;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.dto.resultset.DataCell;
import org.saiku.web.svg.ReportData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfReport {
    private final ReportData section = new ReportData();
    private static final Logger log = LoggerFactory.getLogger(PdfReport.class);

    public byte[] pdf(CellDataSet c, String svg) {
        this.section.setRowBody(c.getCellSetBody());
        this.section.setRowHeader(c.getCellSetHeaders());
        Document document = new Document(PageSize.A4.rotate(), 0.0f, 0.0f, 30.0f, 10.0f);
        Color color = WebColors.getRGBColor((String)"#002266");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int dim = this.section.dimTab(c.getCellSetBody(), c.getCellSetHeaders());
        try {
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)baos);
            document.open();
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            Date date = new Date();
            document.setHeader(new HeaderFooter(new Phrase("Saiku Export - " + dateFormat.format(date) + " Page: "), null));
            ArrayList<ReportData.Section> rowGroups = this.section.section(c.getCellSetBody(), c.getCellSetHeaders(), 0, dim, null);
            this.populatePdf(document, rowGroups, dim, color, 0.0f);
            if (StringUtils.isNotBlank((String)svg)) {
                document.newPage();
                StringBuilder s1 = new StringBuilder(svg);
                if (!svg.startsWith("<svg xmlns=\"http://www.w3.org/2000/svg\" ")) {
                    s1.insert(s1.indexOf("<svg") + 4, " xmlns='http://www.w3.org/2000/svg'");
                }
                String t = "<?xml version='1.0' encoding='ISO-8859-1' standalone='no'?>" + s1.toString();
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                cb.concatCTM(1.0f, 0.0f, 0.0f, 1.0f, 36.0f, 0.0f);
                float width = document.getPageSize().getWidth() - 20.0f;
                float height = document.getPageSize().getHeight() - 20.0f;
                Graphics2D g2 = cb.createGraphics(width, height);
                PrintTranscoder prm = new PrintTranscoder();
                TranscoderInput ti = new TranscoderInput((Reader)new StringReader(t));
                prm.transcode(ti, null);
                PageFormat pg = new PageFormat();
                Paper pp = new Paper();
                pp.setSize(width, height);
                pp.setImageableArea(5.0, 5.0, width, height);
                pg.setPaper(pp);
                prm.print((Graphics)g2, pg, 0);
                g2.dispose();
                cb.restoreState();
            }
            document.close();
        }
        catch (DocumentException e) {
            log.error("Error creating PDF", (Throwable)e);
        }
        return baos.toByteArray();
    }

    private Color color(Color c, float percent) {
        Color end = new Color(255, 255, 255);
        int r = c.getRed() + (int)(percent * (float)(end.getRed() - c.getRed()));
        int b = c.getBlue() + (int)(percent * (float)(end.getBlue() - c.getBlue()));
        int g = c.getGreen() + (int)(percent * (float)(end.getGreen() - c.getGreen()));
        c = new Color(r, g, b);
        return c;
    }

    private void populatePdf(Document doc, ArrayList<ReportData.Section> section, int dim, Color color, float c) {
        for (ReportData.Section aSection : section) {
            int temp = 1;
            if (aSection.getHead().size() != 0) {
                temp = aSection.getHead().size();
            }
            PdfPTable data = new PdfPTable(temp);
            data.setWidthPercentage(90.0f);
            PdfPTable table = new PdfPTable(dim);
            table.setWidthPercentage(90.0f);
            Font myFont = FontFactory.getFont((String)"Helvetica", (float)8.0f, (Color)Color.WHITE);
            if (aSection.getDes() != null) {
                if (aSection.getParent() != null && aSection.getParent().getDes() != null) {
                    aSection.setDes(aSection.getParent().getDes().trim() + "." + aSection.getDes().trim());
                }
                PdfPCell row = new PdfPCell(new Phrase(aSection.getDes(), myFont));
                row.setBackgroundColor(color);
                row.setBorder(0);
                row.setBorder(2);
                row.setTop(100.0f);
                row.setColspan(dim);
                table.addCell(row);
                table.setSpacingAfter(1.0f);
            }
            if (aSection.getData() != null) {
                for (int x = 0; x < aSection.getHead().size(); ++x) {
                    PdfPCell cell = new PdfPCell(new Phrase(aSection.getHead().get(x), FontFactory.getFont((String)"Helvetica", (float)8.0f)));
                    cell.setBackgroundColor(WebColors.getRGBColor((String)"#B9D3EE"));
                    cell.setBorder(0);
                    cell.setBorder(2);
                    if (aSection.getData()[0][aSection.getData()[0].length - aSection.getHead().size() + x].getClass().equals(DataCell.class)) {
                        cell.setHorizontalAlignment(2);
                    } else {
                        cell.setHorizontalAlignment(0);
                    }
                    data.addCell(cell);
                }
                for (int t = 0; t < aSection.getData().length; ++t) {
                    for (int x = aSection.getData()[0].length - aSection.getHead().size(); x < aSection.getData()[0].length; ++x) {
                        PdfPCell cell = new PdfPCell(new Phrase(aSection.getData()[t][x].getFormattedValue(), FontFactory.getFont((String)"Helvetica", (float)8.0f)));
                        cell.setBorder(0);
                        cell.setBorder(2);
                        int r = t % 2;
                        if (r != 0) {
                            cell.setBackgroundColor(this.color(Color.BLACK, 0.92f));
                        }
                        if (aSection.getData()[t][x].getClass().equals(DataCell.class)) {
                            cell.setHorizontalAlignment(2);
                        } else {
                            cell.setHorizontalAlignment(0);
                        }
                        data.addCell(cell);
                    }
                }
            }
            try {
                doc.top(30.0f);
                doc.add((Element)table);
                doc.add((Element)data);
            }
            catch (DocumentException e) {
                log.error("Error creating PDF", (Throwable)e);
            }
            this.populatePdf(doc, aSection.getChild(), dim, this.color(color, c + 0.15f), c);
        }
    }
}

