/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import mondrian.olap.MondrianServer;
import mondrian.server.monitor.Monitor;
import mondrian.server.monitor.ServerInfo;
import org.saiku.web.rest.resources.MondrianStats;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/statistics")
public class StatisticsResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/mondrian")
    public MondrianStats getMondrianStats() {
        MondrianServer mondrianServer = MondrianServer.forId(null);
        if (mondrianServer != null) {
            MondrianServer.MondrianVersion mv = mondrianServer.getVersion();
            Monitor monitor = mondrianServer.getMonitor();
            ServerInfo server = monitor.getServer();
            int statementCurrentlyOpenCount = 0;
            int connectionCurrentlyOpenCount = 0;
            int sqlStatementCurrentlyOpenCount = 0;
            int statementCurrentlyExecutingCount = 0;
            float avgCellDimensionality = (float)server.cellCoordinateCount / (float)server.cellCount;
            List connections = monitor.getConnections();
            List statements = monitor.getStatements();
            return new MondrianStats(server, mv, statementCurrentlyOpenCount, connectionCurrentlyOpenCount, sqlStatementCurrentlyOpenCount, statementCurrentlyExecutingCount, avgCellDimensionality, connections, statements);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mondrian/server")
    public ServerInfo getMondrianServer() {
        MondrianServer mondrianServer = MondrianServer.forId(null);
        if (mondrianServer != null) {
            MondrianServer.MondrianVersion mv = mondrianServer.getVersion();
            Monitor monitor = mondrianServer.getMonitor();
            return monitor.getServer();
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/mondrian/server/version")
    public MondrianServer.MondrianVersion getMondrianServerVersion() {
        MondrianServer mondrianServer = MondrianServer.forId(null);
        if (mondrianServer != null) {
            return mondrianServer.getVersion();
        }
        return null;
    }
}

