/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.his.jackson.annotation.JsonAutoDetect;
import com.his.jackson.databind.ObjectMapper;
import com.qmino.miredot.annotations.ReturnType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.saiku.olap.dto.filter.SaikuFilter;
import org.saiku.service.ISessionService;
import org.saiku.service.olap.OlapQueryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/{username}/filters")
@XmlAccessorType(value=XmlAccessType.NONE)
public class FilterRepositoryResource {
    private static final Logger log = LoggerFactory.getLogger(FilterRepositoryResource.class);
    private static final String SETTINGS_FILE = "settings.properties";
    private static final String FILTER_FILENAME = "saiku.filters";
    private OlapQueryService olapQueryService;
    private ISessionService sessionService;

    public void setOlapQueryService(OlapQueryService olapqs) {
        this.olapQueryService = olapqs;
    }

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
    }

    private Map<String, SaikuFilter> getFiltersInternal() throws Exception {
        return this.getFiltersInternal(null);
    }

    private Map<String, SaikuFilter> getFiltersInternal(String query) {
        Map allFilters = new HashMap();
        if (StringUtils.isNotBlank((String)query)) {
            allFilters = this.olapQueryService.getValidFilters(query, allFilters);
        }
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/names/")
    @ReturnType(value="java.lang.List<String>")
    public Response getSavedFilterNames(@QueryParam(value="queryname") String queryName) {
        try {
            Map<String, SaikuFilter> allFilters = this.getFiltersInternal(queryName);
            ArrayList<String> filternames = new ArrayList<String>(allFilters.keySet());
            Collections.sort(filternames);
            return Response.ok(filternames).build();
        }
        catch (Exception e) {
            log.error("Cannot filter names", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSavedFilters(@QueryParam(value="query") String queryName, @QueryParam(value="filtername") String filterName) {
        try {
            Map<Object, Object> allFilters = new HashMap();
            if (StringUtils.isNotBlank((String)queryName)) {
                allFilters = this.getFiltersInternal(queryName);
            } else if (StringUtils.isNotBlank((String)filterName)) {
                allFilters = this.getFiltersInternal();
                HashMap<String, Object> singleFilter = new HashMap<String, Object>();
                if (allFilters.containsKey(filterName)) {
                    singleFilter.put(filterName, allFilters.get(filterName));
                    allFilters = singleFilter;
                }
            } else {
                allFilters = this.getFiltersInternal();
            }
            return Response.ok(allFilters).build();
        }
        catch (Exception e) {
            log.error("Cannot get filter details", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{filtername}")
    @ReturnType(value="org.saiku.olap.dto.filter.SaikuFilter")
    public Response saveFilter(@FormParam(value="filter") String filterJSON) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setVisibilityChecker(mapper.getVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
            SaikuFilter filter = (SaikuFilter)mapper.readValue(filterJSON, SaikuFilter.class);
            String username = this.sessionService.getAllSessionObjects().get("username").toString();
            filter.setOwner(username);
            Map<String, SaikuFilter> filters = this.getFiltersInternal();
            filters.put(filter.getName(), filter);
            return Response.ok((Object)filter).build();
        }
        catch (Exception e) {
            log.error("Cannot save filter (" + filterJSON + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return Response.serverError().entity((Object)error).build();
        }
    }
}

